/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wao.ui.pages;

import fr.ifremer.wao.WaoBusinessException;
import fr.ifremer.wao.WaoException;
import fr.ifremer.wao.bean.ConnectedUser;
import fr.ifremer.wao.bean.ContactFilter;
import fr.ifremer.wao.bean.ContactFilterImpl;
import fr.ifremer.wao.bean.ContactState;
import fr.ifremer.wao.bean.ObsProgram;
import fr.ifremer.wao.bean.UserRole;
import fr.ifremer.wao.bean.ValidationResult;
import fr.ifremer.wao.entity.Contact;
import fr.ifremer.wao.entity.TerrestrialLocation;
import fr.ifremer.wao.entity.WaoUser;
import fr.ifremer.wao.service.ServiceContact;
import fr.ifremer.wao.service.ServiceReferential;
import fr.ifremer.wao.service.ServiceUser;
import fr.ifremer.wao.ui.components.Layout;
import fr.ifremer.wao.ui.data.RequiresAuthentication;
import fr.ifremer.wao.ui.pages.Contacts;
import fr.ifremer.wao.ui.services.WaoManager;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry5.Block;
import org.apache.tapestry5.EventContext;
import org.apache.tapestry5.SelectModel;
import org.apache.tapestry5.annotations.Component;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.Import;
import org.apache.tapestry5.annotations.InjectComponent;
import org.apache.tapestry5.annotations.InjectPage;
import org.apache.tapestry5.annotations.Log;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.corelib.components.Form;
import org.apache.tapestry5.corelib.components.Zone;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.services.PropertyAccess;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;
import org.apache.tapestry5.util.EnumSelectModel;
import org.chenillekit.tapestry.core.components.DateTimeField;
import org.slf4j.Logger;

@RequiresAuthentication(allowedRoles={UserRole.ADMIN, UserRole.COORDINATOR, UserRole.OBSERVER}, readOnlyAllowed=false)
@Import(stylesheet={"context:css/common.css", "context:css/contactForm.css"}, library={"context:js/contactForm.js"})
public class ContactForm {
    @Inject
    private PropertyAccess propertyAccess;
    @Inject
    private Logger logger;
    @InjectComponent
    private Layout layout;
    @SessionState
    @Property
    private ConnectedUser connectedUser;
    @Inject
    private WaoManager manager;
    @Inject
    private ServiceContact serviceContact;
    @Inject
    private ServiceUser serviceUser;
    @Environmental
    private JavaScriptSupport javascriptSupport;
    @InjectComponent
    private Zone globalZone;
    @Persist
    private String contactId;
    @Persist
    private Contact contact;
    @InjectComponent
    private Form contactForm;
    @Inject
    private Block viewObservers;
    @Inject
    private Block editObservers;
    @Property
    private WaoUser observer;
    @Component
    private DateTimeField beginDate;
    @Component
    private DateTimeField endDate;
    @Inject
    private Block viewObservationReport;
    @Inject
    private Block editObservationReport;
    @Inject
    private ServiceReferential serviceReferential;
    @Persist
    private boolean saveContact;
    @Inject
    private Messages messages;
    @Property
    private boolean sendEmail;
    @InjectPage
    private Contacts contacts;

    public String getDateTimeFormatPattern() {
        return "dd/MM/yyyy HH:mm";
    }

    public DateFormat getDateTimeFormat() {
        return new SimpleDateFormat(this.getDateTimeFormatPattern());
    }

    public DateFormat getDateFormat() {
        return new SimpleDateFormat("dd/MM/yyyy");
    }

    public DateFormat getMonthYearFormat() {
        return new SimpleDateFormat("MM/yyyy");
    }

    void onActivate(EventContext eventContext) {
        if (eventContext.getCount() > 0) {
            this.contactId = (String)eventContext.get(String.class, 0);
        }
    }

    String onPassivate() {
        return this.contactId;
    }

    void setupRender() throws WaoException {
        this.contact = null;
        this.getContact();
    }

    @Log
    void afterRender() {
        this.addSendEmailScript();
    }

    protected void addSendEmailScript() {
        if (ObsProgram.OBSMER == this.getContact().getObsProgram() && !this.getContact().getEmailSent()) {
            String confirmMessage = "Souhaitez vous envoyer un email de demande d\\'ajout du navire \u00e0 votre portefeuille Allegro afin de pouvoir saisir les donn\u00e9es ?";
            this.javascriptSupport.addScript("new ContactSendEmail('%s', '%s');", new Object[]{confirmMessage, ContactState.OBSERVATION_DONE.name()});
            this.javascriptSupport.addScript("new ContactSendEmail('%s', '%s');", new Object[]{confirmMessage, ContactState.OBSERVATION_EXPECTED.name()});
        }
    }

    @Log
    public Contact getContact() {
        if (this.contact == null) {
            if (StringUtils.isEmpty((String)this.contactId)) {
                throw new IllegalStateException();
            }
            this.contact = this.serviceContact.getContact(this.contactId);
        }
        return this.contact;
    }

    public String getBoatDescription() {
        return this.manager.getTooltipBoat(this.contact.getBoat());
    }

    public Block getViewOrEditObservers() {
        Block result = this.viewObservers;
        if (this.connectedUser.isCoordinatorOrObserver() && this.contact.getValidationCompany() == null) {
            result = this.editObservers;
        }
        return result;
    }

    public List<WaoUser> getObservers() {
        List observers = this.serviceUser.getObservers(this.connectedUser.getCompany(), true);
        return observers;
    }

    public Block getViewOrEditObservationReport() {
        Block result = this.viewObservationReport;
        if (this.connectedUser.isCoordinatorOrObserver() && this.contact.getValidationCompany() == null) {
            result = this.editObservationReport;
        }
        return result;
    }

    public List<TerrestrialLocation> getTerrestrialLocations() {
        List locations = this.serviceReferential.getAllTerrestrialLocations((ContactFilter)new ContactFilterImpl(), this.contact.getSampleRow().getTerrestrialLocation().getDistrictCode());
        return locations;
    }

    public SelectModel getContactStateSelectModel() {
        List allowedStates = ContactState.getAllowedStates((ObsProgram)this.contact.getObsProgram());
        return new EnumSelectModel(ContactState.class, this.messages, (Enum[])allowedStates.toArray(new ContactState[allowedStates.size()]));
    }

    public boolean showDataReliability() {
        return this.getContact().getObsProgram() == ObsProgram.OBSMER && (this.connectedUser.isAdmin() || this.connectedUser.isCoordinator());
    }

    public boolean canEditDataReliability() {
        boolean result = this.connectedUser.isAdmin() && BooleanUtils.isTrue((Boolean)this.getContact().getValidationCompany()) && this.getContact().getValidationProgram() == null;
        return result;
    }

    @Log
    public void onSelectedFromRevertContact() {
        this.saveContact = false;
    }

    @Log
    public void onSelectedFromSaveContact() {
        this.saveContact = true;
    }

    @Log
    void onValidateFormFromContactForm() {
        this.contactForm.clearErrors();
        ValidationResult validationResult = this.serviceContact.validateContact(this.contact);
        if (!validationResult.isSuccess()) {
            this.contactForm.recordError(validationResult.getMessage());
        }
    }

    @Log
    Object onFailureFromContactForm() {
        return this.contactForm;
    }

    @Log
    Object onSuccessFromContactForm() {
        if (this.saveContact) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Contact save : " + this.contact);
                this.logger.debug("secondary observers : " + this.contact.getSecondaryObservers());
                this.logger.debug("Contact sendEmail : " + this.sendEmail);
            }
            this.serviceContact.saveContact(this.connectedUser, this.contact, false);
            try {
                if (this.sendEmail && this.serviceContact.sendContactDoneEmail(this.contact)) {
                    this.layout.addInfo("Un email a \u00e9t\u00e9 envoy\u00e9 pour l'ajout du navire au portefeuille ALLEGRO.");
                }
            }
            catch (WaoBusinessException eee) {
                String message = this.manager.getErrorMessage(eee, this.messages, this.logger);
                this.layout.addError(new String[]{message});
            }
        } else {
            this.contact = null;
        }
        if (this.saveContact) {
            this.contacts.setContactSelectedId(this.contact.getTopiaId());
            return this.contacts;
        }
        return this;
    }

    public String getLabelForEnum(Enum value) {
        return this.messages.get(value.getDeclaringClass().getSimpleName() + "." + value.name());
    }

    public String getMammalsInfoBoxStyle() {
        if (!this.contact.isMammalsCapture()) {
            return "display: none;";
        }
        return "";
    }
}

