/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wao.ui.services;

import fr.ifremer.wao.WaoBusinessException;
import fr.ifremer.wao.WaoContext;
import fr.ifremer.wao.WaoException;
import fr.ifremer.wao.WaoProperty;
import fr.ifremer.wao.service.ServiceUser;
import java.util.Date;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.services.RegistryShutdownListener;
import org.nuiton.util.ApplicationConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WaoManager
implements Runnable,
RegistryShutdownListener {
    private static final Logger log = LoggerFactory.getLogger(WaoManager.class);
    private WaoContext context;
    private ServiceUser serviceUser;

    public WaoManager(WaoContext context) {
        this.context = context;
    }

    void setServiceUser(ServiceUser serviceUser) {
        this.serviceUser = serviceUser;
    }

    @Override
    public void run() {
        this.context.start(this.serviceUser);
    }

    public void registryDidShutdown() {
        this.context.stop();
    }

    WaoContext getContext() {
        return this.context;
    }

    public boolean isActivityCalendarImportRun() {
        return this.context.isActivityCalendarImportRun();
    }

    public String getProperty(WaoProperty property) {
        return this.context.getProperty(property);
    }

    public ApplicationConfig getConfiguration() {
        return this.context.getConfiguration();
    }

    public Date getCurrentDate() {
        return this.context.getCurrentDate();
    }

    public boolean isDevEnvironment() {
        return log.isDebugEnabled();
    }

    public String[] getErrorMessages(WaoException eee, Messages messages, Logger logger) {
        String[] results = null;
        String cause = null;
        if (eee.getCause() != null && this.isDevEnvironment()) {
            cause = eee.getCause().getClass().getSimpleName() + " : " + eee.getCause().getMessage();
            results = new String[2];
            results[1] = cause;
        } else {
            results = new String[1];
        }
        if (logger.isDebugEnabled()) {
            logger.debug("ERROR from business : " + eee.getMessage() + " _ args = " + eee.getArgs());
            if (cause != null) {
                logger.debug("ERROR caused by : " + cause);
            }
        }
        results[0] = eee.getArgs() != null ? messages.format(eee.getMessage(), eee.getArgs()) : messages.get(eee.getMessage());
        return results;
    }

    public String getErrorMessage(WaoBusinessException eee, Messages messages, Logger logger) {
        if (logger.isDebugEnabled()) {
            logger.debug("ERROR from business : " + eee.getMessage());
        }
        return eee.getMessage();
    }
}

