/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.mexico;

import fr.ifremer.isisfish.IsisFishDAOHelper;
import fr.ifremer.isisfish.IsisFishException;
import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.datastore.CodeSourceStorage;
import fr.ifremer.isisfish.datastore.RuleStorage;
import fr.ifremer.isisfish.mexico.xml.DesignPlanXMLVisitor;
import fr.ifremer.isisfish.mexico.xml.DomXMLParser;
import fr.ifremer.isisfish.rule.Rule;
import fr.ifremer.isisfish.rule.RuleHelper;
import fr.ifremer.isisfish.simulator.sensitivity.DesignPlan;
import fr.ifremer.isisfish.types.Month;
import fr.ifremer.isisfish.types.TimeStep;
import fr.ifremer.isisfish.util.converter.ConverterUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.Transformer;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.text.StringEscapeUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.nuiton.math.matrix.MatrixFactory;
import org.nuiton.math.matrix.MatrixIterator;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaEntity;
import org.xml.sax.InputSource;

public class MexicoHelper {
    private static Log log = LogFactory.getLog(MexicoHelper.class);

    public static String getDesignPlanAsXML(DesignPlan designPlan, String ... args) {
        DesignPlanXMLVisitor visitor = new DesignPlanXMLVisitor(args);
        designPlan.accept(visitor);
        String designPlanXml = visitor.getXML();
        designPlanXml = MexicoHelper.formatXML(designPlanXml);
        return designPlanXml;
    }

    public static void writeDesignPlanToFile(File file, DesignPlan designPlan) {
        String content = MexicoHelper.getDesignPlanAsXML(designPlan, new String[0]);
        try {
            FileUtils.writeStringToFile((File)file, (String)content, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException ex) {
            throw new IsisFishRuntimeException("Can't export factors to xml file", ex);
        }
    }

    public static DesignPlan getDesignPlanFromXML(File xmlFile, TopiaContext topiaContext) throws IOException {
        DesignPlan designPlan;
        try {
            SAXReader reader = new SAXReader();
            reader.setEncoding("utf-8");
            Document doc = reader.read(xmlFile);
            Element root = doc.getRootElement();
            designPlan = DomXMLParser.parseDesignPlan(root, topiaContext);
        }
        catch (DocumentException e) {
            throw new IOException(e);
        }
        return designPlan;
    }

    public static String formatXML(String unformattedXml) {
        try {
            Transformer serializer = SAXTransformerFactory.newInstance().newTransformer();
            serializer.setOutputProperty("indent", "yes");
            serializer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            SAXSource xmlSource = new SAXSource(new InputSource(new ByteArrayInputStream(unformattedXml.getBytes(StandardCharsets.UTF_8))));
            StreamResult res = new StreamResult(new ByteArrayOutputStream());
            serializer.transform(xmlSource, res);
            return new String(((ByteArrayOutputStream)res.getOutputStream()).toByteArray(), StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new IsisFishRuntimeException("Can't format xml", e);
        }
    }

    public static String getMatrixAsXML(MatrixND matrix) {
        if (matrix == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("<mx name=\"" + matrix.getName() + "\">");
        for (int dimIndex = 0; dimIndex < matrix.getDim().length; ++dimIndex) {
            List semantics = matrix.getSemantic(dimIndex);
            buffer.append("<dimension name=\"" + matrix.getDimensionName(dimIndex) + "\" size=\"" + semantics.size() + "\">");
            for (Object semantic : semantics) {
                buffer.append("<label>");
                MexicoHelper.appendString(buffer, semantic);
                buffer.append("</label>");
            }
            buffer.append("</dimension>");
        }
        MatrixIterator mi = matrix.iterator();
        while (mi.next()) {
            buffer.append("<d>" + mi.getValue() + "</d>");
        }
        buffer.append("</mx>");
        return buffer.toString();
    }

    protected static StringBuffer appendString(StringBuffer buffer, Object o) {
        if (o == null) {
            buffer.append("null()");
        } else {
            String qualifiedName = MexicoHelper.getQualifiedName(o);
            buffer.append(qualifiedName).append("(");
            ConvertUtilsBean beanUtils = ConverterUtil.getConverter(null);
            buffer.append(beanUtils.convert(o));
            buffer.append(")");
        }
        return buffer;
    }

    public static MatrixND getMatrixFromXml(Element mxElement, TopiaContext context) {
        String name = mxElement.attributeValue("name");
        ArrayList<String> dimNames = new ArrayList<String>();
        ArrayList semantics = new ArrayList();
        List dimensionElements = mxElement.elements("dimension");
        for (Element dimensionElement : dimensionElements) {
            String dimName = dimensionElement.attributeValue("name");
            dimNames.add(dimName);
            ArrayList<Object> semantic = new ArrayList<Object>();
            List labelElements = dimensionElement.elements("label");
            for (Element labelElement : labelElements) {
                String content = labelElement.getText();
                Object value = null;
                if (content != null) {
                    content = content.trim();
                    Pattern matrixPattern = Pattern.compile("^(.*)\\((.*)\\)$");
                    Matcher matcher = matrixPattern.matcher(content);
                    if (matcher.find()) {
                        String objectType = matcher.group(1);
                        String objectString = matcher.group(2);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Looking for object : " + objectType + ":" + objectString));
                        }
                        if (!"null".equals(objectType)) {
                            ConvertUtilsBean beanUtils = ConverterUtil.getConverter(context);
                            try {
                                value = beanUtils.convert(objectString, Class.forName(objectType));
                            }
                            catch (Exception e) {
                                value = objectType + "(" + objectString + ")";
                                if (log.isWarnEnabled()) {
                                    log.warn((Object)("Can't parse '" + content + "' as valid semantic"));
                                }
                            }
                        }
                    } else if (log.isWarnEnabled()) {
                        log.warn((Object)("Can't parse '" + content + "' as valid semantic"));
                    }
                }
                semantic.add(value);
            }
            semantics.add(semantic);
        }
        MatrixND result = MatrixFactory.getInstance().create(name, semantics.toArray(new List[0]), dimNames.toArray(new String[0]));
        MatrixIterator iterator = result.iterator();
        List values = mxElement.elements("d");
        for (Element value : values) {
            iterator.next();
            String text = value.getText().trim();
            double doubleValue = Double.parseDouble(text);
            iterator.setValue(doubleValue);
        }
        return result;
    }

    protected static String getQualifiedName(Object o) {
        String qualifiedName = o instanceof TopiaEntity ? TopiaEntity.class.getName() : o.getClass().getName();
        return qualifiedName;
    }

    public static String getRulesAsXml(List<Rule> rules) {
        StringBuilder ruleAsString = new StringBuilder();
        ruleAsString.append("<rules>");
        for (Rule rule : rules) {
            Properties props = RuleHelper.getRuleAsProperties(0, null, rule);
            ruleAsString.append("<rule name=\"");
            ruleAsString.append(rule.getClass().getSimpleName());
            ruleAsString.append("\">");
            for (String propName : props.stringPropertyNames()) {
                ruleAsString.append("<param key=\"");
                ruleAsString.append(propName);
                ruleAsString.append("\">");
                ruleAsString.append(StringEscapeUtils.escapeXml11((String)props.getProperty(propName)));
                ruleAsString.append("</param>");
            }
            ruleAsString.append("</rule>");
        }
        ruleAsString.append("</rules>");
        return ruleAsString.toString();
    }

    public static List<Rule> getRulesFromXml(Element rulesElement, TopiaContext topiaContext) {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        List ruleElements = rulesElement.elements("rule");
        for (Element ruleElement : ruleElements) {
            String name = ruleElement.attributeValue("name");
            try {
                Rule rule = (Rule)RuleStorage.getRule(name, new CodeSourceStorage.Location[0]).getNewInstance();
                Properties props = new Properties();
                List paramElements = ruleElement.elements("param");
                for (Element paramElement : paramElements) {
                    String key = paramElement.attributeValue("key");
                    String value = paramElement.getTextTrim();
                    props.setProperty(key, value);
                }
                RuleHelper.populateRule(0, topiaContext, rule, props);
                rules.add(rule);
            }
            catch (IsisFishException ex) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)("Can't make instance of rule " + name), (Throwable)ex);
            }
        }
        return rules;
    }

    public static Object getObjectFromString(String content, TopiaContext context) {
        Object result = null;
        int semiIndex = content.indexOf(58);
        if (semiIndex != -1) {
            String objectId;
            String clazzName;
            block9: {
                clazzName = content.substring(0, semiIndex);
                objectId = content.substring(semiIndex + 1);
                try {
                    Method m = IsisFishDAOHelper.class.getMethod("get" + clazzName + "DAO", TopiaContext.class);
                    TopiaDAO dao = (TopiaDAO)m.invoke(null, context);
                    result = dao.findByProperty("name", (Object)objectId);
                }
                catch (Exception ex) {
                    if (!log.isDebugEnabled()) break block9;
                    log.debug((Object)"Can't find object for topia entity", (Throwable)ex);
                }
            }
            if (result == null) {
                ConvertUtilsBean beanUtils = ConverterUtil.getConverter(null);
                if ("TimeStep".equals(clazzName)) {
                    result = beanUtils.convert(objectId, TimeStep.class);
                } else if ("Month".equals(clazzName)) {
                    result = beanUtils.convert(objectId, Month.class);
                }
            }
        } else {
            result = content;
        }
        if (result == null && log.isWarnEnabled()) {
            log.warn((Object)("Can't convert '" + content + "' to isis object"));
        }
        return result;
    }

    public static String getStringFromObject(Object object) {
        Object representation = null;
        if (object instanceof TopiaEntity) {
            try {
                String clazzName = object.getClass().getSimpleName();
                clazzName = StringUtils.removeEnd((String)clazzName, (String)"Impl");
                String name = BeanUtils.getProperty((Object)object, (String)"name");
                representation = clazzName + ":" + name;
            }
            catch (Exception ex) {
                if (log.isWarnEnabled()) {
                    log.error((Object)("No getName() method found on " + String.valueOf(object)), (Throwable)ex);
                }
            }
        } else if (object instanceof TimeStep || object instanceof Month) {
            ConvertUtilsBean beanUtils = ConverterUtil.getConverter(null);
            representation = object.getClass().getSimpleName() + ":" + beanUtils.convert(object);
        } else {
            representation = object.toString();
        }
        return representation;
    }
}

