/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.map;

import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMRect;
import com.bbn.openmap.proj.Projection;
import fr.ifremer.isisfish.map.Coordinate;
import fr.ifremer.isisfish.map.DataMap;
import fr.ifremer.isisfish.map.Scale;
import java.awt.Color;
import java.awt.Paint;
import java.io.Serializable;

public class Motif
implements Serializable {
    private static final long serialVersionUID = -2814583859271654759L;
    public static final Color defaultLineColor = new Color(0, true);
    public static final Color defaultFillcolor = new Color(65280);
    public static final float defaultAlpha = 0.5f;
    public static final String defaultLineColorString = "00000000";
    public static final String defaultFillColorString = "00ff00";
    protected Color lineColor;
    protected Color fillColor;
    protected float alpha = 0.5f;
    protected float width = 1.0f;
    protected float height = 0.5f;

    public Motif(Color fill, Color line, float alpha) {
        this.fillColor = fill;
        this.lineColor = line;
        this.alpha = alpha;
    }

    public Motif(Color fill, float alpha) {
        this(fill, defaultLineColor, alpha);
    }

    public Motif(Color fill) {
        this(fill, defaultLineColor, 0.5f);
    }

    public Motif() {
        this(defaultFillcolor, defaultLineColor, 0.5f);
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Color v) {
        this.lineColor = v;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(Color v) {
        this.fillColor = v;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void setAlpha(float v) {
        this.alpha = v;
    }

    public float getWidth() {
        return this.width;
    }

    public void setWidth(float v) {
        this.width = v;
    }

    public float getHeight() {
        return this.height;
    }

    public void setHeight(float v) {
        this.height = v;
    }

    public void setCellDimension(float width, float height) {
        this.width = width;
        this.height = height;
    }

    protected void createOMDataMap(Projection proj, OMGraphicList omlist, Scale sc, DataMap datamap) {
        if (datamap.getValue() != 0.0) {
            Coordinate[] coordinates;
            Color lColor;
            int rgb = sc.getValueAsRGB(datamap.getValue());
            if (rgb < 0) {
                rgb = 0;
            }
            Color fColor = lColor = new Color(255 - rgb, 255 - rgb, 255 - rgb, 255);
            for (Coordinate coordinate : coordinates = datamap.getCoordinates()) {
                OMRect omrect = new OMRect((double)(coordinate.x + this.getHeight()), (double)coordinate.y, (double)coordinate.x, (double)(coordinate.y + this.getWidth()), 2);
                omrect.setLinePaint((Paint)lColor);
                omrect.setFillPaint((Paint)fColor);
                omlist.add((OMGraphic)omrect);
            }
        }
    }
}

