/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.datastore;

import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.datastore.CodeSourceStorage;
import fr.ifremer.isisfish.datastore.JavaSourceStorage;
import fr.ifremer.isisfish.datastore.StorageChangeListener;
import fr.ifremer.isisfish.export.ExportInfo;
import fr.ifremer.isisfish.vcs.VCSException;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.commons.collections4.map.ReferenceMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ExportStorage
extends JavaSourceStorage {
    private static Log log = LogFactory.getLog(ExportStorage.class);
    public static final String EXPORT_PATH = "exports";
    public static final String EXPORT_TEMPLATE = "templates/script/export.ftl";
    private static Map<String, ExportStorage> exportCache = new ReferenceMap();
    protected static Set<StorageChangeListener> storageListeners = Collections.newSetFromMap(new WeakHashMap());

    public static void addStorageListener(StorageChangeListener storageListener) {
        storageListeners.add(storageListener);
    }

    protected ExportStorage(File rootSrc, File directory, String name) {
        super(rootSrc, directory, name);
    }

    public static void registerWatcher() {
        ExportStorage.registerWatcher(storageListeners, ExportStorage.getExportDirectory(), ExportStorage.getCommunityExportDirectory());
    }

    @Override
    public String getPackage() {
        return EXPORT_PATH;
    }

    public static File getExportDirectory() {
        File result = new File(ExportStorage.getContextDatabaseDirectory(), EXPORT_PATH);
        result.mkdirs();
        return result;
    }

    public static File getCommunityExportDirectory() {
        File result = new File(ExportStorage.getCommunityDatabaseDirectory(), EXPORT_PATH);
        result.mkdirs();
        return result;
    }

    public static ExportStorage getExport(String name, CodeSourceStorage.Location ... location) {
        ExportStorage result = exportCache.get(name);
        if (result == null) {
            CodeSourceStorage.Location loc = ExportStorage.nonEmptyLocation(location);
            for (File dir : loc.getDirectories()) {
                ExportStorage storage = new ExportStorage(dir, new File(dir, EXPORT_PATH), name);
                if (!storage.getFile().isFile()) continue;
                result = storage;
                exportCache.put(name, result);
            }
        }
        return result;
    }

    public static ExportStorage createExport(String name, CodeSourceStorage.Location location) {
        File dir = location.getDirectories()[0];
        ExportStorage storage = new ExportStorage(dir, new File(dir, EXPORT_PATH), name);
        return storage;
    }

    public static List<String> getExportNames() {
        List<String> result = ExportStorage.getStorageNames(ExportStorage.getExportDirectory());
        result.addAll(ExportStorage.getStorageNames(ExportStorage.getCommunityExportDirectory()));
        return result;
    }

    public static void checkout() throws VCSException {
        ExportStorage.checkout(IsisFish.config.getDatabaseDirectory(), EXPORT_PATH);
    }

    @Override
    public String getDescription() {
        String result = null;
        try {
            ExportInfo export = (ExportInfo)this.getNewInstance();
            if (export != null) {
                result = export.getDescription();
            }
        }
        catch (Exception e) {
            log.warn((Object)I18n.t((String)"isisfish.error.not.found.description", (Object[])new Object[]{this}));
        }
        return result;
    }
}

