/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.Resource;

public class AboutDialog
extends JDialog
implements ActionListener,
HyperlinkListener {
    private static final Log log = LogFactory.getLog(AboutDialog.class);
    protected String iconPath;
    protected Color backgroundColor;
    protected String aboutHtmlText = "";
    protected String licenseText;

    public AboutDialog(Frame owner) {
        super(owner, true);
        this.setResizable(false);
    }

    public void setAboutHtmlText(String aboutHtmlText) {
        this.aboutHtmlText = aboutHtmlText;
    }

    public void setLicenseText(String licenseText) {
        this.licenseText = licenseText;
    }

    public void setIconPath(String iconPath) {
        this.iconPath = iconPath;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    protected void buildUI() {
        this.setLayout(new GridBagLayout());
        Component top = this.getTopPanel();
        this.add(top, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(1, 1, 1, 1), 0, 0));
        JTabbedPane tabPanel = new JTabbedPane();
        Component firstTab = this.getAboutTab();
        tabPanel.add(I18n.t((String)"isisfish.aboutdialog.about", (Object[])new Object[0]), firstTab);
        if (this.licenseText != null) {
            Component secondTab = this.getLicenseTab();
            tabPanel.add(I18n.t((String)"isisfish.aboutdialog.license", (Object[])new Object[0]), secondTab);
        }
        this.add((Component)tabPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        JButton okButton = new JButton(I18n.t((String)"isisfish.aboutdialog.ok", (Object[])new Object[0]));
        okButton.setActionCommand("ok");
        okButton.addActionListener(this);
        this.add((Component)okButton, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 5, 5, 5), 20, 0));
        if (this.backgroundColor != null) {
            this.getContentPane().setBackground(this.backgroundColor);
        }
    }

    protected Component getTopPanel() {
        JLabel labelIcon;
        if (this.iconPath != null) {
            ImageIcon logoIcon = Resource.getIcon((String)this.iconPath);
            labelIcon = new JLabel(logoIcon);
        } else {
            labelIcon = new JLabel();
        }
        return labelIcon;
    }

    protected Component getLicenseTab() {
        JTextArea licenseArea = new JTextArea();
        licenseArea.setLineWrap(true);
        licenseArea.setWrapStyleWord(true);
        licenseArea.setText(this.licenseText);
        licenseArea.setEditable(false);
        return licenseArea;
    }

    protected Component getAboutTab() {
        JEditorPane htmlAbout = new JEditorPane("text/html", this.aboutHtmlText);
        htmlAbout.addHyperlinkListener(this);
        htmlAbout.setEditable(false);
        return htmlAbout;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if ("ok".equals(command)) {
            this.setVisible(false);
        }
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent he) {
        block4: {
            if (he.getEventType() == HyperlinkEvent.EventType.ACTIVATED && Desktop.isDesktopSupported()) {
                try {
                    URL u = he.getURL();
                    if (u.getProtocol().equalsIgnoreCase("mailto") || u.getProtocol().equalsIgnoreCase("http") || u.getProtocol().equalsIgnoreCase("ftp")) {
                        Desktop.getDesktop().browse(u.toURI());
                    }
                }
                catch (IOException | URISyntaxException e) {
                    if (!log.isErrorEnabled()) break block4;
                    log.error((Object)"Error while opening link", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.buildUI();
        }
        super.setVisible(b);
    }
}

