/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.input.setofvessels;

import fr.ifremer.isisfish.IsisFishDAOHelper;
import fr.ifremer.isisfish.entities.EffortDescription;
import fr.ifremer.isisfish.entities.EffortDescriptionDAO;
import fr.ifremer.isisfish.entities.Metier;
import fr.ifremer.isisfish.entities.SetOfVessels;
import fr.ifremer.isisfish.ui.input.InputContentHandler;
import fr.ifremer.isisfish.ui.input.setofvessels.EffortDescriptionUI;
import fr.ifremer.isisfish.ui.models.common.GenericListModel;
import fr.ifremer.isisfish.ui.util.ErrorHelper;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class EffortDescriptionHandler
extends InputContentHandler<EffortDescriptionUI> {
    private static final Log log = LogFactory.getLog(EffortDescriptionHandler.class);

    protected EffortDescriptionHandler(EffortDescriptionUI inputContentUI) {
        super(inputContentUI);
    }

    protected void afterInit() {
        ((EffortDescriptionUI)this.inputContentUI).addPropertyChangeListener("bean", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                GenericListModel metierModel = (GenericListModel)((EffortDescriptionUI)((EffortDescriptionHandler)EffortDescriptionHandler.this).inputContentUI).fieldEffortDescriptionMetierList.getModel();
                if (evt.getNewValue() == null) {
                    metierModel.setElementList(null);
                }
                if (evt.getNewValue() != null) {
                    metierModel.setElementList(((EffortDescriptionUI)EffortDescriptionHandler.this.inputContentUI).getFisheryRegion().getMetier());
                    EffortDescriptionHandler.this.setEffortDescriptionEffortDescriptionList();
                }
            }
        });
    }

    protected void onFieldEffortDescriptionMetierListValueChanged() {
        if (((EffortDescriptionUI)this.inputContentUI).isActive().booleanValue()) {
            ((EffortDescriptionUI)this.inputContentUI).buttonEffortDescriptionAdd.setEnabled(((EffortDescriptionUI)this.inputContentUI).fieldEffortDescriptionMetierList.getSelectedIndex() != -1);
        }
    }

    protected void onFieldEffortDescriptionEffortDescriptionListValueChanged() {
        if (((EffortDescriptionUI)this.inputContentUI).isActive().booleanValue()) {
            ((EffortDescriptionUI)this.inputContentUI).removeEffortDescriptionButton.setEnabled(((EffortDescriptionUI)this.inputContentUI).fieldEffortDescriptionEffortDescriptionList.getSelectedIndex() != -1);
        }
    }

    protected void setEffortDescriptionEffortDescriptionList() {
        GenericListModel<EffortDescription> model = new GenericListModel<EffortDescription>();
        if (((EffortDescriptionUI)this.inputContentUI).getBean() != null && ((EffortDescriptionUI)this.inputContentUI).getBean().getPossibleMetiers() != null) {
            ArrayList<EffortDescription> effortDescriptions = new ArrayList<EffortDescription>(((EffortDescriptionUI)this.inputContentUI).getBean().getPossibleMetiers());
            model.setElementList(effortDescriptions);
        }
        ((EffortDescriptionUI)this.inputContentUI).fieldEffortDescriptionEffortDescriptionList.setModel(model);
    }

    protected void addEffortDescriptions() {
        List<Metier> selectedValues = ((EffortDescriptionUI)this.inputContentUI).fieldEffortDescriptionMetierList.getSelectedValuesList();
        for (Metier selectedMetier : selectedValues) {
            this.addEffortDescription(((EffortDescriptionUI)this.inputContentUI).getBean(), selectedMetier);
        }
        this.setEffortDescriptionEffortDescriptionList();
    }

    protected void removeEffortDescriptions() {
        List<EffortDescription> selectedValues = ((EffortDescriptionUI)this.inputContentUI).fieldEffortDescriptionEffortDescriptionList.getSelectedValuesList();
        for (EffortDescription selectedEffortDescription : selectedValues) {
            this.removeEffortDescription(((EffortDescriptionUI)this.inputContentUI).getBean(), selectedEffortDescription);
        }
        this.setEffortDescriptionEffortDescriptionList();
    }

    public void addEffortDescription(SetOfVessels setOfVessels, Metier metier) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("addEffortDescription called: " + setOfVessels + " metier: " + metier));
        }
        try {
            EffortDescriptionDAO effortDescriptionPS = IsisFishDAOHelper.getEffortDescriptionDAO(metier.getTopiaContext());
            EffortDescription effortDescription = (EffortDescription)effortDescriptionPS.create(new Object[0]);
            effortDescription.setSetOfVessels(setOfVessels);
            effortDescription.setPossibleMetiers(metier);
            effortDescription.update();
            setOfVessels.addPossibleMetiers(effortDescription);
            setOfVessels.update();
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't create EffortDescription", (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n.t((String)"isisfish.error.input.addentity", (Object[])new Object[]{"EffortDescription"}), eee);
        }
    }

    public void removeEffortDescription(SetOfVessels sov, EffortDescription effort) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"removeEffortDescription called");
        }
        try {
            sov.removePossibleMetiers(effort);
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)("Can't remove entity: " + effort), (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n.t((String)"isisfish.error.input.removeentity", (Object[])new Object[]{"EffortDescription"}), eee);
        }
    }
}

