/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.input.population;

import fr.ifremer.isisfish.entities.PopulationGroup;
import fr.ifremer.isisfish.entities.PopulationSeasonInfo;
import fr.ifremer.isisfish.entities.Zone;
import fr.ifremer.isisfish.ui.input.InputContentHandler;
import fr.ifremer.isisfish.ui.input.population.PopulationMigrationEmigrationUI;
import fr.ifremer.isisfish.ui.models.common.GenericComboModel;
import fr.ifremer.isisfish.ui.util.ErrorHelper;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.math.matrix.gui.MatrixPanelEvent;

public class PopulationMigrationEmigrationHandler
extends InputContentHandler<PopulationMigrationEmigrationUI> {
    private static final Log log = LogFactory.getLog(PopulationMigrationEmigrationHandler.class);

    protected PopulationMigrationEmigrationHandler(PopulationMigrationEmigrationUI inputContentUI) {
        super(inputContentUI);
    }

    protected void afterInit() {
        ((PopulationMigrationEmigrationUI)this.inputContentUI).addPropertyChangeListener("bean", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() == null) {
                    ((PopulationMigrationEmigrationUI)((PopulationMigrationEmigrationHandler)PopulationMigrationEmigrationHandler.this).inputContentUI).fieldPopulationMigrationEmigrationCoefficient.setText("");
                    ((PopulationMigrationEmigrationUI)((PopulationMigrationEmigrationHandler)PopulationMigrationEmigrationHandler.this).inputContentUI).populationMigrationEmigrationTable.setMatrix(null);
                }
                if (evt.getNewValue() != null) {
                    // empty if block
                }
                PopulationMigrationEmigrationHandler.this.setFieldPopulationMigrationMigrationGroupChooserModel();
                PopulationMigrationEmigrationHandler.this.setFieldPopulationMigrationMigrationDepartureZoneChooserModel();
                PopulationMigrationEmigrationHandler.this.setAddButton();
            }
        });
    }

    public void init(PopulationSeasonInfo pi) {
        ((PopulationMigrationEmigrationUI)this.inputContentUI).populationMigrationEmigrationTable.setMatrix(((PopulationMigrationEmigrationUI)this.inputContentUI).getPopInfo().getEmigrationMatrix().copy());
    }

    protected void populationMigrationEmigrationMatrixChanged(MatrixPanelEvent event) {
        ((PopulationMigrationEmigrationUI)this.inputContentUI).remove.setEnabled(((PopulationMigrationEmigrationUI)this.inputContentUI).populationMigrationEmigrationTable.getTable().getSelectedRow() != -1);
        if (((PopulationMigrationEmigrationUI)this.inputContentUI).popInfo != null) {
            ((PopulationMigrationEmigrationUI)this.inputContentUI).popInfo.setMigrationMatrix(((PopulationMigrationEmigrationUI)this.inputContentUI).populationMigrationEmigrationTable.getMatrix().clone());
        }
    }

    protected void setFieldPopulationMigrationMigrationGroupChooserModel() {
        GenericComboModel<PopulationGroup> groups = new GenericComboModel<PopulationGroup>();
        if (((PopulationMigrationEmigrationUI)this.inputContentUI).getBean() != null && ((PopulationMigrationEmigrationUI)this.inputContentUI).getBean().getPopulationGroup() != null) {
            groups.setElementList(((PopulationMigrationEmigrationUI)this.inputContentUI).getBean().getPopulationGroup());
        }
        ((PopulationMigrationEmigrationUI)this.inputContentUI).fieldPopulationMigrationEmigrationGroupChooser.setModel(groups);
    }

    protected void setFieldPopulationMigrationMigrationDepartureZoneChooserModel() {
        GenericComboModel<Zone> zones = new GenericComboModel<Zone>();
        if (((PopulationMigrationEmigrationUI)this.inputContentUI).getBean() != null && ((PopulationMigrationEmigrationUI)this.inputContentUI).getBean().getPopulationZone() != null) {
            zones.setElementList(((PopulationMigrationEmigrationUI)this.inputContentUI).getBean().getPopulationZone());
        }
        ((PopulationMigrationEmigrationUI)this.inputContentUI).fieldPopulationMigrationEmigrationDepartureZoneChooser.setModel(zones);
    }

    protected void add() {
        this.addEmigration(((PopulationMigrationEmigrationUI)this.inputContentUI).getPopInfo(), (PopulationGroup)((PopulationMigrationEmigrationUI)this.inputContentUI).fieldPopulationMigrationEmigrationGroupChooser.getSelectedItem(), (Zone)((PopulationMigrationEmigrationUI)this.inputContentUI).fieldPopulationMigrationEmigrationDepartureZoneChooser.getSelectedItem(), Double.parseDouble(((PopulationMigrationEmigrationUI)this.inputContentUI).fieldPopulationMigrationEmigrationCoefficient.getText()));
        ((PopulationMigrationEmigrationUI)this.inputContentUI).populationMigrationEmigrationTable.setMatrix(((PopulationMigrationEmigrationUI)this.inputContentUI).getPopInfo().getEmigrationMatrix().clone());
    }

    public Object addEmigration(PopulationSeasonInfo info, PopulationGroup group, Zone departure, double coeff) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"addEmigration called");
        }
        try {
            MatrixND mat = info.getEmigrationMatrix().copy();
            mat.setValue((Object)group, (Object)departure, coeff);
            info.setEmigrationMatrix(mat);
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't add emigration", (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n.t((String)"isisfish.error.input.addentity", (Object[])new Object[]{"Emigration"}), eee);
        }
        return null;
    }

    protected void remove() {
        int row = ((PopulationMigrationEmigrationUI)this.inputContentUI).populationMigrationEmigrationTable.getTable().getSelectedRow();
        if (row != -1) {
            Object group = ((PopulationMigrationEmigrationUI)this.inputContentUI).populationMigrationEmigrationTable.getTable().getValueAt(row, 0);
            Object arrival = ((PopulationMigrationEmigrationUI)this.inputContentUI).populationMigrationEmigrationTable.getTable().getValueAt(row, 1);
            MatrixND mat = ((PopulationMigrationEmigrationUI)this.inputContentUI).popInfo.getEmigrationMatrix().clone();
            mat.setValue(group, arrival, 0.0);
            ((PopulationMigrationEmigrationUI)this.inputContentUI).popInfo.setEmigrationMatrix(mat);
            ((PopulationMigrationEmigrationUI)this.inputContentUI).populationMigrationEmigrationTable.setMatrix(((PopulationMigrationEmigrationUI)this.inputContentUI).getPopInfo().getEmigrationMatrix().copy());
        }
    }

    protected void setAddButton() {
        ((PopulationMigrationEmigrationUI)this.inputContentUI).add.setEnabled(((PopulationMigrationEmigrationUI)this.inputContentUI).isActive() != false && ((PopulationMigrationEmigrationUI)this.inputContentUI).fieldPopulationMigrationEmigrationGroupChooser.getSelectedItem() != null && ((PopulationMigrationEmigrationUI)this.inputContentUI).fieldPopulationMigrationEmigrationDepartureZoneChooser.getSelectedItem() != null && !((PopulationMigrationEmigrationUI)this.inputContentUI).fieldPopulationMigrationEmigrationCoefficient.getText().equals(""));
    }
}

