/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.config;

import fr.ifremer.isisfish.ui.config.RConfigUI;
import java.awt.Color;
import java.io.File;
import javax.swing.JOptionPane;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.j2r.RException;
import org.nuiton.j2r.RProxy;

public class RConfigHandler {
    private static Log log = LogFactory.getLog(RConfigHandler.class);
    protected RConfigUI rconfigUI;

    public RConfigHandler(RConfigUI rconfigUI) {
        this.rconfigUI = rconfigUI;
    }

    public void afterInit() {
        String rBinPath;
        String systemPath;
        String rHome = System.getenv("R_HOME");
        this.rconfigUI.getRHomeField().setText(rHome);
        if (StringUtils.isBlank((CharSequence)rHome)) {
            this.rconfigUI.getRHomeField().setBackground(Color.RED);
        }
        String rType = System.getProperty("R.type");
        this.rconfigUI.getRTypeField().setText(rType);
        if (!"net".equals(rType) && !"jni".equals(rType)) {
            this.rconfigUI.getRTypeField().setBackground(Color.RED);
        }
        if ((systemPath = System.getenv("PATH")).contains(rBinPath = rHome + File.separator + "bin")) {
            this.rconfigUI.getSystemPathField().setText(I18n.t((String)"isisfish.simulator.configuration.r.systempathok", (Object[])new Object[]{rBinPath}));
        } else {
            this.rconfigUI.getSystemPathField().setBackground(Color.RED);
            this.rconfigUI.getSystemPathField().setText(I18n.t((String)"isisfish.simulator.configuration.r.systempathnok", (Object[])new Object[]{rBinPath}));
        }
        this.rconfigUI.getSystemPathField().setToolTipText(systemPath);
    }

    public void testRCOnfiguration() {
        RProxy engine = null;
        try {
            engine = new RProxy();
            boolean error = false;
            try {
                engine.eval("library('lhs')");
            }
            catch (RException ex) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)"Can find 'lhs'", (Throwable)ex);
                }
                JOptionPane.showMessageDialog(this.rconfigUI, I18n.t((String)"isisfish.simulator.configuration.r.lhsnotinstalled", (Object[])new Object[0]), I18n.t((String)"isisfish.simulator.configuration.r.title", (Object[])new Object[0]), 0);
                error = true;
            }
            try {
                engine.eval("library('sensitivity')");
            }
            catch (RException ex) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)"Can find 'sensitivity'", (Throwable)ex);
                }
                JOptionPane.showMessageDialog(this.rconfigUI, I18n.t((String)"isisfish.simulator.configuration.r.sensitivitynotinstalled", (Object[])new Object[0]), I18n.t((String)"isisfish.simulator.configuration.r.title", (Object[])new Object[0]), 0);
                error = true;
            }
            if (!error) {
                JOptionPane.showMessageDialog(this.rconfigUI, I18n.t((String)"isisfish.simulator.configuration.r.testok", (Object[])new Object[0]), I18n.t((String)"isisfish.simulator.configuration.r.title", (Object[])new Object[0]), 1);
            }
        }
        catch (RException ex) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"Can find call R", (Throwable)ex);
            }
            JOptionPane.showMessageDialog(this.rconfigUI, I18n.t((String)"isisfish.simulator.configuration.r.cantinit", (Object[])new Object[]{ex.getMessage()}), I18n.t((String)"isisfish.simulator.configuration.r.title", (Object[])new Object[0]), 0);
        }
    }
}

