/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.simulator.sensitivity;

import fr.ifremer.isisfish.entities.Equation;
import fr.ifremer.isisfish.types.Month;
import fr.ifremer.isisfish.types.RangeOfValues;
import fr.ifremer.isisfish.types.TimeStep;
import fr.ifremer.isisfish.types.TimeUnit;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.topia.persistence.TopiaEntity;

public class SensitivityUtils {
    private static final Log log = LogFactory.getLog(SensitivityUtils.class);
    protected static final String PROPERTIES_PATH = "/sensitivity.properties";
    protected static Properties sensitivityProperties;

    public static String espaceFactorName(String factorName) {
        String name = StringUtils.stripAccents((String)factorName);
        name = name.replaceAll("\\W", "_");
        return name;
    }

    public static boolean isSensitivityFactorEnabled(String sensitivityFactorName) {
        Properties data = SensitivityUtils.getProperties();
        return data.getProperty(sensitivityFactorName) != null;
    }

    public static Properties getProperties() {
        block15: {
            if (sensitivityProperties == null) {
                sensitivityProperties = new Properties();
                try (InputStream stream = SensitivityUtils.class.getResourceAsStream(PROPERTIES_PATH);){
                    sensitivityProperties.load(stream);
                }
                catch (IOException ex) {
                    if (!log.isErrorEnabled()) break block15;
                    log.error((Object)"Can't load sensitivity properties file", (Throwable)ex);
                }
            }
        }
        return sensitivityProperties;
    }

    public static boolean canBeContinue(Object value) {
        boolean result = false;
        if (value instanceof Double) {
            result = true;
        } else if (value instanceof Long) {
            result = true;
        } else if (value instanceof Equation) {
            result = true;
        } else if (value instanceof MatrixND) {
            result = true;
        } else if (value instanceof RangeOfValues) {
            RangeOfValues rangeOfValues = (RangeOfValues)value;
            if (rangeOfValues.getType().equals("Float")) {
                result = true;
            }
        } else if (value instanceof TimeUnit) {
            result = true;
        } else if (value instanceof String) {
            result = true;
        }
        return result;
    }

    public static boolean isContinue(Object value) {
        String textValue;
        RangeOfValues range;
        boolean result = false;
        if (value instanceof RangeOfValues && (range = (RangeOfValues)value).getType().equals("Float") && (textValue = range.getValues()).matches("^\\ *[0-9]*\\ *\\-\\ *[0-9]*\\ *$")) {
            result = true;
        }
        return result;
    }

    public static boolean canBeFactor(Class type) {
        boolean result = false;
        if (TopiaEntity.class.isAssignableFrom(type)) {
            result = true;
        } else if (Double.TYPE.isAssignableFrom(type)) {
            result = true;
        } else if (Number.class.isAssignableFrom(type)) {
            result = true;
        } else if (TimeStep.class.isAssignableFrom(type)) {
            result = true;
        } else if (Month.class.isAssignableFrom(type)) {
            result = true;
        }
        return result;
    }
}

