package fr.ifremer.isisfish.ui.input.variable;

/*
 * #%L
 * ISIS-Fish
 * %%
 * Copyright (C) 1999 - 2015 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.isisfish.entities.Variable;
import fr.ifremer.isisfish.entities.VariableType;
import fr.ifremer.isisfish.ui.input.InputContentUI;
import fr.ifremer.isisfish.ui.input.equation.InputOneEquationUI;
import java.awt.CardLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.math.matrix.gui.MatrixPanelEditor;
import org.nuiton.topia.persistence.TopiaEntityContextable;
import static org.nuiton.i18n.I18n.t;

public class EntityVariableUI extends InputContentUI<org.nuiton.topia.persistence.TopiaEntityContextable> {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_VARIABLE = "variable";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_MATRIX_PANEL_ENABLED = "matrixPanel.enabled";
    public static final String BINDING_MATRIX_PANEL_MATRIX = "matrixPanel.matrix";
    public static final String BINDING_VARIABLES_LIST_ENABLED = "variablesList.enabled";
    public static final String BINDING_VARIABLE_COMMENT_ENABLED = "variableComment.enabled";
    public static final String BINDING_VARIABLE_COMMENT_TEXT = "variableComment.text";
    public static final String BINDING_VARIABLE_DOUBLE_VALUE_ENABLED = "variableDoubleValue.enabled";
    public static final String BINDING_VARIABLE_DOUBLE_VALUE_TEXT = "variableDoubleValue.text";
    public static final String BINDING_VARIABLE_ENTITY_NAME_ENABLED = "variableEntityName.enabled";
    public static final String BINDING_VARIABLE_EQUATION_VALUE_ACTIVE = "variableEquationValue.active";
    public static final String BINDING_VARIABLE_EQUATION_VALUE_BEAN = "variableEquationValue.bean";
    public static final String BINDING_VARIABLE_NAME_FIELD_ENABLED = "variableNameField.enabled";
    public static final String BINDING_VARIABLE_NAME_FIELD_TEXT = "variableNameField.text";
    public static final String BINDING_VARIABLE_TYPE_COMBO_ENABLED = "variableTypeCombo.enabled";
    public static final String BINDING_VARIABLE_TYPE_COMBO_SELECTED_ITEM = "variableTypeCombo.selectedItem";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JBUTTON0_ENABLED = "$JButton0.enabled";
    private static final String BINDING_$JBUTTON1_ENABLED = "$JButton1.enabled";
    private static final String BINDING_$JBUTTON2_ENABLED = "$JButton2.enabled";
    private static final String BINDING_$JLABEL0_ENABLED = "$JLabel0.enabled";
    private static final String BINDING_$JLABEL1_ENABLED = "$JLabel1.enabled";
    private static final String BINDING_$JLABEL2_ENABLED = "$JLabel2.enabled";
    private static final String BINDING_$JLABEL3_ENABLED = "$JLabel3.enabled";
    private static final String BINDING_$JLABEL4_ENABLED = "$JLabel4.enabled";
    private static final String BINDING_$JLABEL5_ENABLED = "$JLabel5.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKWXz28bRRTHJyZ2kiahbaKkKQRIWwNC0EmbtFCR0qZ1E2rLaUvzQxXh0FnvJN5qvbOdnU3WPSAE/wB/Aty5IHHjhDhw5tAL4l9AiANXxJvZH/Ym2/Wqk8PannnvM9/3dua9yQ9/obLH0bknJAgw9x1hdShu3Hr06L7xhLbEHeq1uOUKxlH4N1RCpV00bibjnkAXdpvSfTFyX6yxjssc6vR5rzTRCU90beq1KRUCvZH2aHne4mYyvRK4Po+piags6nf//F361vzq+xJCgQvq3oJQFgZ59SIZbqKSZQo0BSsdkEWbOPsgg1vOPuidlGM1m3jePdKhT9GXaKSJKi7hABPofPGQFUP5B65Ap6p1x/VFjTkCzLfrlwT6cI9ja4/TDoVPz/L2LK+NfQtb0hAfEG4Rw6Z4DZYS3Z3o53bddRW1ItCwQYkj0DLj+9jxLcEcLJhrEexSDjxYqEXxlhwJGWrxQEhMDzIaLyTQ21mCqHS1qIdjBT3XkTZxTJtygVZeJpS7oXcfr7olxyE1c6mX6R3Cq8FqTlqOHXW4LH+ekY+ZZGqy2thscWbbD4gjiWfkaw0iVN+UNJ/recVSvSbkT6DTKS85Jg1fS+zHqo3bvoDEwwrTKdtwOE2P5C5lyB2tNprEoDZwptJrylFpdCGxnYpFhumMt+m7aauYeDlj7nRMkL7rFrXhMMymlt2CfaImsqFLedCtrkvhYBhMoJkUVA3eZsELwpF+TdJlkLkwmZgcClwj3AxH3eyl5Fu0j6ZNDabXibK/nGT/o2NhLSdhfZzMTcdr3WE+PHeI7at047RZRL+SQ7+S0FeTufEOgcITRDF80HeSYaKNw1m8D0dpo2e4ZoIFT4Oi9a9mrD+T7JenPhEWc1QMAl3LPbQ0Msaqbt13Eu/tuuR+eiy8qxl7InUK1U6cTxucjLXB3uioCjtzbB/e4pRI83vHj51Cnk8jk8ml/kmOXk/VFGg9uNd6er1haBeVuQ/DUIR2j3erhzAV9qm5I31KAtXsf7PTz3/+86f1uDldhLVnMk37eis0DZczqNuy1EJaws7kC8te3CDuyi4a86gNjVk13vkMYZvRNIiD9VTdwtId3yVeGxDlkT9++XX28e+voNI6OmEzYq4TaV9HY6LNIQvMNgP35qpSNHE4Cs9TUptAFYNxUxb5V6+bRJAFw3JMeDc3AkjCfEYSEiXG2G//Tm/+uBonYgiEnX2heS8Z5c9RxXJsy6GqT0ctOLMvj7se9U3Wa7VZzXdIfp51o/LxhXo+zop0okVt+yF1IFqqjlcr8OWHqcTLb3uK9WYB1gh15LY2NTHlDjPDQqYBmQz3DpzdDaBpweQwyyGcKyBnWF5CoGBfD1/yAhFQ2Qxf0Bsvy5TDRo6qqnZc7xQifC0f3+gQ8jS8p014XzuKYoQ8DReLa9Ai5Gm4pJ2HYoQ8DUuFCEKLACUtPPrUrAva0WRVbHUNy6Fc087KJ9pvphghT8NN7R1ajJCnoaadh8EEaAwmdGHHg8Ygr5Q5sDXtgAYTYIOF111dCtxrrIO8Ntco0qTk/9aajAnJeBBe67o52S3CKrds8uyZpqCTe4x34OJZI4LuM66nadAGLEbI2zMb2hqKEfI0fFZkr3B26OWoGMwYVFCKEfLi2NLOZTFCnoYdbQ2S8D8JN40nuxQAAA==";
    private static final Log log = LogFactory.getLog(EntityVariableUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected TopiaEntityContextable bean;
    protected EntityVariableHandler handler;
    protected MatrixPanelEditor matrixPanel;
    protected Variable variable;
    protected JTextArea variableComment;
    protected JTextField variableDoubleValue;
    protected JLabel variableEntityName;
    protected InputOneEquationUI variableEquationValue;
    protected JTextField variableNameField;
    protected JComboBox<VariableType> variableTypeCombo;
    protected CardLayout variableTypeLayout;
    protected JPanel variableTypePanel;
    protected JList<Variable> variablesList;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private EntityVariableUI $InputContentUI0 = this;
    private JButton $JButton0;
    private JButton $JButton1;
    private JButton $JButton2;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JLabel $JLabel2;
    private JLabel $JLabel3;
    private JLabel $JLabel4;
    private JLabel $JLabel5;
    private JScrollPane $JScrollPane0;
    private JScrollPane $JScrollPane1;
    private Table $Table0;
    private Table $Table1;
    private Table $Table2;
    private Table $Table3;
    private Table $Table4;
    private Table $Table5;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $afterCompleteSetup() {
            handler.afterInit();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public EntityVariableUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EntityVariableUI(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public EntityVariableUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public EntityVariableUI(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EntityVariableUI() {
        $initialize();
    }

    public EntityVariableUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public EntityVariableUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public EntityVariableUI(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.addNewVariable(this);
    }

    public void doActionPerformed__on__$JButton1(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.deleteVariable(this);
    }

    public void doActionPerformed__on__$JButton2(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.saveVariable(this);
    }

    public void doActionPerformed__on__variableTypeCombo(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.showSelectedType(this);
    }

    public void doKeyReleased__on__variableComment(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getVariable().setComment(variableComment.getText());
    }

    public void doKeyReleased__on__variableNameField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getVariable().setName(variableNameField.getText());
    }

    public void doValueChanged__on__variablesList(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.showSelectedVariable(this);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public TopiaEntityContextable getBean() {
        return bean;
    }

    public EntityVariableHandler getHandler() {
        return handler;
    }

    public MatrixPanelEditor getMatrixPanel() {
        return matrixPanel;
    }

    public Variable getVariable() {
        return variable;
    }

    public JTextArea getVariableComment() {
        return variableComment;
    }

    public JTextField getVariableDoubleValue() {
        return variableDoubleValue;
    }

    public JLabel getVariableEntityName() {
        return variableEntityName;
    }

    public InputOneEquationUI getVariableEquationValue() {
        return variableEquationValue;
    }

    public JTextField getVariableNameField() {
        return variableNameField;
    }

    public JComboBox<VariableType> getVariableTypeCombo() {
        return variableTypeCombo;
    }

    public CardLayout getVariableTypeLayout() {
        return variableTypeLayout;
    }

    public JPanel getVariableTypePanel() {
        return variableTypePanel;
    }

    public JList<Variable> getVariablesList() {
        return variablesList;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(TopiaEntityContextable bean) {
        TopiaEntityContextable oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    public void setVariable(Variable variable) {
        Variable oldValue = this.variable;
        this.variable = variable;
        firePropertyChange(PROPERTY_VARIABLE, oldValue, variable);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton get$JButton0() {
        return $JButton0;
    }

    protected JButton get$JButton1() {
        return $JButton1;
    }

    protected JButton get$JButton2() {
        return $JButton2;
    }

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected JLabel get$JLabel4() {
        return $JLabel4;
    }

    protected JLabel get$JLabel5() {
        return $JLabel5;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected JScrollPane get$JScrollPane1() {
        return $JScrollPane1;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    protected Table get$Table1() {
        return $Table1;
    }

    protected Table get$Table2() {
        return $Table2;
    }

    protected Table get$Table3() {
        return $Table3;
    }

    protected Table get$Table4() {
        return $Table4;
    }

    protected Table get$Table5() {
        return $Table5;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToVariableTypePanel() {
        if (!allComponentsCreated) {
            return;
        }
        variableTypePanel.add($Table3, "doubletype");
        variableTypePanel.add($Table4, "matrixtype");
        variableTypePanel.add($Table5, "equationtype");
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new EntityVariableHandler(this));
    }

    protected void createMatrixPanel() {
        $objectMap.put("matrixPanel", matrixPanel = new MatrixPanelEditor());
        
        matrixPanel.setName("matrixPanel");
        matrixPanel.setDimensionEdit(true);
        matrixPanel.putClientProperty("sensitivityBean", fr.ifremer.isisfish.entities.Variable.class);
        matrixPanel.putClientProperty("sensitivityMethod", "MatrixValue");
    }

    protected void createVariable() {
        $objectMap.put("variable", variable = null);
    }

    protected void createVariableComment() {
        $objectMap.put("variableComment", variableComment = new JTextArea());
        
        variableComment.setName("variableComment");
        variableComment.setColumns(15);
        variableComment.setLineWrap(true);
        variableComment.setWrapStyleWord(true);
        variableComment.setRows(3);
        variableComment.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__variableComment"));
    }

    protected void createVariableDoubleValue() {
        $objectMap.put("variableDoubleValue", variableDoubleValue = new JTextField());
        
        variableDoubleValue.setName("variableDoubleValue");
        variableDoubleValue.setColumns(15);
        variableDoubleValue.putClientProperty("sensitivityBean", fr.ifremer.isisfish.entities.Variable.class);
        variableDoubleValue.putClientProperty("sensitivityMethod", "DoubleValue");
    }

    protected void createVariableEntityName() {
        $objectMap.put("variableEntityName", variableEntityName = new JLabel());
        
        variableEntityName.setName("variableEntityName");
    }

    protected void createVariableEquationValue() {
        $objectMap.put("variableEquationValue", variableEquationValue = new InputOneEquationUI(this));
        
        variableEquationValue.setName("variableEquationValue");
        variableEquationValue.setBeanProperty("EquationValue");
        variableEquationValue.setFormuleCategory("Variable");
        variableEquationValue.setText(t("isisfish.common.equation"));
        variableEquationValue.putClientProperty("sensitivityBean", fr.ifremer.isisfish.entities.Variable.class);
        variableEquationValue.putClientProperty("sensitivityMethod", "EquationValue");
    }

    protected void createVariableNameField() {
        $objectMap.put("variableNameField", variableNameField = new JTextField());
        
        variableNameField.setName("variableNameField");
        variableNameField.setColumns(15);
        variableNameField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__variableNameField"));
    }

    protected void createVariableTypeCombo() {
        $objectMap.put("variableTypeCombo", variableTypeCombo = new JComboBox<VariableType>());
        
        variableTypeCombo.setName("variableTypeCombo");
        variableTypeCombo.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__variableTypeCombo"));
    }

    protected void createVariableTypeLayout() {
        $objectMap.put("variableTypeLayout", variableTypeLayout = new CardLayout());
    }

    protected void createVariableTypePanel() {
        $objectMap.put("variableTypePanel", variableTypePanel = new JPanel());
        
        variableTypePanel.setName("variableTypePanel");
        variableTypePanel.setLayout(variableTypeLayout);
    }

    protected void createVariablesList() {
        $objectMap.put("variablesList", variablesList = new JList<Variable>());
        
        variablesList.setName("variablesList");
        variablesList.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__variablesList"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $InputContentUI0
        add($Table0);
        // inline complete setup of $Table0
        $Table0.add($Table1, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($Table2, new GridBagConstraints(1, 0, 1, 2, 3.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table1
        $Table1.add($JScrollPane0, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(SwingUtil.boxComponentWithJxLayer($JButton0), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(variablesList);
        // inline complete setup of $Table2
        $Table2.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(variableEntityName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(SwingUtil.boxComponentWithJxLayer(variableNameField), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JLabel2, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(SwingUtil.boxComponentWithJxLayer(variableTypeCombo), new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(variableTypePanel, new GridBagConstraints(0, 3, 2, 1, 1.0, 4.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JLabel5, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add($JScrollPane1, new GridBagConstraints(1, 4, 1, 1, 0.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(SwingUtil.boxComponentWithJxLayer($JButton1), new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(SwingUtil.boxComponentWithJxLayer($JButton2), new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToVariableTypePanel();
        // inline complete setup of $Table3
        $Table3.add($JLabel3, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table3.add(SwingUtil.boxComponentWithJxLayer(variableDoubleValue), new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 12, 2, new Insets(0, 0, 0, 0), 0, 0));
        // inline complete setup of $Table4
        $Table4.add($JLabel4, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        $Table4.add(SwingUtil.boxComponentWithJxLayer(matrixPanel), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        // inline complete setup of $Table5
        $Table5.add(SwingUtil.boxComponentWithJxLayer(variableEquationValue), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        // inline complete setup of $JScrollPane1
        $JScrollPane1.getViewport().add(SwingUtil.boxComponentWithJxLayer(variableComment));
        
        // apply 23 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 8 property setters
        $Table1.setBorder(BorderFactory.createTitledBorder(org.nuiton.i18n.I18n.t("isisfish.variables.variableslist")));
        variablesList.setCellRenderer(new VariableListRenderer());
        variablesList.setModel(new fr.ifremer.isisfish.ui.models.common.GenericListModel<Variable>());
        variablesList.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        $Table2.setBorder(BorderFactory.createTitledBorder(org.nuiton.i18n.I18n.t("isisfish.variables.variabledetail")));
        variableTypeCombo.setModel(new fr.ifremer.isisfish.ui.models.common.EnumComboModel<fr.ifremer.isisfish.entities.VariableType>(fr.ifremer.isisfish.entities.VariableType.class));
        variableEquationValue.setClazz(fr.ifremer.isisfish.equation.VariableEquation.class);
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$InputContentUI0", $InputContentUI0);
        createBean();
        createVariable();
        createHandler();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createVariablesList();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(t("isisfish.variables.addvariable"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $Table2
        $objectMap.put("$Table2", $Table2 = new Table());
        
        $Table2.setName("$Table2");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(t("isisfish.variables.entityname"));
        createVariableEntityName();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(t("isisfish.variables.variablename"));
        createVariableNameField();
        // inline creation of $JLabel2
        $objectMap.put("$JLabel2", $JLabel2 = new JLabel());
        
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(t("isisfish.variables.variabletype"));
        createVariableTypeCombo();
        createVariableTypeLayout();
        createVariableTypePanel();
        // inline creation of $Table3
        $objectMap.put("$Table3", $Table3 = new Table());
        
        $Table3.setName("$Table3");
        // inline creation of $JLabel3
        $objectMap.put("$JLabel3", $JLabel3 = new JLabel());
        
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(t("isisfish.variables.double.value"));
        createVariableDoubleValue();
        // inline creation of $Table4
        $objectMap.put("$Table4", $Table4 = new Table());
        
        $Table4.setName("$Table4");
        // inline creation of $JLabel4
        $objectMap.put("$JLabel4", $JLabel4 = new JLabel());
        
        $JLabel4.setName("$JLabel4");
        $JLabel4.setText(t("isisfish.variables.matrix.value"));
        createMatrixPanel();
        // inline creation of $Table5
        $objectMap.put("$Table5", $Table5 = new Table());
        
        $Table5.setName("$Table5");
        createVariableEquationValue();
        // inline creation of $JLabel5
        $objectMap.put("$JLabel5", $JLabel5 = new JLabel());
        
        $JLabel5.setName("$JLabel5");
        $JLabel5.setText(t("isisfish.variables.comment"));
        // inline creation of $JScrollPane1
        $objectMap.put("$JScrollPane1", $JScrollPane1 = new JScrollPane());
        
        $JScrollPane1.setName("$JScrollPane1");
        createVariableComment();
        // inline creation of $JButton1
        $objectMap.put("$JButton1", $JButton1 = new JButton());
        
        $JButton1.setName("$JButton1");
        $JButton1.setText(t("isisfish.variables.deletevariable"));
        $JButton1.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton1"));
        // inline creation of $JButton2
        $objectMap.put("$JButton2", $JButton2 = new JButton());
        
        $JButton2.setName("$JButton2");
        $JButton2.setText(t("isisfish.variables.savevariable"));
        $JButton2.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton2"));
        // inline creation of $InputContentUI0
        setName("$InputContentUI0");
        
        // registers 23 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 23 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VARIABLES_LIST_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                variablesList.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON0_ENABLED, true ,"active") {
        
            @Override
            public void processDataBinding() {
                $JButton0.setEnabled(isActive());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_ENABLED, true ,"active" ,"variable") {
        
            @Override
            public void processDataBinding() {
                $JLabel0.setEnabled(isActive() && getVariable() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VARIABLE_ENTITY_NAME_ENABLED, true ,"active" ,"variable") {
        
            @Override
            public void processDataBinding() {
                variableEntityName.setEnabled(isActive() && getVariable() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL1_ENABLED, true ,"active" ,"variable") {
        
            @Override
            public void processDataBinding() {
                $JLabel1.setEnabled(isActive() && getVariable() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VARIABLE_NAME_FIELD_ENABLED, true ,"active" ,"variable") {
        
            @Override
            public void processDataBinding() {
                variableNameField.setEnabled(isActive() && getVariable() != null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_VARIABLE_NAME_FIELD_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("variable", this);
                if (getVariable() != null) {
                    getVariable().addPropertyChangeListener("name", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getVariable() != null) {
                    SwingUtil.setText(variableNameField, getVariable().getName());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("variable", this);
                if (getVariable() != null) {
                    getVariable().removePropertyChangeListener("name", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL2_ENABLED, true ,"active" ,"variable") {
        
            @Override
            public void processDataBinding() {
                $JLabel2.setEnabled(isActive() && getVariable() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VARIABLE_TYPE_COMBO_ENABLED, true ,"active" ,"variable") {
        
            @Override
            public void processDataBinding() {
                variableTypeCombo.setEnabled(isActive() && getVariable() != null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_VARIABLE_TYPE_COMBO_SELECTED_ITEM, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("variable", this);
                if (getVariable() != null) {
                    getVariable().addPropertyChangeListener("type", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getVariable() != null) {
                    variableTypeCombo.setSelectedItem(getVariable().getType());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("variable", this);
                if (getVariable() != null) {
                    getVariable().removePropertyChangeListener("type", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL3_ENABLED, true ,"active" ,"variable") {
        
            @Override
            public void processDataBinding() {
                $JLabel3.setEnabled(isActive() && getVariable() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VARIABLE_DOUBLE_VALUE_ENABLED, true ,"active" ,"variable") {
        
            @Override
            public void processDataBinding() {
                variableDoubleValue.setEnabled(isActive() && getVariable() != null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_VARIABLE_DOUBLE_VALUE_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("variable", this);
                if (getVariable() != null) {
                    getVariable().addPropertyChangeListener("doubleValue", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getVariable() != null) {
                    SwingUtil.setText(variableDoubleValue, String.valueOf(getVariable().getDoubleValue()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("variable", this);
                if (getVariable() != null) {
                    getVariable().removePropertyChangeListener("doubleValue", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL4_ENABLED, true ,"active" ,"variable") {
        
            @Override
            public void processDataBinding() {
                $JLabel4.setEnabled(isActive() && getVariable() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MATRIX_PANEL_ENABLED, true ,"active" ,"variable") {
        
            @Override
            public void processDataBinding() {
                matrixPanel.setEnabled(isActive() && getVariable() != null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MATRIX_PANEL_MATRIX, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("variable", this);
                if (getVariable() != null) {
                    getVariable().addPropertyChangeListener("matrixValue", this);
                }
                if (getVariable() != null) {
                    getVariable().addPropertyChangeListener("matrixValue", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getVariable() != null && getVariable().getMatrixValue() != null) {
                    matrixPanel.setMatrix(getVariable().getMatrixValue() != null ? getVariable().getMatrixValue().copy() : null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("variable", this);
                if (getVariable() != null) {
                    getVariable().removePropertyChangeListener("matrixValue", this);
                }
                if (getVariable() != null) {
                    getVariable().removePropertyChangeListener("matrixValue", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VARIABLE_EQUATION_VALUE_ACTIVE, true ,"active" ,"variable") {
        
            @Override
            public void processDataBinding() {
                variableEquationValue.setActive(isActive() && getVariable() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VARIABLE_EQUATION_VALUE_BEAN, true ,"variable") {
        
            @Override
            public void processDataBinding() {
                variableEquationValue.setBean(getVariable());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL5_ENABLED, true ,"active" ,"variable") {
        
            @Override
            public void processDataBinding() {
                $JLabel5.setEnabled(isActive() && getVariable() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_VARIABLE_COMMENT_ENABLED, true ,"active" ,"variable") {
        
            @Override
            public void processDataBinding() {
                variableComment.setEnabled(isActive() && getVariable() != null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_VARIABLE_COMMENT_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("variable", this);
                if (getVariable() != null) {
                    getVariable().addPropertyChangeListener("comment", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getVariable() != null) {
                    SwingUtil.setText(variableComment, jaxx.runtime.SwingUtil.getStringValue(getVariable().getComment()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("variable", this);
                if (getVariable() != null) {
                    getVariable().removePropertyChangeListener("comment", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON1_ENABLED, true ,"active" ,"variable") {
        
            @Override
            public void processDataBinding() {
                $JButton1.setEnabled(isActive() && getVariable() != null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JBUTTON2_ENABLED, true ,"active" ,"variable") {
        
            @Override
            public void processDataBinding() {
                $JButton2.setEnabled(isActive() && getVariable() != null);
            }
        });
    }

}