/*
 * #%L
 * $Id: InputContentHandler.java 4237 2015-05-27 13:00:56Z echatellier $
 * $HeadURL: http://svn.codelutin.com/isis-fish/trunk/src/main/java/fr/ifremer/isisfish/ui/input/InputContentHandler.java $
 * %%
 * Copyright (C) 2015 Ifremer, Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.ui.input;

import java.awt.event.ActionEvent;

import javax.swing.JComponent;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.TopiaEntityContextable;

import fr.ifremer.isisfish.ui.CommonHandler;
import fr.ifremer.isisfish.ui.sensitivity.wizard.FactorWizardHandler;
import fr.ifremer.isisfish.ui.sensitivity.wizard.FactorWizardUI;

/**
 * Common handler for all input ui.
 */
public class InputContentHandler<T extends InputContentUI<? extends TopiaEntityContextable>> extends CommonHandler {

    /** Class logger. */
    private static final Log log = LogFactory.getLog(InputContentHandler.class);
 
    protected T inputContentUI;

    protected InputContentHandler(T inputContentUI) {
        this.inputContentUI = inputContentUI;
    }

    /**
     * Action appelée lors du clic sur un layer (sensitivity).
     * 
     * @param inputContentUI inputContentUI
     * @param e l'event initial intersepté par le layer
     */
    public void accept(InputContentUI<?> inputContentUI, ActionEvent e) {

        // get clicked component info
        JComponent source = (JComponent) e.getSource();
        Class<? extends TopiaEntityContextable> sensitivityBeanClass =
                (Class<? extends TopiaEntityContextable>)source.getClientProperty("sensitivityBean");
        String sensitivityBeanID = (String)source.getClientProperty("sensitivityBeanID");
        String sensitivityMethod = (String)source.getClientProperty("sensitivityMethod");

        if (log.isDebugEnabled()) {
            log.debug("Event intercepted " + source);
            log.debug(" client property (bean) : " + sensitivityBeanClass);
            log.debug(" client property (beanID) : " + sensitivityBeanID);
            log.debug(" client property (method) : " + sensitivityMethod);
        }

        displayFactorWizard(inputContentUI, sensitivityBeanClass, sensitivityBeanID, sensitivityMethod);
    }
    
    public void displayFactorWizard(InputContentUI<?> inputContentUI, Class<? extends TopiaEntityContextable> sensitivityBeanClass,
            String sensitivityBeanID, String sensitivityMethod) {

        // get bean for component class info
        TopiaEntityContextable bean = null;
        if (sensitivityBeanID == null) {
            bean = inputContentUI.getSaveVerifier().getEntity(sensitivityBeanClass);
        } else {
            bean = inputContentUI.getSaveVerifier().getEntity(sensitivityBeanClass, sensitivityBeanID);
        }

        if (bean != null) {
            FactorWizardUI factorWizardUI = new FactorWizardUI(inputContentUI);
            FactorWizardHandler handler = factorWizardUI.getHandler();
            handler.initNewFactor(factorWizardUI, bean, sensitivityMethod);
            factorWizardUI.pack();
            factorWizardUI.setLocationRelativeTo(inputContentUI);
            factorWizardUI.setVisible(true);
        } else {
            if (log.isErrorEnabled()) {
                log.error("Can't find bean in current verifier (sensitivityBeanClass = " + sensitivityBeanClass + ", sensitivityBeanID = " + sensitivityBeanID + ")");
            }
        }
    }
}
