package fr.ifremer.isisfish.entities;

/*
 * #%L
 * ISIS-Fish
 * %%
 * Copyright (C) 1999 - 2015 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.isisfish.types.Month;
import javax.annotation.Generated;
import org.nuiton.math.matrix.MatrixND;

@Generated(value = "org.nuiton.topia.generator.EntityTransformer", date = "Wed Jun 24 10:15:37 CEST 2015")
public interface PopulationSeasonInfo extends Season {

    String PROPERTY_REPRODUCTION_DISTRIBUTION = "reproductionDistribution";

    String PROPERTY_GROUP_CHANGE = "groupChange";

    String PROPERTY_SIMPLE_LENGTH_CHANGE_MATRIX = "simpleLengthChangeMatrix";

    String PROPERTY_LENGTH_CHANGE_MATRIX = "lengthChangeMatrix";

    String PROPERTY_REPRODUCTION = "reproduction";

    String PROPERTY_USE_EQUATION_MIGRATION = "useEquationMigration";

    String PROPERTY_MIGRATION_MATRIX = "migrationMatrix";

    String PROPERTY_EMIGRATION_MATRIX = "emigrationMatrix";

    String PROPERTY_IMMIGRATION_MATRIX = "immigrationMatrix";

    String PROPERTY_MIGRATION_EQUATION = "migrationEquation";

    String PROPERTY_EMIGRATION_EQUATION = "emigrationEquation";

    String PROPERTY_IMMIGRATION_EQUATION = "immigrationEquation";

    String PROPERTY_POPULATION = "population";

    void setReproductionDistribution(MatrixND reproductionDistribution);

    MatrixND getReproductionDistribution();

    void setGroupChange(boolean groupChange);

    boolean isGroupChange();

    boolean getGroupChange();

    void setSimpleLengthChangeMatrix(boolean simpleLengthChangeMatrix);

    boolean isSimpleLengthChangeMatrix();

    boolean getSimpleLengthChangeMatrix();

    void setLengthChangeMatrix(MatrixND lengthChangeMatrix);

    MatrixND getLengthChangeMatrix();

    void setReproduction(boolean reproduction);

    boolean isReproduction();

    boolean getReproduction();

    void setUseEquationMigration(boolean useEquationMigration);

    boolean isUseEquationMigration();

    boolean getUseEquationMigration();

    void setMigrationMatrix(MatrixND migrationMatrix);

    MatrixND getMigrationMatrix();

    void setEmigrationMatrix(MatrixND emigrationMatrix);

    MatrixND getEmigrationMatrix();

    void setImmigrationMatrix(MatrixND immigrationMatrix);

    MatrixND getImmigrationMatrix();

    void setMigrationEquation(Equation migrationEquation);

    Equation getMigrationEquation();

    void setEmigrationEquation(Equation emigrationEquation);

    Equation getEmigrationEquation();

    void setImmigrationEquation(Equation immigrationEquation);

    Equation getImmigrationEquation();

    void setPopulation(Population population);

    Population getPopulation();

    double getCapturability(PopulationGroup group);

    MatrixND spacializeLengthChangeMatrix(MatrixND mat);

    MatrixND computeLengthChangeMatrix();

    MatrixND getGroupChangeMatrix(Month month);

    /**
     * <p>Matrix [(group, zone(left)) x (group, zone(reached))]</p>
     * @param month 
     * @param N 
     * @return 
     */
    MatrixND getMigrationMatrix(Month month, MatrixND N);

    /**
     * <p>Matrix [(group, zone(left)) x (group, zone(left))]</p>
     * @param month 
     * @param N 
     * @return 
     */
    MatrixND getEmigrationMatrix(Month month, MatrixND N);

    /**
     * <p>Matrix [(group, zone(reached)) x (group, zone(reached))]</p>
     * @param month 
     * @param N 
     * @return 
     */
    MatrixND getImmigrationMatrix(Month month, MatrixND N);

    /**
     * <p>Matrix [zone(repro)]</p>
     * @param month 
     * @param N 
     * @return 
     */
    MatrixND getReproductionMatrix(Month month, MatrixND N);

    MatrixND unspacializeLengthChangeMatrix(MatrixND mat);

} //PopulationSeasonInfo
