package fr.ifremer.coselmar.converter;

/*
 * #%L
 * Coselmar :: Rest Services
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 Ifremer, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.util.Date;

import fr.ifremer.coselmar.beans.DocumentBean;
import fr.ifremer.coselmar.beans.UserBean;
import fr.ifremer.coselmar.persistence.entity.CoselmarUser;
import fr.ifremer.coselmar.persistence.entity.Document;
import org.apache.commons.lang3.StringUtils;

/**
 * @author ymartel <martel@codelutin.com>
 */
public class BeanEntityConverter {

    public static DocumentBean toBean(String lightId, Document document) {
        Date depositeDate = document.getDepositDate();
        Date publicationDate = document.getPublicationDate();
        CoselmarUser documentOwner = document.getOwner();
        String owner = "N/A";
        if (documentOwner != null) {
            String firstname = documentOwner.getFirstname();
            String lastname = documentOwner.getName();
            owner = StringUtils.defaultString(firstname) + StringUtils.defaultString(lastname);
        }


        return new DocumentBean(lightId,
            document.getName(),
            owner,
            document.getPrivacy().name(),
            depositeDate,
            document.getKeywords(),

            document.getType(),
            document.getSummary(),
            document.getLanguage(),
            publicationDate,

            document.getAuthors(),
            document.getLicense(),
            document.getCopyright(),

            document.isWithFile(),
            document.getMimeType(),
            document.getExternalUrl()
        );
    }

    public static UserBean toBean(String lightId ,CoselmarUser user) {
        return new UserBean(lightId,
            user.getFirstname(),
            user.getName(),
            user.getMail(),
            user.getRole().name(),
            user.getQualification(),
            user.getOrganization(),
            user.isActive());
    }

}
