/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coselmar.persistence;

import fr.ifremer.coselmar.persistence.entity.CoselmarUser;
import fr.ifremer.coselmar.persistence.entity.Document;
import java.lang.reflect.Array;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityEnum;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

public enum CoselmarEntityEnum implements TopiaEntityEnum
{
    CoselmarUser(CoselmarUser.class, null, "coselmaruser", ArrayUtils.EMPTY_STRING_ARRAY, new String[0]),
    Document(Document.class, null, "document", ArrayUtils.EMPTY_STRING_ARRAY, new String[0]);

    protected Class<? extends TopiaEntity> contract;
    protected String dbSchemaName;
    protected String dbTableName;
    protected String implementationFQN;
    protected Class<? extends TopiaEntity> implementation;
    protected String[] naturalIds;
    protected String[] notNulls;

    private CoselmarEntityEnum(Class<? extends TopiaEntity> contract, String dbSchemaName, String dbTableName, String[] notNulls, String ... naturalIds) {
        this.contract = contract;
        this.notNulls = Arrays.copyOf(notNulls, notNulls.length);
        this.naturalIds = naturalIds;
        this.implementationFQN = contract.getName() + "Impl";
    }

    public Class<? extends TopiaEntity> getContract() {
        return this.contract;
    }

    public String dbSchemaName() {
        return this.dbSchemaName;
    }

    public String dbTableName() {
        return this.dbTableName;
    }

    public String[] getNaturalIds() {
        return this.naturalIds;
    }

    public boolean isUseNaturalIds() {
        return this.naturalIds.length > 0;
    }

    public String[] getNotNulls() {
        return this.notNulls;
    }

    public boolean isUseNotNulls() {
        return this.notNulls.length > 0;
    }

    public String getImplementationFQN() {
        return this.implementationFQN;
    }

    public void setImplementationFQN(String implementationFQN) {
        this.implementationFQN = implementationFQN;
        this.implementation = null;
    }

    public boolean accept(Class<? extends TopiaEntity> klass) {
        CoselmarEntityEnum constant = CoselmarEntityEnum.valueOf(klass);
        boolean result = constant.getContract() == this.contract;
        return result;
    }

    public Class<? extends TopiaEntity> getImplementation() {
        if (this.implementation == null) {
            try {
                this.implementation = Class.forName(this.implementationFQN);
            }
            catch (ClassNotFoundException e) {
                throw new TopiaException("could not find class " + this.implementationFQN, (Throwable)e);
            }
        }
        return this.implementation;
    }

    public static CoselmarEntityEnum valueOf(TopiaEntity entity) {
        return CoselmarEntityEnum.valueOf(entity.getClass());
    }

    public static CoselmarEntityEnum valueOf(Class<?> klass) {
        if (klass.isInterface()) {
            return CoselmarEntityEnum.valueOf(klass.getSimpleName());
        }
        Class contractClass = TopiaEntityHelper.getContractClass((TopiaEntityEnum[])CoselmarEntityEnum.values(), klass);
        if (contractClass != null) {
            return CoselmarEntityEnum.valueOf(contractClass.getSimpleName());
        }
        throw new IllegalArgumentException("no entity defined for the class " + klass + " in : " + Arrays.toString((Object[])CoselmarEntityEnum.values()));
    }

    public static CoselmarEntityEnum[] getContracts() {
        CoselmarEntityEnum[] result = CoselmarEntityEnum.values();
        return result;
    }

    public static <T extends TopiaEntity> Class<T> getContractClass(Class<T> klass) {
        CoselmarEntityEnum constant = CoselmarEntityEnum.valueOf(klass);
        Class<? extends TopiaEntity> result = constant.getContract();
        return result;
    }

    public static Class<? extends TopiaEntity>[] getContractClasses() {
        CoselmarEntityEnum[] values = CoselmarEntityEnum.values();
        Class[] result = (Class[])Array.newInstance(Class.class, values.length);
        for (int i = 0; i < values.length; ++i) {
            result[i] = values[i].getContract();
        }
        return result;
    }

    public static <T extends TopiaEntity> Class<T> getImplementationClass(Class<T> klass) {
        CoselmarEntityEnum constant = CoselmarEntityEnum.valueOf(klass);
        Class<? extends TopiaEntity> result = constant.getImplementation();
        return result;
    }

    public static Class<? extends TopiaEntity>[] getImplementationClasses() {
        CoselmarEntityEnum[] values = CoselmarEntityEnum.values();
        Class[] result = (Class[])Array.newInstance(Class.class, values.length);
        for (int i = 0; i < values.length; ++i) {
            result[i] = values[i].getImplementation();
        }
        return result;
    }

    public static String getImplementationClassesAsString() {
        StringBuilder buffer = new StringBuilder();
        for (Class<? extends TopiaEntity> aClass : CoselmarEntityEnum.getImplementationClasses()) {
            buffer.append(',').append(aClass.getName());
        }
        String result = buffer.substring(1);
        return result;
    }
}

