/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coselmar.services.v1;

import fr.ifremer.coselmar.beans.HealthBean;
import fr.ifremer.coselmar.beans.QuestionSearchBean;
import fr.ifremer.coselmar.persistence.entity.Privacy;
import fr.ifremer.coselmar.services.CoselmarWebServiceSupport;
import fr.ifremer.coselmar.services.indexation.QuestionsIndexationService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HealthService
extends CoselmarWebServiceSupport {
    private static final Log log = LogFactory.getLog(HealthService.class);

    public HealthBean getHealth() {
        boolean indexationUp;
        boolean dbUp;
        boolean devMode;
        String version;
        block5: {
            block4: {
                version = this.getCoselmarServicesConfig().getVersion();
                devMode = this.getCoselmarServicesConfig().isDevMode();
                dbUp = false;
                try {
                    this.getQuestionDao().count();
                    dbUp = true;
                }
                catch (Exception e) {
                    if (!log.isErrorEnabled()) break block4;
                    log.error((Object)"Error during QuestionDao call", (Throwable)e);
                }
            }
            indexationUp = false;
            QuestionsIndexationService questionsIndexationService = (QuestionsIndexationService)this.getServicesContext().newService(QuestionsIndexationService.class);
            try {
                QuestionSearchBean searchBean = new QuestionSearchBean();
                searchBean.setPrivacy(Privacy.PUBLIC.name());
                questionsIndexationService.searchQuestion(searchBean);
                indexationUp = true;
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block5;
                log.error((Object)"Error during Indexation service call", (Throwable)e);
            }
        }
        HealthBean healthBean = new HealthBean();
        healthBean.setVersion(version);
        healthBean.setDbUp(dbUp);
        healthBean.setIndexationUp(indexationUp);
        healthBean.setDevMode(devMode);
        return healthBean;
    }
}

