/*
 * #%L
 * Coselmar :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 Ifremer, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

coselmarServices.factory('questionsService', ['$resource', 'coselmar-config', function($resource, coselmarConfig){
	return new Question($resource, coselmarConfig);
}]);

function Question(resource, config){


	this.resource = resource;
	var baseURL = config.BASE_URL + "/questions";
	var usersURL = config.BASE_URL + "/users";

	this.saveQuestion = function(question, successFunction, failFunction){

		var formData = new FormData();
		formData.append("question", JSON.stringify(question));

		// Save the Question
		var serviceURl = baseURL;
		if (question.id) {
			serviceURl = baseURL + "/" + question.id
		}
		var questionResource = resource(serviceURl, null, {
			'save': {
			  method:'POST',
			  transformRequest: angular.identity,
			  headers:{
				'Content-Type': undefined
			  }
			}
		});
		questionResource.save(null, formData, successFunction, failFunction);
	};

	this.findUsers = function(example, successFunction) {
		var userResource = resource(usersURL, {'search': example});
		userResource.query(successFunction);

	};

	this.getQuestions = function(successFunction, failFunction) {
		var questionResource = resource(baseURL);
		questionResource.query().$promise.then(successFunction, failFunction);
	}

	this.deleteQuestion = function(questionId, successFunction, failFunction) {
		var questionResource = resource(baseURL + "/" + questionId);
		questionResource.delete().$promise.then(successFunction, failFunction);
	}

	this.getQuestion = function(questionId, successFunction, failFunction) {
		var questionResource = resource(baseURL + "/" + questionId);
		questionResource.get().$promise.then(successFunction, failFunction);
	}

	this.addNewDocuments = function(questionId, documents, successFunction, failFunction) {

		var formData = new FormData();
		formData.append("documents", JSON.stringify(documents));

		var serviceURl = baseURL + "/" + questionId + "/documents";
		var questionResource = resource(serviceURl, null, {
			'save': {
			  method:'POST',
			  transformRequest: angular.identity,
			  isArray: true,
			  headers:{
				'Content-Type': undefined
			  }
			}
		});
		questionResource.save(null, formData, successFunction, failFunction);
	}
};