/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.jgitflow.mojo;

import com.atlassian.maven.jgitflow.api.MavenHotfixStartExtension;
import com.atlassian.maven.plugins.jgitflow.ReleaseContext;
import com.atlassian.maven.plugins.jgitflow.exception.MavenJGitFlowException;
import com.atlassian.maven.plugins.jgitflow.manager.FlowReleaseManager;
import com.atlassian.maven.plugins.jgitflow.mojo.AbstractJGitFlowMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="hotfix-start", aggregator=true, requiresDependencyResolution=ResolutionScope.TEST)
public class HotfixStartMojo
extends AbstractJGitFlowMojo {
    @Parameter(defaultValue="false", property="autoVersionSubmodules")
    private boolean autoVersionSubmodules = false;
    @Parameter(property="releaseVersion", defaultValue="")
    private String releaseVersion = "";
    @Parameter(defaultValue="true", property="updateDependencies")
    private boolean updateDependencies = true;
    @Parameter(defaultValue="false", property="pushHotfixes")
    private boolean pushHotfixes = false;
    @Parameter(property="startCommit", defaultValue="")
    private String startCommit = "";
    @Component(hint="hotfix")
    FlowReleaseManager releaseManager;
    @Parameter(defaultValue="")
    private String hotfixStartExtension = "";

    public void execute() throws MojoExecutionException, MojoFailureException {
        ClassLoader oldClassloader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClassloader(this.getClasspath()));
        MavenHotfixStartExtension extensionObject = (MavenHotfixStartExtension)this.getExtensionInstance(this.hotfixStartExtension);
        ReleaseContext ctx = new ReleaseContext(this.getBasedir());
        ctx.setAutoVersionSubmodules(this.autoVersionSubmodules).setInteractive(this.getSettings().isInteractiveMode()).setDefaultReleaseVersion(this.releaseVersion).setAllowSnapshots(this.allowSnapshots).setUpdateDependencies(this.updateDependencies).setEnableSshAgent(this.enableSshAgent).setAllowUntracked(this.allowUntracked).setPushHotfixes(this.pushHotfixes).setStartCommit(this.startCommit).setAllowRemote(this.isRemoteAllowed()).setAlwaysUpdateOrigin(this.alwaysUpdateOrigin).setDefaultOriginUrl(this.defaultOriginUrl).setScmCommentPrefix(this.scmCommentPrefix).setScmCommentSuffix(this.scmCommentSuffix).setUsername(this.username).setPassword(this.password).setHotfixStartExtension(extensionObject).setFlowInitContext(this.getFlowInitContext().getJGitFlowContext());
        try {
            this.releaseManager.start(ctx, this.getReactorProjects(), this.session);
        }
        catch (MavenJGitFlowException e) {
            throw new MojoExecutionException("Error starting hotfix: " + e.getMessage(), (Exception)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassloader);
        }
    }
}

