/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.jgitflow.manager.tasks;

import com.atlassian.maven.plugins.jgitflow.ReleaseContext;
import com.atlassian.maven.plugins.jgitflow.exception.MavenJGitFlowException;
import com.atlassian.maven.plugins.jgitflow.helper.JGitFlowSetupHelper;
import com.atlassian.maven.plugins.jgitflow.provider.ContextProvider;
import com.atlassian.maven.plugins.jgitflow.provider.JGitFlowProvider;
import com.google.common.base.Strings;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;

@Component(role=SetupOriginAndFetchIfNeeded.class)
public class SetupOriginAndFetchIfNeeded {
    @Requirement
    private ContextProvider contextProvider;
    @Requirement
    private JGitFlowSetupHelper setupHelper;
    @Requirement
    private JGitFlowProvider jGitFlowProvider;

    public void run() throws MavenJGitFlowException {
        ReleaseContext ctx = this.contextProvider.getContext();
        if (ctx.isRemoteAllowed()) {
            try {
                this.setupHelper.ensureOrigin();
                String originUrl = this.jGitFlowProvider.gitFlow().git().getRepository().getConfig().getString("remote", "origin", "url");
                if (!Strings.isNullOrEmpty((String)originUrl)) {
                    this.jGitFlowProvider.gitFlow().git().fetch().setRemote("origin").call();
                }
            }
            catch (Exception e) {
                throw new MavenJGitFlowException("Error setting origin in configuration", e);
            }
        }
    }
}

