/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.jgitflow.extension.command;

import com.atlassian.jgitflow.core.GitFlowConfiguration;
import com.atlassian.jgitflow.core.JGitFlowReporter;
import com.atlassian.jgitflow.core.command.JGitFlowCommand;
import com.atlassian.jgitflow.core.exception.JGitFlowExtensionException;
import com.atlassian.jgitflow.core.extension.ExtensionCommand;
import com.atlassian.jgitflow.core.extension.ExtensionFailStrategy;
import com.atlassian.maven.plugins.jgitflow.ReleaseContext;
import com.atlassian.maven.plugins.jgitflow.helper.JGitFlowSetupHelper;
import com.atlassian.maven.plugins.jgitflow.provider.ContextProvider;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.eclipse.jgit.api.Git;

@Component(role=EnsureOriginCommand.class)
public class EnsureOriginCommand
implements ExtensionCommand {
    @Requirement
    private ContextProvider contextProvider;
    @Requirement
    private JGitFlowSetupHelper setupHelper;

    public void execute(GitFlowConfiguration configuration, Git git, JGitFlowCommand gitFlowCommand, JGitFlowReporter reporter) throws JGitFlowExtensionException {
        ReleaseContext ctx = this.contextProvider.getContext();
        if (ctx.isRemoteAllowed()) {
            try {
                this.setupHelper.ensureOrigin();
            }
            catch (Exception e) {
                throw new JGitFlowExtensionException("Error setting origin in configuration", (Throwable)e);
            }
        }
    }

    public ExtensionFailStrategy failStrategy() {
        return ExtensionFailStrategy.ERROR;
    }
}

