/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClientExt.org.apache.commons.httpclient.auth;

import edu.internet2.middleware.grouperClientExt.org.apache.commons.codec.binary.Base64;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.httpclient.Credentials;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.httpclient.HttpMethod;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.httpclient.UsernamePasswordCredentials;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.httpclient.auth.AuthenticationException;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.httpclient.auth.InvalidCredentialsException;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.httpclient.auth.MalformedChallengeException;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.httpclient.auth.RFC2617Scheme;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.httpclient.util.EncodingUtil;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.logging.Log;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.logging.LogFactory;

public class BasicScheme
extends RFC2617Scheme {
    private static final Log LOG = LogFactory.getLog(BasicScheme.class);
    private boolean complete;

    public BasicScheme() {
        this.complete = false;
    }

    public BasicScheme(String challenge) throws MalformedChallengeException {
        super(challenge);
        this.complete = true;
    }

    public String getSchemeName() {
        return "basic";
    }

    public void processChallenge(String challenge) throws MalformedChallengeException {
        super.processChallenge(challenge);
        this.complete = true;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public String authenticate(Credentials credentials, String method, String uri) throws AuthenticationException {
        LOG.trace("enter BasicScheme.authenticate(Credentials, String, String)");
        UsernamePasswordCredentials usernamepassword = null;
        try {
            usernamepassword = (UsernamePasswordCredentials)credentials;
        }
        catch (ClassCastException e) {
            throw new InvalidCredentialsException("Credentials cannot be used for basic authentication: " + credentials.getClass().getName());
        }
        return BasicScheme.authenticate(usernamepassword);
    }

    public boolean isConnectionBased() {
        return false;
    }

    public String authenticate(Credentials credentials, HttpMethod method) throws AuthenticationException {
        LOG.trace("enter BasicScheme.authenticate(Credentials, HttpMethod)");
        if (method == null) {
            throw new IllegalArgumentException("Method may not be null");
        }
        UsernamePasswordCredentials usernamepassword = null;
        try {
            usernamepassword = (UsernamePasswordCredentials)credentials;
        }
        catch (ClassCastException e) {
            throw new InvalidCredentialsException("Credentials cannot be used for basic authentication: " + credentials.getClass().getName());
        }
        return BasicScheme.authenticate(usernamepassword, method.getParams().getCredentialCharset());
    }

    public static String authenticate(UsernamePasswordCredentials credentials) {
        return BasicScheme.authenticate(credentials, "ISO-8859-1");
    }

    public static String authenticate(UsernamePasswordCredentials credentials, String charset) {
        LOG.trace("enter BasicScheme.authenticate(UsernamePasswordCredentials, String)");
        if (credentials == null) {
            throw new IllegalArgumentException("Credentials may not be null");
        }
        if (charset == null || charset.length() == 0) {
            throw new IllegalArgumentException("charset may not be null or empty");
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(credentials.getUserName());
        buffer.append(":");
        buffer.append(credentials.getPassword());
        return "Basic " + EncodingUtil.getAsciiString(Base64.encodeBase64(EncodingUtil.getBytes(buffer.toString(), charset)));
    }
}

