/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.runtime;

import de.flapdoodle.embed.process.config.ISupportConfig;
import de.flapdoodle.embed.process.config.process.ProcessConfig;
import de.flapdoodle.embed.process.io.Processors;
import de.flapdoodle.embed.process.runtime.Processes;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessControl {
    private static Logger logger = LoggerFactory.getLogger(ProcessControl.class);
    private static final int SLEEPT_TIMEOUT = 10;
    private final Process process;
    private InputStreamReader reader;
    private final InputStreamReader error;
    private final Long pid;
    private final ISupportConfig runtime;

    public ProcessControl(ISupportConfig runtime, Process process) {
        this.process = process;
        this.runtime = runtime;
        this.reader = new InputStreamReader(this.process.getInputStream());
        this.error = new InputStreamReader(this.process.getErrorStream());
        this.pid = Processes.processId(this.process);
    }

    public Reader getReader() {
        return this.reader;
    }

    public InputStreamReader getError() {
        return this.error;
    }

    public int stop() {
        return this.waitForProcessGotKilled();
    }

    private void closeIOAndDestroy() {
        if (this.process != null) {
            try {
                this.process.getErrorStream().close();
                this.process.getInputStream().close();
                this.process.getOutputStream().close();
            }
            catch (IOException e) {
                logger.error(e.getMessage());
            }
            this.reader = null;
        }
    }

    private Integer stopOrDestroyProcess() {
        Integer returnCode;
        block17: {
            returnCode = null;
            try {
                returnCode = this.process.exitValue();
            }
            catch (IllegalThreadStateException itsx) {
                logger.info("stopOrDestroyProcess: " + itsx.getMessage() + " " + (itsx.getCause() != null ? itsx.getCause() : ""));
                Callable<Integer> callable = new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        return ProcessControl.this.process.waitFor();
                    }
                };
                FutureTask<Integer> task = new FutureTask<Integer>(callable);
                new Thread(task).start();
                boolean stopped = false;
                try {
                    returnCode = task.get(100L, TimeUnit.MILLISECONDS);
                    stopped = true;
                }
                catch (InterruptedException interruptedException) {
                }
                catch (ExecutionException executionException) {
                }
                catch (TimeoutException timeoutException) {
                    // empty catch block
                }
                this.closeIOAndDestroy();
                try {
                    returnCode = task.get(900L, TimeUnit.MILLISECONDS);
                    stopped = true;
                }
                catch (InterruptedException interruptedException) {
                }
                catch (ExecutionException executionException) {
                }
                catch (TimeoutException timeoutException) {
                    // empty catch block
                }
                try {
                    returnCode = task.get(2000L, TimeUnit.MILLISECONDS);
                    stopped = true;
                }
                catch (InterruptedException interruptedException) {
                }
                catch (ExecutionException executionException) {
                }
                catch (TimeoutException timeoutException) {
                    // empty catch block
                }
                if (stopped) break block17;
                this.process.destroy();
            }
        }
        return returnCode;
    }

    private int waitForProcessGotKilled() {
        Integer retCode = this.stopOrDestroyProcess();
        if (retCode == null) {
            String message = "\n\n----------------------------------------------------\nSomething bad happend. We couldn't kill " + this.runtime.getName() + " process, and tried a lot.\nIf you want this problem solved you can help us if you open a new issue.\n\nFollow this link:\n" + this.runtime.getSupportUrl() + "\nThank you:)\n----------------------------------------------------\n\n";
            throw new IllegalStateException("Couldn't kill " + this.runtime.getName() + " process!" + message);
        }
        return retCode;
    }

    public static ProcessControl fromCommandLine(ISupportConfig runtime, List<String> commandLine, boolean redirectErrorStream) throws IOException {
        ProcessBuilder processBuilder = ProcessControl.newProcessBuilder(commandLine, redirectErrorStream);
        return ProcessControl.start(runtime, processBuilder);
    }

    public static ProcessControl start(ISupportConfig runtime, ProcessBuilder processBuilder) throws IOException {
        return new ProcessControl(runtime, processBuilder.start());
    }

    public static ProcessBuilder newProcessBuilder(List<String> commandLine, boolean redirectErrorStream) {
        return ProcessControl.newProcessBuilder(commandLine, new HashMap<String, String>(), redirectErrorStream);
    }

    public static ProcessBuilder newProcessBuilder(List<String> commandLine, Map<String, String> environment, boolean redirectErrorStream) {
        ProcessBuilder processBuilder = new ProcessBuilder(commandLine);
        if (!environment.isEmpty()) {
            processBuilder.environment().putAll(environment);
        }
        if (redirectErrorStream) {
            processBuilder.redirectErrorStream();
        }
        return processBuilder;
    }

    public static boolean executeCommandLine(ISupportConfig support, String label, ProcessConfig processConfig) {
        boolean ret = false;
        List<String> commandLine = processConfig.getCommandLine();
        try {
            ProcessControl process = ProcessControl.fromCommandLine(support, processConfig.getCommandLine(), processConfig.getError() == null);
            Processors.connect(process.getReader(), processConfig.getOutput());
            Thread.sleep(10L);
            ret = process.stop() == 0;
            logger.info("execSuccess: {} {}", (Object)ret, commandLine);
            return ret;
        }
        catch (IOException e) {
            logger.error("" + commandLine, (Throwable)e);
        }
        catch (InterruptedException e) {
            logger.error("" + commandLine, (Throwable)e);
        }
        return false;
    }

    public int waitFor() throws InterruptedException {
        return this.process.waitFor();
    }

    public static void addShutdownHook(Runnable runable) {
        Runtime.getRuntime().addShutdownHook(new Thread(runable));
    }

    public Long getPid() {
        return this.pid;
    }
}

