/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.config.store;

import de.flapdoodle.embed.process.builder.AbstractBuilder;
import de.flapdoodle.embed.process.builder.ImmutableContainer;
import de.flapdoodle.embed.process.builder.TypedProperty;
import de.flapdoodle.embed.process.config.store.ITimeoutConfig;

public class TimeoutConfigBuilder
extends AbstractBuilder<ITimeoutConfig> {
    private static final TypedProperty<ReadTimeout> READ_TIMEOUT = TypedProperty.with("ReadTimeout", ReadTimeout.class);
    private static final TypedProperty<ConnectionTimeout> CONNECTION_TIMEOUT = TypedProperty.with("ConnectionTimeout", ConnectionTimeout.class);

    public TimeoutConfigBuilder connectionTimeout(int connectionTimeout) {
        this.set(CONNECTION_TIMEOUT, new ConnectionTimeout(connectionTimeout));
        return this;
    }

    public TimeoutConfigBuilder readTimeout(int connectionTimeout) {
        this.set(READ_TIMEOUT, new ReadTimeout(connectionTimeout));
        return this;
    }

    public TimeoutConfigBuilder defaults() {
        this.setDefault(CONNECTION_TIMEOUT, new ConnectionTimeout(10000));
        this.setDefault(READ_TIMEOUT, new ReadTimeout(10000));
        return this;
    }

    @Override
    public ITimeoutConfig build() {
        int connectionTimeout = (Integer)this.get(CONNECTION_TIMEOUT).value();
        int readTimeout = (Integer)this.get(READ_TIMEOUT).value();
        return new ImmutableTimeoutConfig(connectionTimeout, readTimeout);
    }

    static class ImmutableTimeoutConfig
    implements ITimeoutConfig {
        private final int _connectionTimeout;
        private final int _readTimeout;

        public ImmutableTimeoutConfig(int connectionTimeout, int readTimeout) {
            this._connectionTimeout = connectionTimeout;
            this._readTimeout = readTimeout;
        }

        @Override
        public int getConnectionTimeout() {
            return this._connectionTimeout;
        }

        @Override
        public int getReadTimeout() {
            return this._readTimeout;
        }
    }

    static class ReadTimeout
    extends ImmutableContainer<Integer> {
        public ReadTimeout(int value) {
            super(value);
        }
    }

    static class ConnectionTimeout
    extends ImmutableContainer<Integer> {
        public ConnectionTimeout(int value) {
            super(value);
        }
    }
}

