/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.sequence;

import com.vladsch.flexmark.util.Pair;
import com.vladsch.flexmark.util.Utils;
import com.vladsch.flexmark.util.html.Escaping;
import com.vladsch.flexmark.util.mappers.CharMapper;
import com.vladsch.flexmark.util.mappers.LowerCaseMapper;
import com.vladsch.flexmark.util.mappers.UpperCaseMapper;
import com.vladsch.flexmark.util.sequence.MappedSequence;
import com.vladsch.flexmark.util.sequence.Range;
import com.vladsch.flexmark.util.sequence.RepeatedCharSequence;
import com.vladsch.flexmark.util.sequence.RichCharSequence;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public abstract class RichCharSequenceBase<T extends RichCharSequence<T>>
implements RichCharSequence<T> {
    private static int[] EMPTY_INDICES = new int[0];
    private static final Map<Character, String> visibleSpacesMap;

    public <S extends RichCharSequence<S>> S firstNonNull(S ... sequences) {
        if (sequences.length > 0) {
            S NULL = sequences[0].nullSequence();
            for (S sequence : sequences) {
                if (sequence == null || !sequence.isNotNull()) continue;
                return sequence;
            }
            return NULL;
        }
        return null;
    }

    static boolean isVisibleWhitespace(char c) {
        return visibleSpacesMap.containsKey(Character.valueOf(c));
    }

    @Override
    public T sequenceOf(CharSequence charSequence) {
        return this.sequenceOf(charSequence, 0, charSequence.length());
    }

    @Override
    public final T sequenceOf(CharSequence charSequence, int startIndex) {
        return this.sequenceOf(charSequence, startIndex, charSequence.length());
    }

    @Override
    public final T endSequence(int start, int end) {
        int length = this.length();
        int useStart = length - start;
        int useEnd = length - end;
        if (useStart < 0) {
            useStart = 0;
        } else if (useStart > length) {
            useStart = length;
        }
        if (useEnd < 0) {
            useEnd = 0;
        } else if (useEnd > length) {
            useEnd = length;
        }
        if (useStart > useEnd) {
            useStart = useEnd;
        }
        if (useStart == 0 && useEnd == length) {
            return (T)this;
        }
        return (T)this.subSequence(useStart, useEnd);
    }

    @Override
    public final T endSequence(int start) {
        int length = this.length();
        if (start <= 0) {
            return (T)this.subSequence(length, length);
        }
        if (start >= length) {
            return (T)this;
        }
        return (T)this.subSequence(length - start, length);
    }

    @Override
    public final char endCharAt(int index) {
        if (index < 0 || index >= this.length()) {
            return '\u0000';
        }
        return this.charAt(this.length() - index);
    }

    @Override
    public final T midSequence(int start, int end) {
        int useEnd;
        int length = this.length();
        int useStart = start < 0 ? length + start : start;
        int n = useEnd = end < 0 ? length + end : end;
        if (useStart < 0) {
            useStart = 0;
        } else if (useStart > length) {
            useStart = length;
        }
        if (useEnd < 0) {
            useEnd = 0;
        } else if (useEnd > length) {
            useEnd = length;
        }
        if (useStart > useEnd) {
            useStart = useEnd;
        }
        if (useStart == 0 && useEnd == length) {
            return (T)this;
        }
        return (T)this.subSequence(useStart, useEnd);
    }

    @Override
    public final T midSequence(int start) {
        int useStart;
        int length = this.length();
        int n = useStart = start < 0 ? length + start : start;
        if (useStart <= 0) {
            return (T)this;
        }
        if (useStart >= length) {
            return (T)this.subSequence(length, length);
        }
        return (T)this.subSequence(useStart, length);
    }

    @Override
    public final char midCharAt(int index) {
        if (index < -this.length() || index >= this.length()) {
            return '\u0000';
        }
        return this.charAt(index < 0 ? this.length() + index : index);
    }

    @Override
    public final char lastChar() {
        return this.isEmpty() ? (char)'\u0000' : this.charAt(this.length() - 1);
    }

    @Override
    public final char firstChar() {
        return this.isEmpty() ? (char)'\u0000' : this.charAt(0);
    }

    @Override
    public final int indexOf(CharSequence s) {
        return this.indexOf(s, 0, this.length());
    }

    @Override
    public final int indexOf(CharSequence s, int fromIndex) {
        return this.indexOf(s, fromIndex, this.length());
    }

    @Override
    public final int indexOf(CharSequence s, int fromIndex, int endIndex) {
        int sMax = s.length();
        if (sMax == 0) {
            return fromIndex;
        }
        if (endIndex > this.length()) {
            endIndex = this.length();
        }
        if (fromIndex < endIndex) {
            char firstChar = s.charAt(0);
            int pos = fromIndex;
            while ((pos = this.indexOf(firstChar, pos)) >= 0 && pos + sMax <= endIndex) {
                if (this.matchChars(s, pos)) {
                    return pos;
                }
                if (++pos + sMax < endIndex) continue;
            }
        }
        return -1;
    }

    @Override
    public final int indexOf(char c) {
        return this.indexOf(c, 0, this.length());
    }

    @Override
    public final int indexOfAny(char c1, char c2) {
        return this.indexOfAny(c1, c2, 0, this.length());
    }

    @Override
    public final int indexOfAny(char c1, char c2, char c3) {
        return this.indexOfAny(c1, c2, c3, 0, this.length());
    }

    @Override
    public final int indexOfAny(CharSequence s) {
        return this.indexOfAny(s, 0, this.length());
    }

    @Override
    public final int indexOf(char c, int fromIndex) {
        return this.indexOf(c, fromIndex, this.length());
    }

    @Override
    public final int indexOfAny(char c1, char c2, int fromIndex) {
        return this.indexOfAny(c1, c2, fromIndex, this.length());
    }

    @Override
    public final int indexOfAny(char c1, char c2, char c3, int fromIndex) {
        return this.indexOfAny(c1, c2, c3, fromIndex, this.length());
    }

    @Override
    public final int indexOfAny(CharSequence s, int index) {
        return this.indexOfAny(s, index, this.length());
    }

    @Override
    public final int indexOf(char c, int fromIndex, int endIndex) {
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (endIndex > this.length()) {
            endIndex = this.length();
        }
        for (int i = fromIndex; i < endIndex; ++i) {
            if (this.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    @Override
    public final int indexOfAny(char c1, char c2, int fromIndex, int endIndex) {
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (endIndex > this.length()) {
            endIndex = this.length();
        }
        for (int i = fromIndex; i < endIndex; ++i) {
            char c = this.charAt(i);
            if (c != c1 && c != c2) continue;
            return i;
        }
        return -1;
    }

    @Override
    public final int indexOfAny(char c1, char c2, char c3, int fromIndex, int endIndex) {
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (endIndex > this.length()) {
            endIndex = this.length();
        }
        for (int i = fromIndex; i < endIndex; ++i) {
            char c = this.charAt(i);
            if (c != c1 && c != c2 && c != c3) continue;
            return i;
        }
        return -1;
    }

    @Override
    public final int indexOfAny(CharSequence s, int fromIndex, int endIndex) {
        switch (s.length()) {
            case 0: {
                return fromIndex;
            }
            case 1: {
                return this.indexOf(s.charAt(0), fromIndex, endIndex);
            }
            case 2: {
                return this.indexOfAny(s.charAt(0), s.charAt(1), fromIndex, endIndex);
            }
            case 3: {
                return this.indexOfAny(s.charAt(0), s.charAt(1), s.charAt(2), fromIndex, endIndex);
            }
        }
        T sequence = this.sequenceOf(s);
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (endIndex > this.length()) {
            endIndex = this.length();
        }
        for (int i = fromIndex; i < endIndex; ++i) {
            char c = this.charAt(i);
            if (sequence.indexOf(c) == -1) continue;
            return i;
        }
        return -1;
    }

    @Override
    public final int indexOfNot(char c) {
        return this.indexOfNot(c, 0, this.length());
    }

    @Override
    public final int indexOfAnyNot(char c1, char c2) {
        return this.indexOfAnyNot(c1, c2, 0, this.length());
    }

    @Override
    public final int indexOfAnyNot(char c1, char c2, char c3) {
        return this.indexOfAnyNot(c1, c2, c3, 0, this.length());
    }

    @Override
    public final int indexOfAnyNot(CharSequence s) {
        return this.indexOfAnyNot(s, 0, this.length());
    }

    @Override
    public final int indexOfNot(char c, int fromIndex) {
        return this.indexOfNot(c, fromIndex, this.length());
    }

    @Override
    public final int indexOfAnyNot(char c1, char c2, int fromIndex) {
        return this.indexOfAnyNot(c1, c2, fromIndex, this.length());
    }

    @Override
    public final int indexOfAnyNot(char c1, char c2, char c3, int fromIndex) {
        return this.indexOfAnyNot(c1, c2, c3, fromIndex, this.length());
    }

    @Override
    public final int indexOfAnyNot(CharSequence s, int fromIndex) {
        return this.indexOfAnyNot(s, fromIndex, this.length());
    }

    @Override
    public final int indexOfNot(char c, int fromIndex, int endIndex) {
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (endIndex > this.length()) {
            endIndex = this.length();
        }
        for (int i = fromIndex; i < endIndex; ++i) {
            if (this.charAt(i) == c) continue;
            return i;
        }
        return -1;
    }

    @Override
    public final int indexOfAnyNot(char c1, char c2, int fromIndex, int endIndex) {
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (endIndex > this.length()) {
            endIndex = this.length();
        }
        for (int i = fromIndex; i < endIndex; ++i) {
            char c = this.charAt(i);
            if (c == c1 || c == c2) continue;
            return i;
        }
        return -1;
    }

    @Override
    public final int indexOfAnyNot(char c1, char c2, char c3, int fromIndex, int endIndex) {
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (endIndex > this.length()) {
            endIndex = this.length();
        }
        for (int i = fromIndex; i < endIndex; ++i) {
            char c = this.charAt(i);
            if (c == c1 || c == c2 || c == c3) continue;
            return i;
        }
        return -1;
    }

    @Override
    public final int indexOfAnyNot(CharSequence s, int fromIndex, int endIndex) {
        switch (s.length()) {
            case 0: {
                return fromIndex;
            }
            case 1: {
                return this.indexOfNot(s.charAt(0), fromIndex, endIndex);
            }
            case 2: {
                return this.indexOfAnyNot(s.charAt(0), s.charAt(1), fromIndex, endIndex);
            }
            case 3: {
                return this.indexOfAnyNot(s.charAt(0), s.charAt(1), s.charAt(2), fromIndex, endIndex);
            }
        }
        T sequence = this.sequenceOf(s);
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (endIndex > this.length()) {
            endIndex = this.length();
        }
        for (int i = fromIndex; i < endIndex; ++i) {
            char c = this.charAt(i);
            if (sequence.indexOf(c) != -1) continue;
            return i;
        }
        return -1;
    }

    @Override
    public final int lastIndexOf(CharSequence s) {
        return this.lastIndexOf(s, 0, this.length());
    }

    @Override
    public final int lastIndexOf(CharSequence s, int fromIndex) {
        return this.lastIndexOf(s, 0, fromIndex);
    }

    @Override
    public final int lastIndexOf(CharSequence s, int startIndex, int fromIndex) {
        int sMax = s.length();
        if (sMax == 0) {
            return startIndex;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (fromIndex >= this.length()) {
            fromIndex = this.length();
        }
        if (startIndex < fromIndex) {
            int pos = fromIndex;
            char lastChar = s.charAt(sMax - 1);
            while ((pos = this.lastIndexOf(lastChar, pos)) + 1 >= startIndex + sMax) {
                if (this.matchCharsReversed(s, pos)) {
                    return pos + 1 - sMax;
                }
                if (--pos + 1 >= startIndex + sMax) continue;
            }
        }
        return -1;
    }

    @Override
    public final int lastIndexOf(char c) {
        return this.lastIndexOf(c, 0, this.length());
    }

    @Override
    public final int lastIndexOfAny(char c1, char c2) {
        return this.lastIndexOfAny(c1, c2, 0, this.length());
    }

    @Override
    public final int lastIndexOfAny(char c1, char c2, char c3) {
        return this.lastIndexOfAny(c1, c2, c3, 0, this.length());
    }

    @Override
    public final int lastIndexOfAny(CharSequence s) {
        return this.lastIndexOfAny(s, 0, this.length());
    }

    @Override
    public final int lastIndexOf(char c, int fromIndex) {
        return this.lastIndexOf(c, 0, fromIndex);
    }

    @Override
    public final int lastIndexOfAny(char c1, char c2, int fromIndex) {
        return this.lastIndexOfAny(c1, c2, 0, fromIndex);
    }

    @Override
    public final int lastIndexOfAny(char c1, char c2, char c3, int fromIndex) {
        return this.lastIndexOfAny(c1, c2, c3, 0, fromIndex);
    }

    @Override
    public final int lastIndexOfAny(CharSequence s, int fromIndex) {
        return this.lastIndexOfAny(s, 0, fromIndex);
    }

    @Override
    public final int lastIndexOf(char c, int startIndex, int fromIndex) {
        if (startIndex < 0) {
            startIndex = 0;
        }
        fromIndex = fromIndex >= this.length() ? this.length() : ++fromIndex;
        int i = fromIndex;
        while (i-- > startIndex) {
            if (this.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    @Override
    public final int lastIndexOfAny(char c1, char c2, int startIndex, int fromIndex) {
        if (startIndex < 0) {
            startIndex = 0;
        }
        fromIndex = fromIndex >= this.length() ? this.length() : ++fromIndex;
        int i = fromIndex;
        while (i-- > startIndex) {
            char c = this.charAt(i);
            if (c != c1 && c != c2) continue;
            return i;
        }
        return -1;
    }

    @Override
    public final int lastIndexOfAny(char c1, char c2, char c3, int startIndex, int fromIndex) {
        if (startIndex < 0) {
            startIndex = 0;
        }
        fromIndex = fromIndex >= this.length() ? this.length() : ++fromIndex;
        int i = fromIndex;
        while (i-- > startIndex) {
            char c = this.charAt(i);
            if (c != c1 && c != c2 && c != c3) continue;
            return i;
        }
        return -1;
    }

    @Override
    public final int lastIndexOfAny(CharSequence s, int startIndex, int fromIndex) {
        switch (s.length()) {
            case 0: {
                return startIndex;
            }
            case 1: {
                return this.lastIndexOf(s.charAt(0), startIndex, fromIndex);
            }
            case 2: {
                return this.lastIndexOfAny(s.charAt(0), s.charAt(1), startIndex, fromIndex);
            }
            case 3: {
                return this.lastIndexOfAny(s.charAt(0), s.charAt(1), s.charAt(2), startIndex, fromIndex);
            }
        }
        T sequence = this.sequenceOf(s);
        if (startIndex < 0) {
            startIndex = 0;
        }
        fromIndex = fromIndex >= this.length() ? this.length() : ++fromIndex;
        int i = fromIndex;
        while (i-- > startIndex) {
            char c = this.charAt(i);
            if (sequence.indexOf(c) == -1) continue;
            return i;
        }
        return -1;
    }

    @Override
    public final int lastIndexOfNot(char c) {
        return this.lastIndexOfNot(c, 0, this.length());
    }

    @Override
    public final int lastIndexOfAnyNot(char c1, char c2) {
        return this.lastIndexOfAnyNot(c1, c2, 0, this.length());
    }

    @Override
    public final int lastIndexOfAnyNot(char c1, char c2, char c3) {
        return this.lastIndexOfAnyNot(c1, c2, c3, 0, this.length());
    }

    @Override
    public final int lastIndexOfAnyNot(CharSequence s) {
        return this.lastIndexOfAnyNot(s, 0, this.length());
    }

    @Override
    public final int lastIndexOfNot(char c, int fromIndex) {
        return this.lastIndexOfNot(c, 0, fromIndex);
    }

    @Override
    public final int lastIndexOfAnyNot(char c1, char c2, int fromIndex) {
        return this.lastIndexOfAnyNot(c1, c2, 0, fromIndex);
    }

    @Override
    public final int lastIndexOfAnyNot(char c1, char c2, char c3, int fromIndex) {
        return this.lastIndexOfAnyNot(c1, c2, c3, 0, fromIndex);
    }

    @Override
    public final int lastIndexOfAnyNot(CharSequence s, int fromIndex) {
        return this.lastIndexOfAnyNot(s, 0, fromIndex);
    }

    @Override
    public final int lastIndexOfNot(char c, int startIndex, int fromIndex) {
        if (startIndex < 0) {
            startIndex = 0;
        }
        fromIndex = fromIndex >= this.length() ? this.length() : ++fromIndex;
        int i = fromIndex;
        while (i-- > startIndex) {
            if (this.charAt(i) == c) continue;
            return i;
        }
        return -1;
    }

    @Override
    public final int lastIndexOfAnyNot(char c1, char c2, int startIndex, int fromIndex) {
        if (startIndex < 0) {
            startIndex = 0;
        }
        fromIndex = fromIndex >= this.length() ? this.length() : ++fromIndex;
        int i = fromIndex;
        while (i-- > startIndex) {
            char c = this.charAt(i);
            if (c == c1 || c == c2) continue;
            return i;
        }
        return -1;
    }

    @Override
    public final int lastIndexOfAnyNot(char c1, char c2, char c3, int startIndex, int fromIndex) {
        if (startIndex < 0) {
            startIndex = 0;
        }
        fromIndex = fromIndex >= this.length() ? this.length() : ++fromIndex;
        int i = fromIndex;
        while (i-- > startIndex) {
            char c = this.charAt(i);
            if (c == c1 || c == c2 || c == c3) continue;
            return i;
        }
        return -1;
    }

    @Override
    public final int lastIndexOfAnyNot(CharSequence s, int startIndex, int fromIndex) {
        switch (s.length()) {
            case 0: {
                return startIndex;
            }
            case 1: {
                return this.lastIndexOfNot(s.charAt(0), startIndex, fromIndex);
            }
            case 2: {
                return this.lastIndexOfAnyNot(s.charAt(0), s.charAt(1), startIndex, fromIndex);
            }
            case 3: {
                return this.lastIndexOfAnyNot(s.charAt(0), s.charAt(1), s.charAt(2), startIndex, fromIndex);
            }
        }
        T sequence = this.sequenceOf(s);
        if (startIndex < 0) {
            startIndex = 0;
        }
        fromIndex = fromIndex >= this.length() ? this.length() : ++fromIndex;
        int i = fromIndex;
        while (i-- > startIndex) {
            char c = this.charAt(i);
            if (sequence.indexOf(c) != -1) continue;
            return i;
        }
        return -1;
    }

    @Override
    public final int countOf(char c) {
        return this.countOf(c, 0, this.length());
    }

    @Override
    public final int countOfNot(char c) {
        return this.countOfNot(c, 0, this.length());
    }

    @Override
    public final int countOf(char c, int fromIndex) {
        return this.countOf(c, fromIndex, this.length());
    }

    @Override
    public final int countOfNot(char c, int fromIndex) {
        return this.countOfNot(c, fromIndex, this.length());
    }

    @Override
    public final int countOf() {
        return this.countOfAny(" \t", 0, this.length());
    }

    @Override
    public final int countOfNot() {
        return this.countOfAnyNot(" \t", 0, this.length());
    }

    @Override
    public final int countOfAny(CharSequence chars) {
        return this.countOfAny(chars, 0, this.length());
    }

    @Override
    public final int countOfAnyNot(CharSequence chars) {
        return this.countOfAnyNot(chars, 0, this.length());
    }

    @Override
    public final int countOfAny(CharSequence chars, int fromIndex) {
        return this.countOfAny(chars, fromIndex, this.length());
    }

    @Override
    public final int countOfAnyNot(CharSequence chars, int fromIndex) {
        return this.countOfAnyNot(chars, fromIndex, this.length());
    }

    @Override
    public final int countOf(char c1, int startIndex, int fromIndex) {
        if (startIndex < 0) {
            startIndex = 0;
        }
        fromIndex = fromIndex >= this.length() ? this.length() : ++fromIndex;
        int count = 0;
        int i = fromIndex;
        while (i-- > startIndex) {
            char c = this.charAt(i);
            if (c != c1) continue;
            ++count;
        }
        return count;
    }

    @Override
    public final int countOfAny(CharSequence s, int fromIndex, int endIndex) {
        T sequence = this.sequenceOf(s);
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (endIndex > this.length()) {
            endIndex = this.length();
        }
        int count = 0;
        for (int i = fromIndex; i < endIndex; ++i) {
            char c = this.charAt(i);
            if (sequence.indexOf(c) == -1) continue;
            ++count;
        }
        return count;
    }

    @Override
    public final int countOfNot(char c1, int startIndex, int fromIndex) {
        if (startIndex < 0) {
            startIndex = 0;
        }
        fromIndex = fromIndex >= this.length() ? this.length() : ++fromIndex;
        int count = 0;
        int i = fromIndex;
        while (i-- > startIndex) {
            char c = this.charAt(i);
            if (c == c1) continue;
            ++count;
        }
        return count;
    }

    @Override
    public final int countOfAnyNot(CharSequence s, int fromIndex, int endIndex) {
        T sequence = this.sequenceOf(s);
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (endIndex > this.length()) {
            endIndex = this.length();
        }
        int count = 0;
        for (int i = fromIndex; i < endIndex; ++i) {
            char c = this.charAt(i);
            if (sequence.indexOf(c) != -1) continue;
            ++count;
        }
        return count;
    }

    @Override
    public final int startOfDelimitedBy(CharSequence s, int index) {
        if (index < 0) {
            index = 0;
        } else if (index > this.length()) {
            index = this.length();
        }
        int offset = this.lastIndexOf(s, index - 1);
        return offset == -1 ? 0 : offset + 1;
    }

    @Override
    public final int startOfDelimitedByAny(CharSequence s, int index) {
        if (index < 0) {
            index = 0;
        } else if (index > this.length()) {
            index = this.length();
        }
        int offset = this.lastIndexOfAny(s, index - 1);
        return offset == -1 ? 0 : offset + 1;
    }

    @Override
    public final int startOfDelimitedByAnyNot(CharSequence s, int index) {
        if (index < 0) {
            index = 0;
        } else if (index > this.length()) {
            index = this.length();
        }
        int offset = this.lastIndexOfAnyNot(s, index - 1);
        return offset == -1 ? 0 : offset + 1;
    }

    @Override
    public final int endOfDelimitedBy(CharSequence s, int index) {
        if (index < 0) {
            index = 0;
        } else if (index > this.length()) {
            index = this.length();
        }
        int offset = this.indexOf(s, index);
        return offset == -1 ? this.length() : offset;
    }

    @Override
    public final int endOfDelimitedByAny(CharSequence s, int index) {
        if (index < 0) {
            index = 0;
        } else if (index > this.length()) {
            index = this.length();
        }
        int offset = this.indexOfAny(s, index);
        return offset == -1 ? this.length() : offset;
    }

    @Override
    public final int endOfDelimitedByAnyNot(CharSequence s, int index) {
        if (index < 0) {
            index = 0;
        } else if (index > this.length()) {
            index = this.length();
        }
        int offset = this.indexOfAnyNot(s, index);
        return offset == -1 ? this.length() : offset;
    }

    @Override
    public final int endOfLine(int index) {
        return this.endOfDelimitedBy("\n", index);
    }

    @Override
    public final int endOfLineAnyEOL(int index) {
        return this.endOfDelimitedByAny("\r\n", index);
    }

    @Override
    public final int startOfLine(int index) {
        return this.startOfDelimitedBy("\n", index);
    }

    @Override
    public final int startOfLineAnyEOL(int index) {
        return this.startOfDelimitedByAny("\r\n", index);
    }

    @Override
    public final T lineAt(int index) {
        return (T)this.subSequence(this.startOfLine(index), this.endOfLine(index));
    }

    @Override
    public final T lineAtAnyEOL(int index) {
        return (T)this.subSequence(this.startOfLineAnyEOL(index), this.endOfLineAnyEOL(index));
    }

    @Override
    public final int countLeading(char c) {
        return this.countLeading(c, 0, this.length());
    }

    @Override
    public final int countLeadingNot(char c) {
        return this.countLeadingNot(c, 0, this.length());
    }

    @Override
    public final int countLeading(char c, int fromIndex) {
        return this.countLeading(c, fromIndex, this.length());
    }

    @Override
    public final int countLeadingNot(char c, int fromIndex) {
        return this.countLeadingNot(c, fromIndex, this.length());
    }

    @Override
    public final int countTrailing(char c) {
        return this.countTrailing(c, 0, this.length());
    }

    @Override
    public final int countTrailingNot(char c) {
        return this.countTrailingNot(c, 0, this.length());
    }

    @Override
    public final int countTrailing(char c, int fromIndex) {
        return this.countTrailing(c, 0, fromIndex);
    }

    @Override
    public final int countTrailingNot(char c, int fromIndex) {
        return this.countTrailingNot(c, 0, fromIndex);
    }

    @Override
    public final int countLeading(char c, int fromIndex, int endIndex) {
        int index;
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (endIndex > this.length()) {
            endIndex = this.length();
        }
        if (fromIndex > endIndex) {
            fromIndex = endIndex;
        }
        return (index = this.indexOfNot(c, fromIndex, endIndex)) == -1 ? endIndex - fromIndex : index - fromIndex;
    }

    @Override
    public final int countTrailing(char c, int startIndex, int fromIndex) {
        int index;
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (fromIndex > this.length()) {
            fromIndex = this.length();
        }
        if (startIndex > fromIndex) {
            startIndex = fromIndex;
        }
        return (index = this.lastIndexOfNot(c, startIndex, fromIndex)) == -1 ? fromIndex - startIndex : fromIndex - index - 1;
    }

    @Override
    public final int countLeadingNot(char c, int fromIndex, int endIndex) {
        int index;
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (endIndex > this.length()) {
            endIndex = this.length();
        }
        if (fromIndex > endIndex) {
            fromIndex = endIndex;
        }
        return (index = this.indexOf(c, fromIndex, endIndex)) == -1 ? endIndex - fromIndex : index - fromIndex;
    }

    @Override
    public final int countTrailingNot(char c, int startIndex, int fromIndex) {
        int index;
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (fromIndex > this.length()) {
            fromIndex = this.length();
        }
        if (startIndex > fromIndex) {
            startIndex = fromIndex;
        }
        return (index = this.lastIndexOf(c, startIndex, fromIndex)) == -1 ? fromIndex - startIndex : fromIndex - index - 1;
    }

    @Override
    public final int countLeading() {
        return this.countLeading(" \t", 0, this.length());
    }

    @Override
    public final int countLeadingNot() {
        return this.countLeadingNot(" \t", 0, this.length());
    }

    @Override
    public final int countTrailing() {
        return this.countTrailing(" \t", 0, this.length());
    }

    @Override
    public final int countTrailingNot() {
        return this.countTrailingNot(" \t", 0, this.length());
    }

    @Override
    public final int countLeading(CharSequence chars) {
        return this.countLeading(chars, 0, this.length());
    }

    @Override
    public final int countLeadingNot(CharSequence chars) {
        return this.countLeadingNot(chars, 0, this.length());
    }

    @Override
    public final int countLeading(CharSequence chars, int fromIndex) {
        return this.countLeading(chars, fromIndex, this.length());
    }

    @Override
    public final int countLeadingNot(CharSequence chars, int fromIndex) {
        return this.countLeadingNot(chars, fromIndex, this.length());
    }

    @Override
    public final int countTrailing(CharSequence chars) {
        return this.countTrailing(chars, 0, this.length());
    }

    @Override
    public final int countTrailingNot(CharSequence chars) {
        return this.countTrailingNot(chars, 0, this.length());
    }

    @Override
    public final int countTrailing(CharSequence chars, int fromIndex) {
        return this.countTrailing(chars, 0, fromIndex);
    }

    @Override
    public final int countTrailingNot(CharSequence chars, int fromIndex) {
        return this.countTrailingNot(chars, 0, fromIndex);
    }

    @Override
    public final int countLeading(CharSequence chars, int fromIndex, int endIndex) {
        int index;
        if (chars.length() == 0) {
            return 0;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (endIndex > this.length()) {
            endIndex = this.length();
        }
        if (fromIndex > endIndex) {
            fromIndex = endIndex;
        }
        return (index = this.indexOfAnyNot(chars, fromIndex, endIndex)) == -1 ? endIndex - fromIndex : index - fromIndex;
    }

    public static int columnsToNextTabStop(int column) {
        return 4 - column % 4;
    }

    @Override
    public final int countLeadingColumns(int startColumn, CharSequence chars) {
        if (chars.length() == 0) {
            return 0;
        }
        int fromIndex = 0;
        int endIndex = this.length();
        int index = this.indexOfAnyNot(chars, fromIndex, endIndex);
        int end = index == -1 ? endIndex : index;
        int columns = index == -1 ? endIndex - fromIndex : index - fromIndex;
        int tab = this.indexOf('\t', fromIndex, end);
        if (tab != -1) {
            int delta = startColumn;
            do {
                delta += tab + RichCharSequenceBase.columnsToNextTabStop(tab + delta);
            } while ((tab = this.indexOf('\t', tab + 1)) >= 0 && tab < endIndex);
            columns += delta;
        }
        return columns;
    }

    @Override
    public final int countTrailing(CharSequence chars, int startIndex, int fromIndex) {
        int index;
        if (chars.length() == 0) {
            return 0;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (fromIndex > this.length()) {
            fromIndex = this.length();
        }
        if (startIndex > fromIndex) {
            startIndex = fromIndex;
        }
        return (index = this.lastIndexOfAnyNot(chars, startIndex, fromIndex)) == -1 ? fromIndex - startIndex : (fromIndex <= index ? 0 : fromIndex - index - 1);
    }

    @Override
    public final int countLeadingNot(CharSequence chars, int fromIndex, int endIndex) {
        int index;
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (endIndex > this.length()) {
            endIndex = this.length();
        }
        if (fromIndex > endIndex) {
            fromIndex = endIndex;
        }
        return (index = this.indexOfAny(chars, fromIndex, endIndex)) == -1 ? endIndex - fromIndex : index - fromIndex;
    }

    @Override
    public final int countTrailingNot(CharSequence chars, int startIndex, int fromIndex) {
        int index;
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (fromIndex > this.length()) {
            fromIndex = this.length();
        }
        if (startIndex > fromIndex) {
            startIndex = fromIndex;
        }
        return (index = this.lastIndexOfAny(chars, startIndex, fromIndex)) == -1 ? fromIndex - startIndex : (fromIndex <= index ? 0 : fromIndex - index - 1);
    }

    @Override
    public final T trimStart(int keepLength, CharSequence chars) {
        int trim = Utils.maxLimit(this.countLeading(chars, 0, this.length()), this.length() - keepLength);
        return (T)(trim > 0 ? this.subSequence(trim, this.length()) : this);
    }

    @Override
    public final T trimmedStart(int keepLength, CharSequence chars) {
        int trim = Utils.maxLimit(this.countLeading(chars, 0, this.length()), this.length() - keepLength);
        return (T)(trim > 0 ? this.subSequence(0, trim) : this.nullSequence());
    }

    @Override
    public final T trimEnd(int keepLength, CharSequence chars) {
        int trim = Utils.maxLimit(this.countTrailing(chars, 0, this.length()), this.length() - keepLength);
        return (T)(trim > 0 ? this.subSequence(0, this.length() - trim) : this);
    }

    @Override
    public final T trimmedEnd(int keepLength, CharSequence chars) {
        int trim = Utils.maxLimit(this.countTrailing(chars, 0, this.length()), this.length() - keepLength);
        return trim > 0 ? this.subSequence(this.length() - trim) : this.nullSequence();
    }

    @Override
    public final T trimStart(CharSequence chars) {
        return this.trimStart(0, chars);
    }

    @Override
    public final T trimmedStart(CharSequence chars) {
        return this.trimmedStart(0, chars);
    }

    @Override
    public final T trimEnd(CharSequence chars) {
        return this.trimEnd(0, chars);
    }

    @Override
    public final T trimmedEnd(CharSequence chars) {
        return this.trimmedEnd(0, chars);
    }

    @Override
    public final T trim(CharSequence chars) {
        int trimEnd;
        int trimStart = this.countLeading(chars, 0, this.length());
        int trimmed = trimStart + (trimEnd = this.countTrailing(chars, 0, this.length()));
        return (T)(trimmed > 0 ? (trimmed >= this.length() ? this.subSequence(0, 0) : this.subSequence(trimStart, this.length() - trimEnd)) : this);
    }

    @Override
    public final T trimStart(int keepLength) {
        return this.trimStart(keepLength, " \t\r\n");
    }

    @Override
    public final T trimmedStart(int keepLength) {
        return this.trimmedStart(keepLength, " \t\r\n");
    }

    @Override
    public final T trimEnd(int keepLength) {
        return this.trimEnd(keepLength, " \t\r\n");
    }

    @Override
    public final T trimmedEnd(int keepLength) {
        return this.trimmedEnd(keepLength, " \t\r\n");
    }

    @Override
    public final T trimStart() {
        return this.trimStart(0, " \t\r\n");
    }

    @Override
    public final T trimmedStart() {
        return this.trimmedStart(0, " \t\r\n");
    }

    @Override
    public final T trimEnd() {
        return this.trimEnd(0, " \t\r\n");
    }

    @Override
    public final T trimmedEnd() {
        return this.trimmedEnd(0, " \t\r\n");
    }

    @Override
    public final T padStart(int length, char pad) {
        return (T)(length <= this.length() ? this : this.sequenceOf(RepeatedCharSequence.of(pad, length - this.length())));
    }

    @Override
    public final T padEnd(int length, char pad) {
        return (T)(length <= this.length() ? this : this.append(RepeatedCharSequence.of(pad, length - this.length())));
    }

    @Override
    public final T padStart(int length) {
        return this.padStart(length, ' ');
    }

    @Override
    public final T padEnd(int length) {
        return this.padEnd(length, ' ');
    }

    @Override
    public final int eolLength() {
        int startIndex = this.length() - 1;
        int pos = startIndex;
        if (pos >= 0) {
            char c = this.charAt(pos);
            if (c == '\r') {
                if (--pos >= 0 && this.charAt(pos) == '\n') {
                    --pos;
                }
            } else if (c == '\n') {
                --pos;
            }
        }
        return startIndex - pos;
    }

    @Override
    public final int eolLength(int eolStart) {
        int pos = eolStart;
        int length = this.length();
        if (pos >= 0 && pos < length) {
            char c = this.charAt(pos);
            if (c == '\r') {
                if (++pos < length && this.charAt(pos) == '\n') {
                    ++pos;
                }
            } else if (c == '\n') {
                ++pos;
            }
        }
        return pos - eolStart;
    }

    @Override
    public final T trimEOL() {
        int trim = this.eolLength();
        return (T)(trim > 0 ? this.subSequence(0, this.length() - trim) : this);
    }

    @Override
    public final T trimmedEOL() {
        int trim = this.eolLength();
        return trim > 0 ? this.subSequence(this.length() - trim) : this.nullSequence();
    }

    @Override
    public final T trim() {
        int trimStart = this.countLeading(" \t\r\n", 0, this.length());
        if (trimStart == this.length()) {
            return (T)this.subSequence(trimStart, trimStart);
        }
        int trimEnd = this.countTrailing(" \t\r\n", 0, this.length());
        return (T)(trimStart > 0 || trimEnd > 0 ? this.subSequence(trimStart, this.length() - trimEnd) : this);
    }

    @Override
    public final T ifNull(T other) {
        return (T)(this.isNull() ? other : this);
    }

    @Override
    public final T ifNullEmptyAfter(T other) {
        return (T)(this.isNull() ? other.subSequence(other.length(), other.length()) : this);
    }

    @Override
    public final T ifNullEmptyBefore(T other) {
        return (T)(this.isNull() ? other.subSequence(0, 0) : this);
    }

    @Override
    public final T nullIfEmpty() {
        return (T)(this.isEmpty() ? this.nullSequence() : this);
    }

    @Override
    public final T nullIfBlank() {
        return (T)(this.isBlank() ? this.nullSequence() : this);
    }

    @Override
    public final T nullIf(boolean condition) {
        return (T)(condition ? this.nullSequence() : this);
    }

    @Override
    public final T nullIf(CharSequence ... matches) {
        for (CharSequence match : matches) {
            if (!this.matches(match)) continue;
            return this.nullSequence();
        }
        return (T)this;
    }

    @Override
    public final T nullIfNot(CharSequence ... matches) {
        for (CharSequence match : matches) {
            if (!this.matches(match)) continue;
            return (T)this;
        }
        return this.nullSequence();
    }

    @Override
    public final T nullIfStartsWith(CharSequence ... matches) {
        for (CharSequence match : matches) {
            if (!this.startsWith(match)) continue;
            return this.nullSequence();
        }
        return (T)this;
    }

    @Override
    public final T nullIfStartsWithNot(CharSequence ... matches) {
        for (CharSequence match : matches) {
            if (!this.startsWith(match)) continue;
            return (T)this;
        }
        return this.nullSequence();
    }

    @Override
    public final T nullIfEndsWith(CharSequence ... matches) {
        for (CharSequence match : matches) {
            if (!this.endsWith(match)) continue;
            return this.nullSequence();
        }
        return (T)this;
    }

    @Override
    public final T nullIfEndsWithNot(CharSequence ... matches) {
        for (CharSequence match : matches) {
            if (!this.endsWith(match)) continue;
            return (T)this;
        }
        return this.nullSequence();
    }

    @Override
    public final boolean isEmpty() {
        return this.length() == 0;
    }

    @Override
    public final boolean isBlank() {
        return this.isEmpty() || this.countLeading(" \t\r\n", 0, this.length()) == this.length();
    }

    @Override
    public final boolean isNull() {
        return this == this.nullSequence();
    }

    @Override
    public final boolean isNotNull() {
        return this != this.nullSequence();
    }

    @Override
    public final boolean endsWith(CharSequence suffix) {
        return this.length() > 0 && this.matchCharsReversed(suffix, this.length() - 1, false);
    }

    @Override
    public final boolean startsWith(CharSequence prefix) {
        return this.length() > 0 && this.matchChars(prefix, 0, false);
    }

    @Override
    public final T removeSuffix(CharSequence suffix) {
        return (T)(!this.endsWith(suffix) ? this : this.subSequence(0, this.length() - suffix.length()));
    }

    @Override
    public final T removePrefix(CharSequence prefix) {
        return (T)(!this.startsWith(prefix) ? this : this.subSequence(prefix.length(), this.length()));
    }

    @Override
    public final T removeProperSuffix(CharSequence suffix) {
        return (T)(this.length() <= suffix.length() || !this.endsWith(suffix) ? this : this.subSequence(0, this.length() - suffix.length()));
    }

    @Override
    public final T removeProperPrefix(CharSequence prefix) {
        return (T)(this.length() <= prefix.length() || !this.startsWith(prefix) ? this : this.subSequence(prefix.length(), this.length()));
    }

    @Override
    public final boolean endsWithIgnoreCase(CharSequence suffix) {
        return this.length() > 0 && this.matchCharsReversed(suffix, this.length() - 1, true);
    }

    @Override
    public final boolean startsWithIgnoreCase(CharSequence prefix) {
        return this.length() > 0 && this.matchChars(prefix, 0, true);
    }

    @Override
    public final T removeSuffixIgnoreCase(CharSequence suffix) {
        return (T)(!this.endsWithIgnoreCase(suffix) ? this : this.subSequence(0, this.length() - suffix.length()));
    }

    @Override
    public final T removePrefixIgnoreCase(CharSequence prefix) {
        return (T)(!this.startsWithIgnoreCase(prefix) ? this : this.subSequence(prefix.length(), this.length()));
    }

    @Override
    public final T removeProperSuffixIgnoreCase(CharSequence suffix) {
        return (T)(this.length() <= suffix.length() || !this.endsWithIgnoreCase(suffix) ? this : this.subSequence(0, this.length() - suffix.length()));
    }

    @Override
    public final T removeProperPrefixIgnoreCase(CharSequence prefix) {
        return (T)(this.length() <= prefix.length() || !this.startsWithIgnoreCase(prefix) ? this : this.subSequence(prefix.length(), this.length()));
    }

    @Override
    public final boolean endsWith(CharSequence suffix, boolean ignoreCase) {
        return this.length() > 0 && this.matchCharsReversed(suffix, this.length() - 1, ignoreCase);
    }

    @Override
    public final boolean startsWith(CharSequence prefix, boolean ignoreCase) {
        return this.length() > 0 && this.matchChars(prefix, 0, ignoreCase);
    }

    @Override
    public final T removeSuffix(CharSequence suffix, boolean ignoreCase) {
        return (T)(!this.endsWith(suffix, ignoreCase) ? this : this.subSequence(0, this.length() - suffix.length()));
    }

    @Override
    public final T removePrefix(CharSequence prefix, boolean ignoreCase) {
        return (T)(!this.startsWith(prefix, ignoreCase) ? this : this.subSequence(prefix.length(), this.length()));
    }

    @Override
    public final T removeProperSuffix(CharSequence suffix, boolean ignoreCase) {
        return (T)(this.length() <= suffix.length() || !this.endsWith(suffix, ignoreCase) ? this : this.subSequence(0, this.length() - suffix.length()));
    }

    @Override
    public final T removeProperPrefix(CharSequence prefix, boolean ignoreCase) {
        return (T)(this.length() <= prefix.length() || !this.startsWith(prefix, ignoreCase) ? this : this.subSequence(prefix.length(), this.length()));
    }

    @Override
    public final T toLowerCase() {
        return this.toMapped(LowerCaseMapper.INSTANCE);
    }

    @Override
    public final T toUpperCase() {
        return this.toMapped(UpperCaseMapper.INSTANCE);
    }

    @Override
    public final T toLowerCase(Locale locale) {
        return this.toMapped(new LowerCaseMapper(locale));
    }

    @Override
    public final T toUpperCase(Locale locale) {
        return this.toMapped(new UpperCaseMapper(locale));
    }

    @Override
    public T toMapped(CharMapper mapper) {
        return this.sequenceOf(MappedSequence.of(mapper, this));
    }

    @Override
    public final boolean matches(CharSequence chars) {
        return chars.length() == this.length() && this.matchChars(chars, 0, false);
    }

    @Override
    public final boolean matchesIgnoreCase(CharSequence chars) {
        return chars.length() == this.length() && this.matchChars(chars, 0, true);
    }

    @Override
    public final boolean matches(CharSequence chars, boolean ignoreCase) {
        return chars.length() == this.length() && this.matchChars(chars, 0, ignoreCase);
    }

    @Override
    public final boolean matchChars(CharSequence chars) {
        return this.matchChars(chars, 0, false);
    }

    @Override
    public final boolean matchCharsIgnoreCase(CharSequence chars) {
        return this.matchChars(chars, 0, true);
    }

    @Override
    public final boolean matchChars(CharSequence chars, boolean ignoreCase) {
        return this.matchChars(chars, 0, ignoreCase);
    }

    @Override
    public final boolean matchChars(CharSequence chars, int startIndex) {
        return this.matchChars(chars, startIndex, false);
    }

    @Override
    public final boolean matchCharsIgnoreCase(CharSequence chars, int startIndex) {
        return this.matchChars(chars, startIndex, false);
    }

    @Override
    public final boolean matchChars(CharSequence chars, int startIndex, boolean ignoreCase) {
        int iMax = chars.length();
        if (iMax > this.length() - startIndex) {
            return false;
        }
        if (ignoreCase) {
            for (int i = 0; i < iMax; ++i) {
                char u2;
                char u1;
                char c2;
                char c1 = chars.charAt(i);
                if (c1 == (c2 = this.charAt(i + startIndex)) || (u1 = Character.toUpperCase(c1)) == (u2 = Character.toUpperCase(c2)) || Character.toLowerCase(u1) == Character.toLowerCase(u2)) continue;
                return false;
            }
        } else {
            for (int i = 0; i < iMax; ++i) {
                if (chars.charAt(i) == this.charAt(i + startIndex)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public final boolean matchCharsReversed(CharSequence chars, int endIndex) {
        return endIndex + 1 >= chars.length() && this.matchChars(chars, endIndex + 1 - chars.length(), false);
    }

    @Override
    public final boolean matchCharsReversedIgnoreCase(CharSequence chars, int endIndex) {
        return endIndex + 1 >= chars.length() && this.matchChars(chars, endIndex + 1 - chars.length(), true);
    }

    @Override
    public final boolean matchCharsReversed(CharSequence chars, int endIndex, boolean ignoreCase) {
        return endIndex + 1 >= chars.length() && this.matchChars(chars, endIndex + 1 - chars.length(), ignoreCase);
    }

    @Override
    public final T subSequence(Range range) {
        return (T)this.subSequence(range.getStart(), range.getEnd());
    }

    @Override
    public final T subSequence(int start) {
        return (T)this.subSequence(start, this.length());
    }

    @Override
    public final T trimTailBlankLines() {
        int iMax;
        int lastEOL = iMax = this.length();
        int i = iMax;
        while (i-- > 0) {
            char c = this.charAt(i);
            if (c == '\n') {
                lastEOL = i + 1;
                continue;
            }
            if (lastEOL != iMax && (c == ' ' || c == '\t')) continue;
            break;
        }
        if (i < 0) {
            return (T)this.subSequence(0, 0);
        }
        if (lastEOL != iMax) {
            return (T)this.subSequence(0, lastEOL);
        }
        return (T)this;
    }

    @Override
    public final T trimLeadBlankLines() {
        int i;
        int iMax = this.length();
        int lastEOL = 0;
        for (i = 0; i < iMax; ++i) {
            char c = this.charAt(i);
            if (c == '\n') {
                lastEOL = i + 1;
                continue;
            }
            if (c != ' ' && c != '\t') break;
        }
        if (i == iMax) {
            return (T)this.subSequence(iMax, iMax);
        }
        if (lastEOL != 0) {
            return this.subSequence(lastEOL);
        }
        return (T)this;
    }

    @Override
    public String toString() {
        int iMax = this.length();
        StringBuilder sb = new StringBuilder(iMax);
        for (int i = 0; i < iMax; ++i) {
            sb.append(this.charAt(i));
        }
        return sb.toString();
    }

    @Override
    public final String normalizeEOL() {
        return Escaping.normalizeEOL(this.toString());
    }

    @Override
    public final String normalizeEndWithEOL() {
        return Escaping.normalizeEndWithEOL(this.toString());
    }

    @Override
    public final String toVisibleWhitespaceString() {
        StringBuilder sb = new StringBuilder();
        int iMax = this.length();
        for (int i = 0; i < iMax; ++i) {
            char c = this.charAt(i);
            String s = visibleSpacesMap.get(Character.valueOf(c));
            if (s != null) {
                sb.append(s);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    @Override
    public final T[] split(char delimiter) {
        return this.split(delimiter, 0);
    }

    @Override
    public final T[] split(char delimiter, int limit) {
        return this.split(delimiter, limit, 0);
    }

    @Override
    public final T[] split(char delimiter, int limit, int flags) {
        return this.split(delimiter, limit, flags, " \t\r\n");
    }

    @Override
    public final T[] split(CharSequence delimiter) {
        return this.split(delimiter, 0);
    }

    @Override
    public final T[] split(CharSequence delimiter, int limit) {
        return this.split(delimiter, limit, 0);
    }

    @Override
    public final T[] split(CharSequence delimiter, int limit, int flags) {
        return this.split(delimiter, limit, flags, " \t\r\n");
    }

    @Override
    public final T[] split(char delimiter, int limit, int flags, String trimChars) {
        if (trimChars == null) {
            trimChars = " \t\r\n";
        }
        if (limit < 1) {
            limit = Integer.MAX_VALUE;
        }
        boolean includeDelimiterParts = (flags & 8) != 0;
        int includeDelimiter = !includeDelimiterParts && (flags & 1) != 0 ? 1 : 0;
        boolean trimParts = (flags & 2) != 0;
        boolean skipEmpty = (flags & 4) != 0;
        ArrayList<CharSequence> items = new ArrayList<CharSequence>();
        int lastPos = 0;
        int length = this.length();
        if (limit > 1) {
            int pos;
            while (lastPos < length && (pos = this.indexOf(delimiter, lastPos)) >= 0) {
                if (lastPos < pos || !skipEmpty) {
                    CharSequence item = this.subSequence(lastPos, pos + includeDelimiter);
                    if (trimParts) {
                        item = item.trim(trimChars);
                    }
                    if (!item.isEmpty() || !skipEmpty) {
                        items.add(item);
                        if (includeDelimiterParts) {
                            items.add(this.subSequence(pos, pos + 1));
                        }
                        if (items.size() >= limit - 1) {
                            lastPos = pos + 1;
                            break;
                        }
                    }
                }
                lastPos = pos + 1;
            }
        }
        if (lastPos < length) {
            CharSequence item = this.subSequence(lastPos, length);
            if (trimParts) {
                item = item.trim(trimChars);
            }
            if (!item.isEmpty() || !skipEmpty) {
                items.add(item);
            }
        }
        return items.toArray(this.emptyArray());
    }

    @Override
    public final T[] split(CharSequence delimiter, int limit, int flags, String trimChars) {
        if (trimChars == null) {
            trimChars = " \t\r\n";
        }
        if (limit < 1) {
            limit = Integer.MAX_VALUE;
        }
        boolean includeDelimiterParts = (flags & 8) != 0;
        int includeDelimiter = !includeDelimiterParts && (flags & 1) != 0 ? delimiter.length() : 0;
        boolean trimParts = (flags & 2) != 0;
        boolean skipEmpty = (flags & 4) != 0;
        ArrayList<CharSequence> items = new ArrayList<CharSequence>();
        int lastPos = 0;
        int length = this.length();
        if (limit > 1) {
            int pos;
            while (lastPos < length && (pos = this.indexOf(delimiter, lastPos)) >= 0) {
                if (lastPos < pos || !skipEmpty) {
                    CharSequence item = this.subSequence(lastPos, pos + includeDelimiter);
                    if (trimParts) {
                        item = item.trim(trimChars);
                    }
                    if (!item.isEmpty() || !skipEmpty) {
                        items.add(item);
                        if (includeDelimiterParts) {
                            items.add(this.subSequence(pos, pos + delimiter.length()));
                        }
                        if (items.size() >= limit - 1) {
                            lastPos = pos + 1;
                            break;
                        }
                    }
                }
                lastPos = pos + 1;
            }
        }
        if (lastPos < length) {
            CharSequence item = this.subSequence(lastPos, length);
            if (trimParts) {
                item = item.trim(trimChars);
            }
            if (!item.isEmpty() || !skipEmpty) {
                items.add(item);
            }
        }
        return items.toArray(this.emptyArray());
    }

    @Override
    public final T appendTo(StringBuilder out) {
        return this.appendTo(out, 0, this.length());
    }

    @Override
    public final T appendTo(StringBuilder out, int start) {
        return this.appendTo(out, start, this.length());
    }

    @Override
    public final T appendTo(StringBuilder out, int start, int end) {
        out.append(this, start, end);
        return (T)this;
    }

    public static int[] expandTo(int[] indices, int length, int step) {
        int remainder = length & step;
        int next = length + (remainder != 0 ? step : 0);
        if (indices.length < next) {
            int[] replace = new int[next];
            System.arraycopy(indices, 0, replace, 0, indices.length);
            return replace;
        }
        return indices;
    }

    public static int[] truncateTo(int[] indices, int length) {
        if (indices.length > length) {
            int[] replace = new int[length];
            System.arraycopy(indices, 0, replace, 0, length);
            return replace;
        }
        return indices;
    }

    @Override
    public final int[] indexOfAll(CharSequence s) {
        int length = s.length();
        if (length == 0) {
            return EMPTY_INDICES;
        }
        int pos = this.indexOf(s);
        if (pos == -1) {
            return EMPTY_INDICES;
        }
        int iMax = 0;
        int[] indices = new int[32];
        indices[iMax++] = pos;
        while ((pos = this.indexOf(s, pos + length)) != -1) {
            if (indices.length <= iMax) {
                indices = RichCharSequenceBase.expandTo(indices, iMax + 1, 32);
            }
            indices[iMax++] = pos;
        }
        return RichCharSequenceBase.truncateTo(indices, iMax);
    }

    @Override
    public final T replace(CharSequence find, CharSequence replace) {
        int[] indices = this.indexOfAll(find);
        if (indices.length == 0) {
            return (T)this;
        }
        int iMax = indices.length;
        StringBuilder sb = new StringBuilder(this.length() + (replace.length() - find.length()) * iMax);
        int i = 0;
        int lastPos = 0;
        while (i < iMax) {
            int pos;
            if (lastPos < (pos = indices[i++])) {
                this.appendTo(sb, lastPos, pos);
            }
            lastPos = pos + find.length();
            sb.append(replace);
        }
        if (lastPos < this.length()) {
            this.appendTo(sb, lastPos, this.length());
        }
        return this.sequenceOf(sb);
    }

    @Override
    public final T append(CharSequence ... others) {
        if (others.length > 0) {
            int total = 0;
            for (CharSequence other : others) {
                total += other.length();
            }
            StringBuilder sb = new StringBuilder(this.length() + total);
            this.appendTo(sb);
            for (CharSequence other : others) {
                sb.append(other);
            }
            return this.sequenceOf(sb);
        }
        return (T)this;
    }

    @Override
    public final int getColumnAtIndex(int index) {
        int lineStart = this.lastIndexOfAny("\r\n", index);
        return index - (lineStart == -1 ? 0 : lineStart + this.eolLength(lineStart));
    }

    @Override
    public final Pair<Integer, Integer> getLineColumnAtIndex(int index) {
        int iMax = this.length();
        if (index < 0 || index > iMax) {
            throw new IllegalArgumentException("Index: " + index + " out of range [0, " + iMax + "]");
        }
        boolean hadCr = false;
        boolean hadEOL = true;
        int line = 0;
        int col = 0;
        for (int i = 0; i < index; ++i) {
            char c1 = this.charAt(i);
            if (c1 == '\r') {
                col = 0;
                ++line;
                hadCr = true;
                continue;
            }
            if (c1 == '\n') {
                if (!hadCr) {
                    ++line;
                }
                col = 0;
                hadCr = false;
                continue;
            }
            ++col;
        }
        return new Pair<Integer, Integer>(line, col);
    }

    public boolean equals(Object other) {
        return this == other || other instanceof CharSequence && ((CharSequence)other).length() == this.length() && this.matchChars((CharSequence)other, 0, false);
    }

    @Override
    public boolean equalsIgnoreCase(CharSequence other) {
        return this == other || other != null && other.length() == this.length() && this.matchChars(other, 0, true);
    }

    @Override
    public boolean equals(Object other, boolean ignoreCase) {
        return this == other || other instanceof CharSequence && ((CharSequence)other).length() == this.length() && this.matchChars((CharSequence)other, 0, ignoreCase);
    }

    @Override
    public int compareTo(CharSequence other) {
        int len2;
        int len1 = this.length();
        int iMax = len1 <= (len2 = other.length()) ? len1 : len2;
        for (int i = 0; i < iMax; ++i) {
            char c2;
            char c1 = this.charAt(i);
            if (c1 == (c2 = other.charAt(i))) continue;
            return c1 - c2;
        }
        return len1 - len2;
    }

    static {
        HashMap<Character, String> charMap = new HashMap<Character, String>();
        visibleSpacesMap = charMap;
        charMap.put(Character.valueOf('\n'), "\\n");
        charMap.put(Character.valueOf('\r'), "\\r");
        charMap.put(Character.valueOf('\f'), "\\f");
        charMap.put(Character.valueOf('\t'), "\\u2192");
    }
}

