/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.map.events;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.DomEvent;
import com.vaadin.flow.component.EventData;
import com.vaadin.flow.component.map.Map;
import com.vaadin.flow.component.map.MapBase;
import com.vaadin.flow.component.map.configuration.Feature;
import com.vaadin.flow.component.map.configuration.layer.VectorLayer;
import com.vaadin.flow.component.map.configuration.source.VectorSource;
import com.vaadin.flow.component.map.events.MouseEventDetails;
import com.vaadin.flow.internal.JacksonUtils;
import java.util.List;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ArrayNode;

@DomEvent(value="map-cluster-click")
public class MapClusterClickEvent
extends ComponentEvent<MapBase> {
    private final List<Feature> features;
    private final VectorLayer layer;
    private final VectorSource vectorSource;
    private final MouseEventDetails details;

    public MapClusterClickEvent(Map source, boolean fromClient, @EventData(value="event.detail.features.map(feature => feature.id)") ArrayNode featureIds, @EventData(value="event.detail.layer.id") String layerId, @EventData(value="event.detail.originalEvent.pageX") int pageX, @EventData(value="event.detail.originalEvent.pageY") int pageY, @EventData(value="event.detail.originalEvent.altKey") boolean altKey, @EventData(value="event.detail.originalEvent.ctrlKey") boolean ctrlKey, @EventData(value="event.detail.originalEvent.metaKey") boolean metaKey, @EventData(value="event.detail.originalEvent.shiftKey") boolean shiftKey, @EventData(value="event.detail.originalEvent.button") int button) {
        super((Component)source, fromClient);
        this.layer = source.getRawConfiguration().getLayers().stream().filter(l -> l instanceof VectorLayer && l.getId() != null && l.getId().equals(layerId)).map(l -> (VectorLayer)l).findFirst().orElseThrow(() -> new IllegalStateException("No vector layer with id " + layerId));
        this.vectorSource = (VectorSource)this.layer.getSource();
        List<String> featureIdList = JacksonUtils.stream((ArrayNode)featureIds).map(JsonNode::asString).toList();
        this.features = this.vectorSource.getFeatures().stream().filter(feature -> featureIdList.contains(feature.getId())).toList();
        this.details = new MouseEventDetails();
        this.details.setAbsoluteX(pageX);
        this.details.setAbsoluteY(pageY);
        this.details.setButton(MouseEventDetails.MouseButton.of(button));
        this.details.setAltKey(altKey);
        this.details.setCtrlKey(ctrlKey);
        this.details.setMetaKey(metaKey);
        this.details.setShiftKey(shiftKey);
    }

    public List<Feature> getFeatures() {
        return this.features;
    }

    public VectorLayer getLayer() {
        return this.layer;
    }

    public VectorSource getVectorSource() {
        return this.vectorSource;
    }

    public MouseEventDetails getMouseDetails() {
        return this.details;
    }
}

