/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.pro.licensechecker.json.impl;

import com.vaadin.pro.licensechecker.json.LicenseCheckerJsonNumber;
import com.vaadin.pro.licensechecker.json.LicenseCheckerJsonType;
import com.vaadin.pro.licensechecker.json.LicenseCheckerJsonValue;
import com.vaadin.pro.licensechecker.json.impl.LicenseCheckerJreJsonValue;
import com.vaadin.pro.licensechecker.json.impl.LicenseCheckerJsonContext;
import com.vaadin.pro.licensechecker.json.impl.LicenseCheckerJsonVisitor;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class LicenseCheckerJreJsonNumber
extends LicenseCheckerJreJsonValue
implements LicenseCheckerJsonNumber {
    private static final long serialVersionUID = 1L;
    private transient double number;

    public LicenseCheckerJreJsonNumber(double number) {
        this.number = number;
    }

    @Override
    public boolean asBoolean() {
        return !Double.isNaN(this.getNumber()) && Math.abs(this.getNumber()) != 0.0;
    }

    @Override
    public double asNumber() {
        return this.getNumber();
    }

    @Override
    public String asString() {
        return this.toJson();
    }

    @Override
    public double getNumber() {
        return this.number;
    }

    @Override
    public Object getObject() {
        return this.getNumber();
    }

    @Override
    public LicenseCheckerJsonType getType() {
        return LicenseCheckerJsonType.NUMBER;
    }

    @Override
    public boolean jsEquals(LicenseCheckerJsonValue value) {
        return this.getObject().equals(((LicenseCheckerJreJsonValue)value).getObject());
    }

    @Override
    public void traverse(LicenseCheckerJsonVisitor visitor, LicenseCheckerJsonContext ctx) {
        visitor.visit(this.getNumber(), ctx);
    }

    @Override
    public String toJson() {
        if (Double.isInfinite(this.number) || Double.isNaN(this.number)) {
            return "null";
        }
        String toReturn = String.valueOf(this.number);
        if (toReturn.endsWith(".0")) {
            toReturn = toReturn.substring(0, toReturn.length() - 2);
        }
        return toReturn;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        LicenseCheckerJreJsonNumber instance = (LicenseCheckerJreJsonNumber)LicenseCheckerJreJsonNumber.parseJson(stream);
        this.number = instance.number;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeObject(this.toJson());
    }
}

