/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal;

import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinService;
import java.io.Serializable;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class ActiveStyleSheetTracker
implements Serializable {
    private final Set<String> componentUrls = ConcurrentHashMap.newKeySet();
    private final Set<String> appShellUrls = ConcurrentHashMap.newKeySet();

    private ActiveStyleSheetTracker() {
    }

    public static ActiveStyleSheetTracker get(VaadinService service) {
        Objects.requireNonNull(service, "service cannot be null");
        VaadinContext context = service.getContext();
        return context.getAttribute(ActiveStyleSheetTracker.class, ActiveStyleSheetTracker::new);
    }

    public static ActiveStyleSheetTracker get(VaadinContext context) {
        Objects.requireNonNull(context, "context cannot be null");
        return context.getAttribute(ActiveStyleSheetTracker.class, ActiveStyleSheetTracker::new);
    }

    public void trackAddForComponent(String url) {
        if (url == null || url.isBlank()) {
            return;
        }
        this.componentUrls.add(url);
    }

    public void trackRemoveForComponent(String url) {
        if (url == null || url.isBlank()) {
            return;
        }
        this.componentUrls.remove(url);
    }

    public void trackForAppShell(Collection<String> urls) {
        this.appShellUrls.clear();
        if (urls != null) {
            this.appShellUrls.addAll(urls);
        }
    }

    public Set<String> getActiveUrls() {
        ConcurrentHashMap.KeySetView all = ConcurrentHashMap.newKeySet();
        all.addAll(this.appShellUrls);
        all.addAll(this.componentUrls);
        return all;
    }
}

