/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.server.AbstractStreamResource;
import com.vaadin.flow.server.StreamReceiver;
import com.vaadin.flow.server.StreamRegistration;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.communication.StreamRequestHandler;
import com.vaadin.flow.server.streams.ElementRequestHandler;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class StreamResourceRegistry
implements Serializable {
    private final Map<URI, AbstractStreamResource> res = new HashMap<URI, AbstractStreamResource>();
    private final VaadinSession session;

    public StreamResourceRegistry(VaadinSession session) {
        this.session = session;
    }

    public StreamRegistration registerResource(AbstractStreamResource resource) {
        this.session.checkHasLock("Session needs to be locked when registering stream resources.");
        Registration registration = new Registration(this, resource.getId(), resource.getName());
        this.res.put(registration.getResourceUri(), resource);
        return registration;
    }

    public StreamRegistration registerResource(ElementRequestHandler elementRequestHandler) {
        return this.registerResource(elementRequestHandler, UI.getCurrentOrThrow().getElement());
    }

    public StreamRegistration registerResource(ElementRequestHandler elementRequestHandler, Element owner) {
        ElementStreamResource wrappedResource = new ElementStreamResource(elementRequestHandler, owner);
        return this.registerResource(wrappedResource);
    }

    public void unregisterResource(StreamReceiver resource) {
        this.res.remove(StreamResourceRegistry.getURI(resource));
    }

    public static URI getURI(AbstractStreamResource resource) {
        return StreamResourceRegistry.getURI(resource.getName(), resource.getId());
    }

    public URI getTargetURI(AbstractStreamResource resource) {
        return StreamResourceRegistry.getURI(resource);
    }

    private static URI getURI(String name, String id) {
        try {
            return new URI(StreamRequestHandler.generateURI(name, id));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public Optional<AbstractStreamResource> getResource(URI uri) {
        this.session.checkHasLock();
        return Optional.ofNullable(this.res.get(uri));
    }

    public <T extends AbstractStreamResource> Optional<T> getResource(Class<T> type, URI uri) {
        this.session.checkHasLock();
        AbstractStreamResource abstractStreamResource = this.res.get(uri);
        if (abstractStreamResource != null && type.isAssignableFrom(abstractStreamResource.getClass())) {
            return Optional.of(abstractStreamResource);
        }
        return Optional.empty();
    }

    private static final class Registration
    implements StreamRegistration {
        private final StreamResourceRegistry registry;
        private final URI uri;

        private Registration(StreamResourceRegistry registry, String id, String name) {
            this.registry = registry;
            this.uri = StreamResourceRegistry.getURI(name, id);
        }

        @Override
        public URI getResourceUri() {
            return this.uri;
        }

        @Override
        public void unregister() {
            this.registry.res.remove(this.getResourceUri());
        }

        @Override
        public AbstractStreamResource getResource() {
            Optional<AbstractStreamResource> resource = this.registry.getResource(this.getResourceUri());
            return resource.isPresent() ? resource.get() : null;
        }
    }

    public static class ElementStreamResource
    extends AbstractStreamResource {
        private final ElementRequestHandler elementRequestHandler;
        private final Element owner;

        public ElementStreamResource(ElementRequestHandler elementRequestHandler, Element owner) {
            this.elementRequestHandler = elementRequestHandler;
            this.owner = owner;
        }

        public ElementRequestHandler getElementRequestHandler() {
            return this.elementRequestHandler;
        }

        @Override
        public String getName() {
            return this.elementRequestHandler.getUrlPostfix() == null ? "" : this.elementRequestHandler.getUrlPostfix();
        }

        public Element getOwner() {
            return this.owner;
        }
    }
}

