/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.flow.server.frontend.AbstractTaskClientGenerator;
import com.vaadin.flow.server.frontend.Options;
import com.vaadin.flow.server.frontend.TypeScriptBootstrapModifier;
import com.vaadin.flow.server.frontend.scanner.FrontendDependenciesScanner;
import com.vaadin.flow.theme.ThemeDefinition;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.LoggerFactory;

public class TaskGenerateBootstrap
extends AbstractTaskClientGenerator {
    static final String DEV_TOOLS_IMPORT = String.format("import '%svaadin-dev-tools.js';%n", "Frontend/generated/jar-resources/vaadin-dev-tools/");
    private final FrontendDependenciesScanner frontDeps;
    private final Options options;
    private List<TypeScriptBootstrapModifier> modifiers;

    TaskGenerateBootstrap(FrontendDependenciesScanner frontDeps, Options options) {
        this.frontDeps = frontDeps;
        this.options = options;
        this.modifiers = new ArrayList<TypeScriptBootstrapModifier>();
        for (Class<TypeScriptBootstrapModifier> modifierClass : options.getClassFinder().getSubTypesOf(TypeScriptBootstrapModifier.class)) {
            try {
                this.modifiers.add(modifierClass.getConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                LoggerFactory.getLogger(TaskGenerateBootstrap.class).error("Failed to instantiate TypeScriptBootstrapModifier", (Throwable)e);
            }
        }
    }

    @Override
    protected String getFileContent() {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(String.format("import '%s';%n", this.getIndexTsEntryPath()));
        if (this.options.isReactEnabled()) {
            lines.add("import './vaadin-react.js';");
        }
        if (!this.options.isProductionMode()) {
            lines.add(DEV_TOOLS_IMPORT);
        }
        lines.addAll(this.getThemeLines());
        for (TypeScriptBootstrapModifier modifier : this.modifiers) {
            modifier.modify(lines, this.options, this.frontDeps);
        }
        lines.add(0, String.format("import './%s';%n", "vaadin-featureflags.js"));
        return String.join((CharSequence)System.lineSeparator(), lines);
    }

    @Override
    protected File getGeneratedFile() {
        File frontendGeneratedDirectory = new File(this.options.getFrontendDirectory(), "generated/");
        return new File(frontendGeneratedDirectory, "vaadin.ts");
    }

    @Override
    protected boolean shouldGenerate() {
        return this.frontDeps != null;
    }

    private String getIndexTsEntryPath() {
        boolean hasCustomIndexFile;
        File frontendDirectory = this.options.getFrontendDirectory();
        boolean bl = hasCustomIndexFile = new File(frontendDirectory, "index.ts").exists() || new File(frontendDirectory, "index.js").exists() || new File(frontendDirectory, "index.tsx").exists();
        if (hasCustomIndexFile) {
            return "../index";
        }
        return "./index";
    }

    private Collection<String> getThemeLines() {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("import './app-shell-imports.js';");
        ThemeDefinition themeDef = this.frontDeps.getThemeDefinition();
        if (themeDef != null && !"".equals(themeDef.getName())) {
            lines.add("import './theme-" + themeDef.getName() + ".global.generated.js';");
            lines.add("import { applyTheme } from './theme.js';");
            lines.add("applyTheme(document);");
            lines.add("");
        } else {
            lines.add("import './css.generated.js';");
            lines.add("import { applyCss } from './css.generated.js';");
            lines.add("applyCss(document);");
            lines.add("");
        }
        return lines;
    }
}

