/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.copilot.plugins.themeeditor.handlers;

import com.vaadin.copilot.ide.IdeUtils;
import com.vaadin.copilot.plugins.themeeditor.ThemeEditorCommand;
import com.vaadin.copilot.plugins.themeeditor.messages.BaseResponse;
import com.vaadin.copilot.plugins.themeeditor.messages.OpenCssRequest;
import com.vaadin.copilot.plugins.themeeditor.utils.HasThemeModifier;
import com.vaadin.copilot.plugins.themeeditor.utils.MessageHandler;
import com.vaadin.copilot.plugins.themeeditor.utils.ThemeEditorException;
import com.vaadin.flow.internal.JsonUtils;
import elemental.json.JsonObject;
import java.io.File;

public class OpenCssHandler
implements MessageHandler {
    private final HasThemeModifier hasThemeModifier;

    public OpenCssHandler(HasThemeModifier hasThemeModifier) {
        this.hasThemeModifier = hasThemeModifier;
    }

    @Override
    public BaseResponse handle(JsonObject data) {
        OpenCssRequest request = (OpenCssRequest)JsonUtils.readToObject((JsonObject)data, OpenCssRequest.class);
        String selector = request.getSelector();
        int line = this.hasThemeModifier.getThemeModifier().getRuleLocationLine(selector);
        if (line == -1) {
            this.hasThemeModifier.getThemeModifier().createEmptyStyleRule(selector);
            long now = System.currentTimeMillis();
            while ((line = this.hasThemeModifier.getThemeModifier().getRuleLocationLine(selector)) == -1 && System.currentTimeMillis() - now < 100L) {
            }
            if (line == -1) {
                throw new ThemeEditorException("Cannot create empty rule for " + selector);
            }
        }
        File stylesheet = this.hasThemeModifier.getThemeModifier().getStyleSheetFile();
        IdeUtils.openFile(stylesheet, line);
        return BaseResponse.ok();
    }

    @Override
    public String getCommandName() {
        return ThemeEditorCommand.OPEN_CSS.getValue();
    }
}

