/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tasks;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPURL;
import com.unboundid.ldap.sdk.unboundidds.tasks.FailedDependencyAction;
import com.unboundid.ldap.sdk.unboundidds.tasks.Task;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskException;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskMessages;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskProperty;
import com.unboundid.ldap.sdk.unboundidds.tasks.TaskState;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.DurationArgument;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class DelayTask
extends Task {
    static final String DELAY_TASK_CLASS = "com.unboundid.directory.server.tasks.DelayTask";
    private static final String ATTR_SLEEP_DURATION = "ds-task-delay-sleep-duration";
    private static final String ATTR_WAIT_FOR_WORK_QUEUE_IDLE = "ds-task-delay-duration-to-wait-for-work-queue-idle";
    private static final String ATTR_SEARCH_URL = "ds-task-delay-ldap-url-for-search-expected-to-return-entries";
    private static final String ATTR_SEARCH_INTERVAL = "ds-task-delay-search-interval";
    private static final String ATTR_SEARCH_TIME_LIMIT = "ds-task-delay-search-time-limit";
    private static final String ATTR_SEARCH_DURATION = "ds-task-delay-duration-to-wait-for-search-to-return-entries";
    private static final String ATTR_TIMEOUT_RETURN_STATE = "ds-task-delay-task-return-state-if-timeout-is-encountered";
    private static final String OC_DELAY_TASK = "ds-task-delay";
    private static final TaskProperty PROPERTY_SLEEP_DURATION_MILLIS = new TaskProperty("ds-task-delay-sleep-duration", TaskMessages.INFO_DELAY_DISPLAY_NAME_SLEEP_DURATION.get(), TaskMessages.INFO_DELAY_DESCRIPTION_SLEEP_DURATION.get(), Long.class, false, false, false);
    private static final TaskProperty PROPERTY_WAIT_FOR_WORK_QUEUE_IDLE_MILLIS = new TaskProperty("ds-task-delay-duration-to-wait-for-work-queue-idle", TaskMessages.INFO_DELAY_DISPLAY_NAME_WAIT_FOR_WORK_QUEUE_IDLE.get(), TaskMessages.INFO_DELAY_DESCRIPTION_WAIT_FOR_WORK_QUEUE_IDLE.get(), Long.class, false, false, false);
    private static final TaskProperty PROPERTY_SEARCH_URL = new TaskProperty("ds-task-delay-ldap-url-for-search-expected-to-return-entries", TaskMessages.INFO_DELAY_DISPLAY_NAME_SEARCH_URL.get(), TaskMessages.INFO_DELAY_DESCRIPTION_SEARCH_URL.get(), String.class, false, true, false);
    private static final TaskProperty PROPERTY_SEARCH_INTERVAL_MILLIS = new TaskProperty("ds-task-delay-search-interval", TaskMessages.INFO_DELAY_DISPLAY_NAME_SEARCH_INTERVAL.get(), TaskMessages.INFO_DELAY_DESCRIPTION_SEARCH_INTERVAL.get(), Long.class, false, false, false);
    private static final TaskProperty PROPERTY_SEARCH_TIME_LIMIT_MILLIS = new TaskProperty("ds-task-delay-search-time-limit", TaskMessages.INFO_DELAY_DISPLAY_NAME_SEARCH_TIME_LIMIT.get(), TaskMessages.INFO_DELAY_DESCRIPTION_SEARCH_TIME_LIMIT.get(), Long.class, false, false, false);
    private static final TaskProperty PROPERTY_SEARCH_DURATION_MILLIS = new TaskProperty("ds-task-delay-duration-to-wait-for-search-to-return-entries", TaskMessages.INFO_DELAY_DISPLAY_NAME_SEARCH_DURATION.get(), TaskMessages.INFO_DELAY_DESCRIPTION_SEARCH_DURATION.get(), Long.class, false, false, false);
    private static final TaskProperty PROPERTY_TIMEOUT_RETURN_STATE = new TaskProperty("ds-task-delay-task-return-state-if-timeout-is-encountered", TaskMessages.INFO_DELAY_DISPLAY_NAME_TIMEOUT_RETURN_STATE.get(), TaskMessages.INFO_DELAY_DESCRIPTION_TIMEOUT_RETURN_STATE.get(), String.class, false, false, false, new String[]{"STOPPED_BY_ERROR", "STOPPED-BY-ERROR", "COMPLETED_WITH_ERRORS", "COMPLETED-WITH-ERRORS", "COMPLETED_SUCCESSFULLY", "COMPLETED-SUCCESSFULLY"});
    private static final long serialVersionUID = -639870096358259180L;
    private final List<LDAPURL> ldapURLsForSearchesExpectedToReturnEntries;
    private final Long millisBetweenSearches;
    private final Long millisToWaitForWorkQueueToBecomeIdle;
    private final Long searchTimeLimitMillis;
    private final Long sleepDurationMillis;
    private final Long totalDurationMillisForEachLDAPURL;
    private final String taskStateIfTimeoutIsEncountered;

    public DelayTask() {
        this.ldapURLsForSearchesExpectedToReturnEntries = null;
        this.millisBetweenSearches = null;
        this.millisToWaitForWorkQueueToBecomeIdle = null;
        this.searchTimeLimitMillis = null;
        this.sleepDurationMillis = null;
        this.totalDurationMillisForEachLDAPURL = null;
        this.taskStateIfTimeoutIsEncountered = null;
    }

    public DelayTask(Long sleepDurationMillis, Long millisToWaitForWorkQueueToBecomeIdle, Collection<LDAPURL> ldapURLsForSearchesExpectedToReturnEntries, Long millisBetweenSearches, Long searchTimeLimitMillis, Long totalDurationMillisForEachLDAPURL, TaskState taskStateIfTimeoutIsEncountered) throws TaskException {
        this(null, sleepDurationMillis, millisToWaitForWorkQueueToBecomeIdle, ldapURLsForSearchesExpectedToReturnEntries, millisBetweenSearches, searchTimeLimitMillis, totalDurationMillisForEachLDAPURL, taskStateIfTimeoutIsEncountered, null, null, null, null, null, null, null, null, null, null);
    }

    public DelayTask(String taskID, Long sleepDurationMillis, Long millisToWaitForWorkQueueToBecomeIdle, Collection<LDAPURL> ldapURLsForSearchesExpectedToReturnEntries, Long millisBetweenSearches, Long searchTimeLimitMillis, Long totalDurationMillisForEachLDAPURL, TaskState taskStateIfTimeoutIsEncountered, Date scheduledStartTime, List<String> dependencyIDs, FailedDependencyAction failedDependencyAction, List<String> notifyOnStart, List<String> notifyOnCompletion, List<String> notifyOnSuccess, List<String> notifyOnError, Boolean alertOnStart, Boolean alertOnSuccess, Boolean alertOnError) throws TaskException {
        super(taskID, DELAY_TASK_CLASS, scheduledStartTime, dependencyIDs, failedDependencyAction, notifyOnStart, notifyOnCompletion, notifyOnSuccess, notifyOnError, alertOnStart, alertOnSuccess, alertOnError);
        this.sleepDurationMillis = sleepDurationMillis;
        this.millisToWaitForWorkQueueToBecomeIdle = millisToWaitForWorkQueueToBecomeIdle;
        this.millisBetweenSearches = millisBetweenSearches;
        this.searchTimeLimitMillis = searchTimeLimitMillis;
        this.totalDurationMillisForEachLDAPURL = totalDurationMillisForEachLDAPURL;
        this.ldapURLsForSearchesExpectedToReturnEntries = ldapURLsForSearchesExpectedToReturnEntries == null ? Collections.emptyList() : Collections.unmodifiableList(new ArrayList<LDAPURL>(ldapURLsForSearchesExpectedToReturnEntries));
        if (taskStateIfTimeoutIsEncountered == null) {
            this.taskStateIfTimeoutIsEncountered = null;
        } else {
            switch (taskStateIfTimeoutIsEncountered) {
                case STOPPED_BY_ERROR: 
                case COMPLETED_WITH_ERRORS: 
                case COMPLETED_SUCCESSFULLY: {
                    this.taskStateIfTimeoutIsEncountered = taskStateIfTimeoutIsEncountered.name();
                    break;
                }
                default: {
                    throw new TaskException(TaskMessages.ERR_DELAY_INVALID_TIMEOUT_STATE.get(TaskState.STOPPED_BY_ERROR.name(), TaskState.COMPLETED_WITH_ERRORS.name(), TaskState.COMPLETED_SUCCESSFULLY.name()));
                }
            }
        }
        if (sleepDurationMillis != null && sleepDurationMillis <= 0L) {
            throw new TaskException(TaskMessages.ERR_DELAY_INVALID_SLEEP_DURATION.get());
        }
        if (millisToWaitForWorkQueueToBecomeIdle != null && millisToWaitForWorkQueueToBecomeIdle <= 0L) {
            throw new TaskException(TaskMessages.ERR_DELAY_INVALID_WAIT_FOR_QUEUE_IDLE.get());
        }
        if (millisBetweenSearches != null && millisBetweenSearches <= 0L) {
            throw new TaskException(TaskMessages.ERR_DELAY_INVALID_SEARCH_INTERVAL.get());
        }
        if (searchTimeLimitMillis != null && searchTimeLimitMillis <= 0L) {
            throw new TaskException(TaskMessages.ERR_DELAY_INVALID_SEARCH_TIME_LIMIT.get());
        }
        if (totalDurationMillisForEachLDAPURL != null && totalDurationMillisForEachLDAPURL <= 0L) {
            throw new TaskException(TaskMessages.ERR_DELAY_INVALID_SEARCH_DURATION.get());
        }
        if (!this.ldapURLsForSearchesExpectedToReturnEntries.isEmpty()) {
            if (millisBetweenSearches == null || searchTimeLimitMillis == null || totalDurationMillisForEachLDAPURL == null) {
                throw new TaskException(TaskMessages.ERR_DELAY_URL_WITHOUT_REQUIRED_PARAM.get());
            }
            if (millisBetweenSearches >= totalDurationMillisForEachLDAPURL) {
                throw new TaskException(TaskMessages.ERR_DELAY_INVALID_SEARCH_INTERVAL.get());
            }
            if (searchTimeLimitMillis >= totalDurationMillisForEachLDAPURL) {
                throw new TaskException(TaskMessages.ERR_DELAY_INVALID_SEARCH_TIME_LIMIT.get());
            }
        }
    }

    public DelayTask(Entry entry) throws TaskException {
        super(entry);
        this.taskStateIfTimeoutIsEncountered = entry.getAttributeValue(ATTR_TIMEOUT_RETURN_STATE);
        this.sleepDurationMillis = DelayTask.parseDuration(entry, ATTR_SLEEP_DURATION);
        this.millisToWaitForWorkQueueToBecomeIdle = DelayTask.parseDuration(entry, ATTR_WAIT_FOR_WORK_QUEUE_IDLE);
        this.millisBetweenSearches = DelayTask.parseDuration(entry, ATTR_SEARCH_INTERVAL);
        this.searchTimeLimitMillis = DelayTask.parseDuration(entry, ATTR_SEARCH_TIME_LIMIT);
        this.totalDurationMillisForEachLDAPURL = DelayTask.parseDuration(entry, ATTR_SEARCH_DURATION);
        String[] urlStrings = entry.getAttributeValues(ATTR_SEARCH_URL);
        if (urlStrings == null) {
            this.ldapURLsForSearchesExpectedToReturnEntries = Collections.emptyList();
        } else {
            ArrayList<LDAPURL> urls = new ArrayList<LDAPURL>(urlStrings.length);
            for (String s : urlStrings) {
                try {
                    urls.add(new LDAPURL(s));
                }
                catch (LDAPException e) {
                    Debug.debugException(e);
                    throw new TaskException(TaskMessages.ERR_DELAY_ENTRY_MALFORMED_URL.get(ATTR_SEARCH_URL, s, e.getMessage()), e);
                }
            }
            this.ldapURLsForSearchesExpectedToReturnEntries = Collections.unmodifiableList(urls);
        }
    }

    private static Long parseDuration(Entry entry, String attributeName) throws TaskException {
        String value = entry.getAttributeValue(attributeName);
        if (value == null) {
            return null;
        }
        try {
            return DurationArgument.parseDuration(value, TimeUnit.MILLISECONDS);
        }
        catch (ArgumentException e) {
            throw new TaskException(TaskMessages.ERR_DELAY_CANNOT_PARSE_ATTR_VALUE_AS_DURATION.get(attributeName, e.getMessage()), e);
        }
    }

    public DelayTask(Map<TaskProperty, List<Object>> properties) throws TaskException {
        super(DELAY_TASK_CLASS, properties);
        Long searchDuration = null;
        Long searchInterval = null;
        Long searchTimeLimit = null;
        Long sleepDuration = null;
        Long workQueueWaitTime = null;
        String timeoutReturnState = null;
        ArrayList<LDAPURL> urls = new ArrayList<LDAPURL>(10);
        block20: for (Map.Entry<TaskProperty, List<Object>> entry : properties.entrySet()) {
            TaskProperty p = entry.getKey();
            String attrName = StaticUtils.toLowerCase(p.getAttributeName());
            List<Object> values = entry.getValue();
            switch (attrName) {
                case "ds-task-delay-sleep-duration": {
                    sleepDuration = DelayTask.parseLong(p, values, null);
                    break;
                }
                case "ds-task-delay-duration-to-wait-for-work-queue-idle": {
                    workQueueWaitTime = DelayTask.parseLong(p, values, null);
                    break;
                }
                case "ds-task-delay-ldap-url-for-search-expected-to-return-entries": {
                    for (String urlString : DelayTask.parseStrings(p, values, StaticUtils.NO_STRINGS)) {
                        try {
                            urls.add(new LDAPURL(urlString));
                        }
                        catch (LDAPException e) {
                            Debug.debugException(e);
                            throw new TaskException(TaskMessages.ERR_DELAY_ENTRY_MALFORMED_URL.get(ATTR_SEARCH_URL, urlString, e.getMessage()), e);
                        }
                    }
                    continue block20;
                }
                case "ds-task-delay-search-interval": {
                    searchInterval = DelayTask.parseLong(p, values, null);
                    break;
                }
                case "ds-task-delay-search-time-limit": {
                    searchTimeLimit = DelayTask.parseLong(p, values, null);
                    break;
                }
                case "ds-task-delay-duration-to-wait-for-search-to-return-entries": {
                    searchDuration = DelayTask.parseLong(p, values, null);
                    break;
                }
                case "ds-task-delay-task-return-state-if-timeout-is-encountered": {
                    timeoutReturnState = DelayTask.parseString(p, values, null);
                }
            }
        }
        this.sleepDurationMillis = sleepDuration;
        this.millisToWaitForWorkQueueToBecomeIdle = workQueueWaitTime;
        this.ldapURLsForSearchesExpectedToReturnEntries = Collections.unmodifiableList(urls);
        this.millisBetweenSearches = searchInterval;
        this.searchTimeLimitMillis = searchTimeLimit;
        this.totalDurationMillisForEachLDAPURL = searchDuration;
        this.taskStateIfTimeoutIsEncountered = timeoutReturnState;
    }

    @Override
    public String getTaskName() {
        return TaskMessages.INFO_TASK_NAME_DELAY.get();
    }

    @Override
    public String getTaskDescription() {
        return TaskMessages.INFO_TASK_DESCRIPTION_DELAY.get();
    }

    public Long getSleepDurationMillis() {
        return this.sleepDurationMillis;
    }

    public Long getMillisToWaitForWorkQueueToBecomeIdle() {
        return this.millisToWaitForWorkQueueToBecomeIdle;
    }

    public List<LDAPURL> getLDAPURLsForSearchesExpectedToReturnEntries() {
        return this.ldapURLsForSearchesExpectedToReturnEntries;
    }

    public Long getMillisBetweenSearches() {
        return this.millisBetweenSearches;
    }

    public Long getSearchTimeLimitMillis() {
        return this.searchTimeLimitMillis;
    }

    public Long getTotalDurationMillisForEachLDAPURL() {
        return this.totalDurationMillisForEachLDAPURL;
    }

    public String getTaskStateIfTimeoutIsEncountered() {
        return this.taskStateIfTimeoutIsEncountered;
    }

    @Override
    protected List<String> getAdditionalObjectClasses() {
        return Collections.singletonList(OC_DELAY_TASK);
    }

    @Override
    protected List<Attribute> getAdditionalAttributes() {
        LinkedList<Attribute> attrList = new LinkedList<Attribute>();
        if (this.sleepDurationMillis != null) {
            long sleepDurationNanos = this.sleepDurationMillis * 1000000L;
            attrList.add(new Attribute(ATTR_SLEEP_DURATION, DurationArgument.nanosToDuration(sleepDurationNanos)));
        }
        if (this.millisToWaitForWorkQueueToBecomeIdle != null) {
            long waitTimeNanos = this.millisToWaitForWorkQueueToBecomeIdle * 1000000L;
            attrList.add(new Attribute(ATTR_WAIT_FOR_WORK_QUEUE_IDLE, DurationArgument.nanosToDuration(waitTimeNanos)));
        }
        if (!this.ldapURLsForSearchesExpectedToReturnEntries.isEmpty()) {
            ArrayList<String> urlStrings = new ArrayList<String>(this.ldapURLsForSearchesExpectedToReturnEntries.size());
            for (LDAPURL url : this.ldapURLsForSearchesExpectedToReturnEntries) {
                urlStrings.add(url.toString());
            }
            attrList.add(new Attribute(ATTR_SEARCH_URL, urlStrings));
        }
        if (this.millisBetweenSearches != null) {
            long intervalNanos = this.millisBetweenSearches * 1000000L;
            attrList.add(new Attribute(ATTR_SEARCH_INTERVAL, DurationArgument.nanosToDuration(intervalNanos)));
        }
        if (this.searchTimeLimitMillis != null) {
            long timeLimitNanos = this.searchTimeLimitMillis * 1000000L;
            attrList.add(new Attribute(ATTR_SEARCH_TIME_LIMIT, DurationArgument.nanosToDuration(timeLimitNanos)));
        }
        if (this.totalDurationMillisForEachLDAPURL != null) {
            long durationNanos = this.totalDurationMillisForEachLDAPURL * 1000000L;
            attrList.add(new Attribute(ATTR_SEARCH_DURATION, DurationArgument.nanosToDuration(durationNanos)));
        }
        if (this.taskStateIfTimeoutIsEncountered != null) {
            attrList.add(new Attribute(ATTR_TIMEOUT_RETURN_STATE, this.taskStateIfTimeoutIsEncountered));
        }
        return attrList;
    }

    @Override
    public List<TaskProperty> getTaskSpecificProperties() {
        return Collections.unmodifiableList(Arrays.asList(PROPERTY_SLEEP_DURATION_MILLIS, PROPERTY_WAIT_FOR_WORK_QUEUE_IDLE_MILLIS, PROPERTY_SEARCH_URL, PROPERTY_SEARCH_INTERVAL_MILLIS, PROPERTY_SEARCH_TIME_LIMIT_MILLIS, PROPERTY_SEARCH_DURATION_MILLIS, PROPERTY_TIMEOUT_RETURN_STATE));
    }

    @Override
    public Map<TaskProperty, List<Object>> getTaskPropertyValues() {
        LinkedHashMap props = new LinkedHashMap(StaticUtils.computeMapCapacity(7));
        if (this.sleepDurationMillis != null) {
            props.put(PROPERTY_SLEEP_DURATION_MILLIS, Collections.singletonList(this.sleepDurationMillis));
        }
        if (this.millisToWaitForWorkQueueToBecomeIdle != null) {
            props.put(PROPERTY_WAIT_FOR_WORK_QUEUE_IDLE_MILLIS, Collections.singletonList(this.millisToWaitForWorkQueueToBecomeIdle));
        }
        if (!this.ldapURLsForSearchesExpectedToReturnEntries.isEmpty()) {
            ArrayList<String> urlStrings = new ArrayList<String>(this.ldapURLsForSearchesExpectedToReturnEntries.size());
            for (LDAPURL url : this.ldapURLsForSearchesExpectedToReturnEntries) {
                urlStrings.add(url.toString());
            }
            props.put(PROPERTY_SEARCH_URL, Collections.unmodifiableList(urlStrings));
        }
        if (this.millisBetweenSearches != null) {
            props.put(PROPERTY_SEARCH_INTERVAL_MILLIS, Collections.singletonList(this.millisBetweenSearches));
        }
        if (this.searchTimeLimitMillis != null) {
            props.put(PROPERTY_SEARCH_TIME_LIMIT_MILLIS, Collections.singletonList(this.searchTimeLimitMillis));
        }
        if (this.totalDurationMillisForEachLDAPURL != null) {
            props.put(PROPERTY_SEARCH_DURATION_MILLIS, Collections.singletonList(this.totalDurationMillisForEachLDAPURL));
        }
        if (this.taskStateIfTimeoutIsEncountered != null) {
            props.put(PROPERTY_TIMEOUT_RETURN_STATE, Collections.singletonList(this.taskStateIfTimeoutIsEncountered));
        }
        return Collections.unmodifiableMap(props);
    }
}

