/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.extensions;

import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.io.Serializable;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class SupportedOTPDeliveryMechanismInfo
implements Serializable {
    private static final long serialVersionUID = -6315998976212985213L;
    private final Boolean isSupported;
    private final String deliveryMechanism;
    private final String recipientID;

    public SupportedOTPDeliveryMechanismInfo(String deliveryMechanism, Boolean isSupported, String recipientID) {
        Validator.ensureNotNull(deliveryMechanism);
        this.deliveryMechanism = deliveryMechanism;
        this.isSupported = isSupported;
        this.recipientID = recipientID;
    }

    public String getDeliveryMechanism() {
        return this.deliveryMechanism;
    }

    public Boolean isSupported() {
        return this.isSupported;
    }

    public String getRecipientID() {
        return this.recipientID;
    }

    public int hashCode() {
        int hc = this.deliveryMechanism.hashCode();
        if (this.isSupported == null) {
            hc += 2;
        } else if (this.isSupported.booleanValue()) {
            ++hc;
        }
        if (this.recipientID != null) {
            hc += this.recipientID.hashCode();
        }
        return hc;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SupportedOTPDeliveryMechanismInfo)) {
            return false;
        }
        SupportedOTPDeliveryMechanismInfo i = (SupportedOTPDeliveryMechanismInfo)o;
        if (!this.deliveryMechanism.equals(i.deliveryMechanism)) {
            return false;
        }
        if (this.isSupported == null ? i.isSupported != null : !this.isSupported.equals(i.isSupported)) {
            return false;
        }
        if (this.recipientID == null) {
            return i.recipientID == null;
        }
        return this.recipientID.equals(i.recipientID);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("SupportedOTPDeliveryMechanismInfo(mechanism='");
        buffer.append(this.deliveryMechanism);
        buffer.append('\'');
        if (this.isSupported != null) {
            buffer.append(", isSupported=");
            buffer.append(this.isSupported);
        }
        if (this.recipientID != null) {
            buffer.append(", recipientID='");
            buffer.append(this.recipientID);
            buffer.append('\'');
        }
        buffer.append(')');
    }
}

