/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.BindRequest;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPConnectionPoolHealthCheck;
import com.unboundid.ldap.sdk.PostConnectProcessor;
import com.unboundid.ldap.sdk.ServerSet;
import com.unboundid.ldap.sdk.ServerSetBlacklistManagerTimerTask;
import com.unboundid.util.Debug;
import com.unboundid.util.Mutable;
import com.unboundid.util.ObjectPair;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.SocketFactory;

@Mutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
final class ServerSetBlacklistManager {
    private final AtomicReference<Timer> timerReference;
    private final BindRequest bindRequest;
    private final LDAPConnectionOptions connectionOptions;
    private final long checkIntervalMillis;
    private final Map<ObjectPair<String, Integer>, LDAPConnectionPoolHealthCheck> blacklistedServers;
    private final PostConnectProcessor postConnectProcessor;
    private final SocketFactory socketFactory;
    private final String serverSetString;

    ServerSetBlacklistManager(ServerSet serverSet, SocketFactory socketFactory, LDAPConnectionOptions connectionOptions, BindRequest bindRequest, PostConnectProcessor postConnectProcessor, long checkIntervalMillis) {
        Validator.ensureTrue(checkIntervalMillis > 0L, "ServerSetBlacklistManager.checkIntervalMillis must be greater than zero.");
        this.checkIntervalMillis = checkIntervalMillis;
        this.serverSetString = serverSet.toString();
        this.socketFactory = socketFactory == null ? SocketFactory.getDefault() : socketFactory;
        this.connectionOptions = connectionOptions == null ? new LDAPConnectionOptions() : connectionOptions;
        this.bindRequest = bindRequest;
        this.postConnectProcessor = postConnectProcessor;
        this.blacklistedServers = new ConcurrentHashMap<ObjectPair<String, Integer>, LDAPConnectionPoolHealthCheck>(StaticUtils.computeMapCapacity(10));
        this.timerReference = new AtomicReference();
    }

    boolean isEmpty() {
        if (this.blacklistedServers.isEmpty()) {
            return true;
        }
        this.ensureTimerIsRunning();
        return false;
    }

    int size() {
        if (this.blacklistedServers.isEmpty()) {
            return 0;
        }
        this.ensureTimerIsRunning();
        return this.blacklistedServers.size();
    }

    Set<ObjectPair<String, Integer>> getBlacklistedServers() {
        if (!this.blacklistedServers.isEmpty()) {
            this.ensureTimerIsRunning();
        }
        return new HashSet<ObjectPair<String, Integer>>(this.blacklistedServers.keySet());
    }

    boolean isBlacklisted(String host, int port) {
        if (this.blacklistedServers.isEmpty()) {
            return false;
        }
        this.ensureTimerIsRunning();
        return this.blacklistedServers.containsKey(new ObjectPair<String, Integer>(host, port));
    }

    boolean isBlacklisted(ObjectPair<String, Integer> hostPort) {
        if (this.blacklistedServers.isEmpty()) {
            return false;
        }
        this.ensureTimerIsRunning();
        return this.blacklistedServers.containsKey(hostPort);
    }

    void addToBlacklist(String host, int port, LDAPConnectionPoolHealthCheck healthCheck) {
        this.addToBlacklist(new ObjectPair<String, Integer>(host, port), healthCheck);
    }

    void addToBlacklist(ObjectPair<String, Integer> hostPort, LDAPConnectionPoolHealthCheck healthCheck) {
        if (healthCheck == null) {
            this.blacklistedServers.put(hostPort, new LDAPConnectionPoolHealthCheck());
        } else {
            this.blacklistedServers.put(hostPort, healthCheck);
        }
        this.ensureTimerIsRunning();
    }

    void removeFromBlacklist(String host, int port) {
        this.removeFromBlacklist(new ObjectPair<String, Integer>(host, port));
    }

    void removeFromBlacklist(ObjectPair<String, Integer> hostPort) {
        this.blacklistedServers.remove(hostPort);
        if (!this.blacklistedServers.isEmpty()) {
            this.ensureTimerIsRunning();
        }
    }

    void clear() {
        this.blacklistedServers.clear();
    }

    private synchronized void ensureTimerIsRunning() {
        Timer timer = this.timerReference.get();
        if (timer == null) {
            timer = new Timer("ServerSet Blacklist Manager Timer for " + this.serverSetString, true);
            this.timerReference.set(timer);
            timer.scheduleAtFixedRate((TimerTask)new ServerSetBlacklistManagerTimerTask(this), this.checkIntervalMillis, this.checkIntervalMillis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkBlacklistedServers() {
        Iterator<Map.Entry<ObjectPair<String, Integer>, LDAPConnectionPoolHealthCheck>> iterator = this.blacklistedServers.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<ObjectPair<String, Integer>, LDAPConnectionPoolHealthCheck> e = iterator.next();
            ObjectPair<String, Integer> hostPort = e.getKey();
            LDAPConnectionPoolHealthCheck healthCheck = e.getValue();
            try {
                LDAPConnection conn = new LDAPConnection(this.socketFactory, this.connectionOptions, hostPort.getFirst(), hostPort.getSecond());
                Throwable throwable = null;
                try {
                    ServerSet.doBindPostConnectAndHealthCheckProcessing(conn, this.bindRequest, this.postConnectProcessor, healthCheck);
                    iterator.remove();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (conn == null) continue;
                    if (throwable != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    conn.close();
                }
            }
            catch (Exception ex) {
                Debug.debugException(ex);
            }
        }
        if (this.blacklistedServers.isEmpty()) {
            ServerSetBlacklistManager serverSetBlacklistManager = this;
            synchronized (serverSetBlacklistManager) {
                if (this.blacklistedServers.isEmpty()) {
                    Timer timer = this.timerReference.getAndSet(null);
                    if (timer != null) {
                        timer.cancel();
                        timer.purge();
                    }
                    return;
                }
            }
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    void toString(StringBuilder buffer) {
        buffer.append("ServerSetBlacklistManager(serverSet='");
        buffer.append(this.serverSetString);
        buffer.append("', blacklistedServers={");
        Iterator<ObjectPair<String, Integer>> iterator = this.blacklistedServers.keySet().iterator();
        while (iterator.hasNext()) {
            ObjectPair<String, Integer> hostPort = iterator.next();
            buffer.append('\'');
            buffer.append(hostPort.getFirst());
            buffer.append(':');
            buffer.append(hostPort.getSecond());
            buffer.append('\'');
            if (!iterator.hasNext()) continue;
            buffer.append(',');
        }
        buffer.append("}, checkIntervalMillis=");
        buffer.append(this.checkIntervalMillis);
        buffer.append(')');
    }
}

