/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.matchingrules.MatchingRule;
import com.unboundid.ldap.sdk.RDN;
import com.unboundid.ldap.sdk.schema.AttributeTypeDefinition;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.Serializable;
import java.util.Comparator;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class RDNNameValuePair
implements Comparable<RDNNameValuePair>,
Comparator<RDNNameValuePair>,
Serializable {
    private static final long serialVersionUID = -8780852504883527870L;
    private final ASN1OctetString attributeValue;
    private final Schema schema;
    private final String attributeName;
    private volatile String normalizedAttributeName;
    private volatile String normalizedString;
    private volatile String stringRepresentation;

    RDNNameValuePair(String attributeName, ASN1OctetString attributeValue, Schema schema) {
        this.attributeName = attributeName;
        this.attributeValue = attributeValue;
        this.schema = schema;
        this.normalizedAttributeName = null;
        this.normalizedString = null;
        this.stringRepresentation = null;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public String getNormalizedAttributeName() {
        if (this.normalizedAttributeName == null) {
            AttributeTypeDefinition attributeType;
            if (this.schema != null && (attributeType = this.schema.getAttributeType(this.attributeName)) != null) {
                this.normalizedAttributeName = StaticUtils.toLowerCase(attributeType.getNameOrOID());
            }
            if (this.normalizedAttributeName == null) {
                this.normalizedAttributeName = StaticUtils.toLowerCase(this.attributeName);
            }
        }
        return this.normalizedAttributeName;
    }

    public boolean hasAttributeName(String name) {
        if (this.attributeName.equalsIgnoreCase(name)) {
            return true;
        }
        if (this.schema != null) {
            AttributeTypeDefinition attributeType = this.schema.getAttributeType(this.attributeName);
            return attributeType != null && attributeType.hasNameOrOID(name);
        }
        return false;
    }

    public String getAttributeValue() {
        return this.attributeValue.stringValue();
    }

    public byte[] getAttributeValueBytes() {
        return this.attributeValue.getValue();
    }

    public ASN1OctetString getRawAttributeValue() {
        return this.attributeValue;
    }

    public boolean hasAttributeValue(String value) {
        try {
            MatchingRule matchingRule = MatchingRule.selectEqualityMatchingRule(this.attributeName, this.schema);
            return matchingRule.valuesMatch(new ASN1OctetString(value), this.attributeValue);
        }
        catch (Exception e) {
            Debug.debugException(e);
            return false;
        }
    }

    public boolean hasAttributeValue(byte[] value) {
        try {
            MatchingRule matchingRule = MatchingRule.selectEqualityMatchingRule(this.attributeName, this.schema);
            return matchingRule.valuesMatch(new ASN1OctetString(value), this.attributeValue);
        }
        catch (Exception e) {
            Debug.debugException(e);
            return false;
        }
    }

    @Override
    public int compareTo(RDNNameValuePair p) {
        String thatNormalizedName;
        String thisNormalizedName = this.getNormalizedAttributeName();
        int nameComparison = thisNormalizedName.compareTo(thatNormalizedName = p.getNormalizedAttributeName());
        if (nameComparison != 0) {
            return nameComparison;
        }
        try {
            MatchingRule matchingRule = MatchingRule.selectOrderingMatchingRule(this.attributeName, this.schema);
            return matchingRule.compareValues(this.attributeValue, p.attributeValue);
        }
        catch (Exception e) {
            Debug.debugException(e);
            String thisNormalizedString = this.toNormalizedString();
            String thatNormalizedString = p.toNormalizedString();
            return thisNormalizedString.compareTo(thatNormalizedString);
        }
    }

    @Override
    public int compare(RDNNameValuePair p1, RDNNameValuePair p2) {
        return p1.compareTo(p2);
    }

    public int hashCode() {
        return this.toNormalizedString().hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof RDNNameValuePair)) {
            return false;
        }
        RDNNameValuePair p = (RDNNameValuePair)o;
        return this.toNormalizedString().equals(p.toNormalizedString());
    }

    public String toString() {
        if (this.stringRepresentation == null) {
            StringBuilder buffer = new StringBuilder();
            this.toString(buffer, false);
            this.stringRepresentation = buffer.toString();
        }
        return this.stringRepresentation;
    }

    public String toMinimallyEncodedString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer, true);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer, boolean minimizeEncoding) {
        if (this.stringRepresentation != null && !minimizeEncoding) {
            buffer.append(this.stringRepresentation);
            return;
        }
        boolean bufferWasEmpty = buffer.length() == 0;
        buffer.append(this.attributeName);
        buffer.append('=');
        RDN.appendValue(buffer, this.attributeValue, minimizeEncoding);
        if (bufferWasEmpty && !minimizeEncoding) {
            this.stringRepresentation = buffer.toString();
        }
    }

    public String toNormalizedString() {
        if (this.normalizedString == null) {
            StringBuilder buffer = new StringBuilder();
            this.toNormalizedString(buffer);
            this.normalizedString = buffer.toString();
        }
        return this.normalizedString;
    }

    public void toNormalizedString(StringBuilder buffer) {
        buffer.append(this.getNormalizedAttributeName());
        buffer.append('=');
        RDN.appendNormalizedValue(buffer, this.attributeName, this.attributeValue, this.schema);
    }
}

