/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.oauth.client;

import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.representation.Form;
import com.sun.jersey.oauth.client.RequestWrapper;
import com.sun.jersey.oauth.client.UnauthorizedRequestException;
import com.sun.jersey.oauth.signature.OAuthParameters;
import com.sun.jersey.oauth.signature.OAuthRequest;
import com.sun.jersey.oauth.signature.OAuthSecrets;
import com.sun.jersey.oauth.signature.OAuthSignature;
import com.sun.jersey.oauth.signature.OAuthSignatureException;
import java.net.URI;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.ext.Providers;

public final class OAuthClientFilter
extends ClientFilter {
    private final Providers providers;
    private final OAuthParameters parameters;
    private final OAuthSecrets secrets;
    private final URI requestTokenUri;
    private final URI accessTokenUri;
    private final URI authorizationUri;
    private final AuthHandler handler;
    private State state;

    public OAuthClientFilter(Providers providers, OAuthParameters parameters, OAuthSecrets secrets) {
        this(providers, parameters, secrets, null, null, null, null);
    }

    public OAuthClientFilter(Providers providers, OAuthParameters parameters, OAuthSecrets secrets, String requestTokenUri, String accessTokenUri, String authorizationUri, AuthHandler handler) {
        if (providers == null || parameters == null || secrets == null) {
            throw new NullPointerException();
        }
        if (!(requestTokenUri == null && accessTokenUri == null && authorizationUri == null || requestTokenUri != null && accessTokenUri != null && authorizationUri != null)) {
            throw new NullPointerException();
        }
        this.providers = providers;
        this.parameters = parameters;
        this.secrets = secrets;
        AuthHandler authHandler = this.handler = handler == null ? new AuthHandler(){

            @Override
            public void authorized(String token, String tokenSecret) {
            }

            @Override
            public String authorize(URI authorizationUri) {
                return null;
            }
        } : handler;
        if (parameters.getSignatureMethod() == null) {
            parameters.signatureMethod("HMAC-SHA1");
        }
        if (parameters.getVersion() == null) {
            parameters.version();
        }
        if (requestTokenUri == null) {
            this.authorizationUri = null;
            this.accessTokenUri = null;
            this.requestTokenUri = null;
            this.state = State.UNMANAGED;
        } else {
            this.requestTokenUri = UriBuilder.fromUri((String)requestTokenUri).build(new Object[0]);
            this.accessTokenUri = UriBuilder.fromUri((String)accessTokenUri).build(new Object[0]);
            this.authorizationUri = UriBuilder.fromUri((String)authorizationUri).build(new Object[0]);
            this.state = State.MANAGED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientResponse handle(ClientRequest request) throws ClientHandlerException {
        ClientResponse response;
        if (!request.getHeaders().containsKey((Object)"Authorization")) {
            switch (this.state) {
                case MANAGED: {
                    if (this.parameters.getToken() != null) break;
                    this.state = State.UNMANAGED;
                    try {
                        ClientResponse cr = this.handle(ClientRequest.create().build(this.requestTokenUri, "POST"));
                        Form response2 = (Form)cr.getEntity(Form.class);
                        String token = response2.getFirst("oauth_token");
                        this.parameters.token(token);
                        this.secrets.tokenSecret(response2.getFirst("oauth_token_secret"));
                        this.state = State.REQUEST_TOKEN;
                        this.parameters.verifier(this.handler.authorize(this.getAuthorizationUri()));
                        ClientResponse clientResponse = this.handle(request);
                        return clientResponse;
                    }
                    finally {
                        if (this.state == State.UNMANAGED) {
                            this.parameters.setToken(null);
                            this.secrets.setTokenSecret(null);
                        }
                        this.state = State.MANAGED;
                    }
                }
                case REQUEST_TOKEN: {
                    if (this.parameters.getVerifier() == null) {
                        throw new UnauthorizedRequestException(this.parameters, this.getAuthorizationUri());
                    }
                    this.state = State.UNMANAGED;
                    try {
                        ClientResponse cr = this.handle(ClientRequest.create().build(this.accessTokenUri, "POST"));
                        Form response3 = (Form)cr.getEntity(Form.class);
                        String token = response3.getFirst("oauth_token");
                        String secret = response3.getFirst("oauth_token_secret");
                        if (token == null) {
                            throw new UnauthorizedRequestException(this.parameters, null);
                        }
                        this.parameters.token(token);
                        this.secrets.tokenSecret(secret);
                        this.handler.authorized(this.parameters.getToken(), this.secrets.getTokenSecret());
                        this.state = State.MANAGED;
                    }
                    catch (Throwable throwable) {
                        this.parameters.remove((Object)"oauth_verifier");
                        if (this.state == State.UNMANAGED) {
                            this.parameters.remove((Object)"oauth_token");
                            this.secrets.tokenSecret(null);
                            this.state = State.MANAGED;
                        }
                        throw throwable;
                    }
                    this.parameters.remove((Object)"oauth_verifier");
                    if (this.state != State.UNMANAGED) break;
                    this.parameters.remove((Object)"oauth_token");
                    this.secrets.tokenSecret(null);
                    this.state = State.MANAGED;
                    break;
                }
            }
            OAuthParameters p = (OAuthParameters)this.parameters.clone();
            if (p.getTimestamp() == null) {
                p.setTimestamp();
            }
            if (p.getNonce() == null) {
                p.setNonce();
            }
            try {
                OAuthSignature.sign((OAuthRequest)new RequestWrapper(request, this.providers), (OAuthParameters)p, (OAuthSecrets)this.secrets);
            }
            catch (OAuthSignatureException se) {
                throw new ClientHandlerException((Throwable)se);
            }
        }
        UniformInterfaceException uie = null;
        try {
            response = this.getNext().handle(request);
        }
        catch (UniformInterfaceException e) {
            response = e.getResponse();
            uie = e;
        }
        if (this.state == State.MANAGED && response.getClientResponseStatus() == ClientResponse.Status.UNAUTHORIZED) {
            request.getHeaders().remove((Object)"Authorization");
            this.parameters.remove((Object)"oauth_token");
            this.secrets.tokenSecret(null);
            uie = null;
            return this.handle(request);
        }
        if (uie != null) {
            throw uie;
        }
        return response;
    }

    private URI getAuthorizationUri() {
        return UriBuilder.fromUri((URI)this.authorizationUri).queryParam("oauth_token", new Object[]{this.parameters.getToken()}).build(new Object[0]);
    }

    public static interface AuthHandler {
        public String authorize(URI var1);

        public void authorized(String var1, String var2);
    }

    private static enum State {
        UNMANAGED,
        MANAGED,
        REQUEST_TOKEN;

    }
}

