/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.spatial.jts;

import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.NumberExpression;
import com.querydsl.spatial.SpatialOps;
import com.querydsl.spatial.jts.JTSGeometryExpression;
import com.querydsl.spatial.jts.JTSGeometryExpressions;
import com.querydsl.spatial.jts.JTSPointExpression;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import org.jetbrains.annotations.Nullable;

public abstract class JTSSurfaceExpression<T extends Geometry>
extends JTSGeometryExpression<T> {
    private static final long serialVersionUID = 3534197011234723698L;
    @Nullable
    private volatile transient JTSPointExpression<Point> centroid;
    @Nullable
    private volatile transient JTSPointExpression<Point> pointOnSurface;
    @Nullable
    private volatile transient NumberExpression<Double> area;

    public JTSSurfaceExpression(Expression<T> mixin) {
        super(mixin);
    }

    public NumberExpression<Double> area() {
        if (this.area == null) {
            this.area = Expressions.numberOperation(Double.class, (Operator)SpatialOps.AREA, (Expression[])new Expression[]{this.mixin});
        }
        return this.area;
    }

    public JTSPointExpression<Point> centroid() {
        if (this.centroid == null) {
            this.centroid = JTSGeometryExpressions.pointOperation(SpatialOps.CENTROID, this.mixin);
        }
        return this.centroid;
    }

    public JTSPointExpression<Point> pointOnSurface() {
        if (this.pointOnSurface == null) {
            this.pointOnSurface = JTSGeometryExpressions.pointOperation(SpatialOps.POINT_ON_SURFACE, this.mixin);
        }
        return this.pointOnSurface;
    }
}

