/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.spatial.jts;

import com.querydsl.core.types.ConstantImpl;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.NumberExpression;
import com.querydsl.spatial.SpatialOps;
import com.querydsl.spatial.jts.JTSGeometryExpressions;
import com.querydsl.spatial.jts.JTSLineStringExpression;
import com.querydsl.spatial.jts.JTSSurfaceExpression;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Polygon;
import org.jetbrains.annotations.Nullable;

public abstract class JTSPolygonExpression<T extends Polygon>
extends JTSSurfaceExpression<T> {
    private static final long serialVersionUID = 7544382956232485312L;
    @Nullable
    private volatile transient NumberExpression<Integer> numInteriorRing;
    @Nullable
    private volatile transient JTSLineStringExpression<LineString> exteriorRing;

    public JTSPolygonExpression(Expression<T> mixin) {
        super(mixin);
    }

    public JTSLineStringExpression<?> exteriorRing() {
        if (this.exteriorRing == null) {
            this.exteriorRing = JTSGeometryExpressions.lineStringOperation(SpatialOps.EXTERIOR_RING, this.mixin);
        }
        return this.exteriorRing;
    }

    public NumberExpression<Integer> numInteriorRing() {
        if (this.numInteriorRing == null) {
            this.numInteriorRing = Expressions.numberOperation(Integer.class, (Operator)SpatialOps.NUM_INTERIOR_RING, (Expression[])new Expression[]{this.mixin});
        }
        return this.numInteriorRing;
    }

    public JTSLineStringExpression<LineString> interiorRingN(int idx) {
        return JTSGeometryExpressions.lineStringOperation(SpatialOps.INTERIOR_RINGN, new Expression[]{this.mixin, ConstantImpl.create((int)idx)});
    }
}

