/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.doclets;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.RootDoc;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;

public final class TokenTypesDoclet {
    private static final String DEST_FILE_OPT = "-destfile";

    private TokenTypesDoclet() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean start(RootDoc root) throws FileNotFoundException {
        String fileName = TokenTypesDoclet.getDestFileName(root.options());
        FileOutputStream fos = new FileOutputStream(fileName);
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8);
        try (PrintWriter pw = new PrintWriter((Writer)osw, false);){
            FieldDoc[] fields;
            ClassDoc[] classes = root.classes();
            for (FieldDoc field : fields = classes[0].fields()) {
                if (!field.isStatic() || !field.isPublic() || !field.isFinal() || !"int".equals(field.type().qualifiedTypeName())) continue;
                if (field.firstSentenceTags().length != 1) {
                    String message = "Should be only one tag.";
                    throw new IllegalArgumentException("Should be only one tag.");
                }
                pw.println(field.name() + "=" + field.firstSentenceTags()[0].text());
            }
        }
        return true;
    }

    public static int optionLength(String option) {
        if (DEST_FILE_OPT.equals(option)) {
            return 2;
        }
        return 0;
    }

    public static boolean checkOptions(String[][] options, DocErrorReporter reporter) {
        boolean foundDestFileOption = false;
        for (String[] opt : options) {
            if (!DEST_FILE_OPT.equals(opt[0])) continue;
            if (foundDestFileOption) {
                reporter.printError("Only one -destfile option allowed.");
                return false;
            }
            foundDestFileOption = true;
        }
        if (!foundDestFileOption) {
            String message = "Usage: javadoc -destfile file -doclet TokenTypesDoclet ...";
            reporter.printError("Usage: javadoc -destfile file -doclet TokenTypesDoclet ...");
        }
        return foundDestFileOption;
    }

    private static String getDestFileName(String[] ... options) {
        String fileName = null;
        for (String[] opt : options) {
            if (!DEST_FILE_OPT.equals(opt[0])) continue;
            fileName = opt[1];
        }
        return fileName;
    }
}

