/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.naming;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.naming.AbstractNameCheck;
import com.puppycrawl.tools.checkstyle.utils.ScopeUtils;
import org.apache.commons.lang3.ArrayUtils;

public class LocalFinalVariableNameCheck
extends AbstractNameCheck {
    public LocalFinalVariableNameCheck() {
        super("^[a-z][a-zA-Z0-9]*$");
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{10, 21};
    }

    @Override
    public int[] getRequiredTokens() {
        return ArrayUtils.EMPTY_INT_ARRAY;
    }

    @Override
    protected final boolean mustCheckName(DetailAST ast) {
        DetailAST modifiersAST = ast.findFirstToken(5);
        boolean isFinal = modifiersAST.branchContains(39);
        return isFinal && ScopeUtils.isLocalVariableDef(ast);
    }
}

