/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.AbstractFormatCheck;
import com.puppycrawl.tools.checkstyle.utils.TokenUtils;
import org.apache.commons.lang3.ArrayUtils;

public class IllegalTokenTextCheck
extends AbstractFormatCheck {
    public static final String MSG_KEY = "illegal.token.text";
    private String message = "";

    public IllegalTokenTextCheck() {
        super("$^");
    }

    @Override
    public int[] getDefaultTokens() {
        return ArrayUtils.EMPTY_INT_ARRAY;
    }

    @Override
    public int[] getAcceptableTokens() {
        return TokenUtils.getAllTokenIds();
    }

    @Override
    public int[] getRequiredTokens() {
        return ArrayUtils.EMPTY_INT_ARRAY;
    }

    @Override
    public void visitToken(DetailAST ast) {
        String text = ast.getText();
        if (this.getRegexp().matcher(text).find()) {
            String customMessage = this.message;
            if (customMessage.isEmpty()) {
                customMessage = MSG_KEY;
            }
            this.log(ast.getLineNo(), ast.getColumnNo(), customMessage, this.getFormat());
        }
    }

    public void setMessage(String message) {
        this.message = message == null ? "" : message;
    }

    public void setIgnoreCase(boolean caseInsensitive) {
        if (caseInsensitive) {
            this.setCompileFlags(2);
        }
    }
}

