/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Multiset;
import com.puppycrawl.tools.checkstyle.api.AbstractFileSetCheck;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UniquePropertiesCheck
extends AbstractFileSetCheck {
    public static final String MSG_KEY = "properties.duplicate.property";
    public static final String IO_EXCEPTION_KEY = "unable.open.cause";
    private static final Pattern SPACE_PATTERN = Pattern.compile(" ");

    public UniquePropertiesCheck() {
        this.setFileExtensions("properties");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processFiltered(File file, List<String> lines) {
        UniqueProperties properties = new UniqueProperties();
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            properties.load(fileInputStream);
        }
        catch (IOException e) {
            this.log(0, IO_EXCEPTION_KEY, file.getPath(), e.getLocalizedMessage());
        }
        for (Multiset.Entry duplication : properties.getDuplicatedKeys().entrySet()) {
            String keyName = (String)duplication.getElement();
            int lineNumber = UniquePropertiesCheck.getLineNumber(lines, keyName);
            this.log(lineNumber, MSG_KEY, keyName, duplication.getCount() + 1);
        }
    }

    protected static int getLineNumber(List<String> lines, String keyName) {
        String keyPatternString = "^" + SPACE_PATTERN.matcher(keyName).replaceAll(Matcher.quoteReplacement("\\\\ ")) + "[\\s:=].*$";
        Pattern keyPattern = Pattern.compile(keyPatternString);
        int lineNumber = 1;
        Matcher matcher = keyPattern.matcher("");
        for (String line : lines) {
            matcher.reset(line);
            if (matcher.matches()) break;
            ++lineNumber;
        }
        if (lineNumber > lines.size()) {
            lineNumber = 0;
        }
        return lineNumber;
    }

    private static class UniqueProperties
    extends Properties {
        private static final long serialVersionUID = 1L;
        private final Multiset<String> duplicatedKeys = HashMultiset.create();

        private UniqueProperties() {
        }

        @Override
        public Object put(Object key, Object value) {
            Object oldValue = super.put(key, value);
            if (oldValue != null && key instanceof String) {
                String keyString = (String)key;
                this.duplicatedKeys.add((Object)keyString);
            }
            return oldValue;
        }

        public Multiset<String> getDuplicatedKeys() {
            return ImmutableMultiset.copyOf(this.duplicatedKeys);
        }
    }
}

