/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import com.puppycrawl.tools.checkstyle.ModuleFactory;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.LocalizedMessage;
import java.lang.reflect.Constructor;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class PackageObjectFactory
implements ModuleFactory {
    private static final Log LOG = LogFactory.getLog(PackageObjectFactory.class);
    private static final String IGNORING_EXCEPTION_MESSAGE = "Keep looking, ignoring exception";
    private static final String UNABLE_TO_INSTANTIATE_EXCEPTION_MESSAGE = "PackageObjectFactory.unableToInstantiateExceptionMessage";
    private final Set<String> packages;
    private final ClassLoader moduleClassLoader;

    PackageObjectFactory(Set<String> packageNames, ClassLoader moduleClassLoader) {
        if (moduleClassLoader == null) {
            throw new IllegalArgumentException("moduleClassLoader must not be null");
        }
        this.packages = Sets.newLinkedHashSet(packageNames);
        this.moduleClassLoader = moduleClassLoader;
    }

    void addPackage(String packageName) {
        this.packages.add(packageName);
    }

    private Object doMakeObject(String name) throws CheckstyleException {
        try {
            return this.createObject(name);
        }
        catch (CheckstyleException ex) {
            LOG.debug((Object)IGNORING_EXCEPTION_MESSAGE, (Throwable)ex);
            for (String packageName : this.packages) {
                String className = packageName + name;
                try {
                    return this.createObject(className);
                }
                catch (CheckstyleException ex2) {
                    LOG.debug((Object)IGNORING_EXCEPTION_MESSAGE, (Throwable)ex2);
                }
            }
            LocalizedMessage exceptionMessage = new LocalizedMessage(0, "com.puppycrawl.tools.checkstyle.messages", UNABLE_TO_INSTANTIATE_EXCEPTION_MESSAGE, new String[]{name, this.joinPackageNamesWithClassName(name)}, null, this.getClass(), null);
            throw new CheckstyleException(exceptionMessage.getMessage());
        }
    }

    private Object createObject(String className) throws CheckstyleException {
        try {
            Class<?> clazz = Class.forName(className, true, this.moduleClassLoader);
            Constructor<?> declaredConstructor = clazz.getDeclaredConstructor(new Class[0]);
            declaredConstructor.setAccessible(true);
            return declaredConstructor.newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException exception) {
            throw new CheckstyleException("Unable to find class for " + className, exception);
        }
    }

    @Override
    public Object createModule(String name) throws CheckstyleException {
        try {
            return this.doMakeObject(name);
        }
        catch (CheckstyleException ignored) {
            try {
                return this.doMakeObject(name + "Check");
            }
            catch (CheckstyleException ex2) {
                LocalizedMessage exceptionMessage = new LocalizedMessage(0, "com.puppycrawl.tools.checkstyle.messages", UNABLE_TO_INSTANTIATE_EXCEPTION_MESSAGE, new String[]{name, this.joinPackageNamesWithClassName(name)}, null, this.getClass(), null);
                throw new CheckstyleException(exceptionMessage.getMessage(), ex2);
            }
        }
    }

    private String joinPackageNamesWithClassName(String className) {
        Joiner joiner = Joiner.on((String)(className + ", ")).skipNulls();
        return joiner.join(this.packages) + className;
    }
}

