/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.parser;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import oracle.jdbc.driver.parser.Cell;
import oracle.jdbc.driver.parser.LexerToken;
import oracle.jdbc.driver.parser.Matriceable;
import oracle.jdbc.driver.parser.Matrix;
import oracle.jdbc.driver.parser.ParseNode;
import oracle.jdbc.driver.parser.RuleTuple;
import oracle.jdbc.driver.parser.Tuple;
import oracle.jdbc.driver.parser.util.Array;

public abstract class Parser
implements Serializable {
    public String[] allSymbols = new String[0];
    public Map<String, Integer> symbolIndexes = new HashMap<String, Integer>();
    public Tuple[] rules;

    public Parser(Set<RuleTuple> originalRules) {
        this.extractSymbols(originalRules);
        this.extractRules(originalRules);
    }

    protected void extractSymbols(Set<RuleTuple> symbolicRules) {
        TreeSet<String> tmpSymbols = new TreeSet<String>();
        tmpSymbols.add("!nil");
        for (RuleTuple ct : symbolicRules) {
            if (ct.head == null || ct.rhs.length == 0 || ct.rhs[0] == null || ct.rhs.length > 1 && ct.rhs[1] == null) {
                throw new AssertionError((Object)"grammar has null symbols (or empty productions)");
            }
            tmpSymbols.add(ct.head);
            for (String s : ct.rhs) {
                tmpSymbols.add(s);
            }
        }
        int k = this.allSymbols.length;
        this.allSymbols = Arrays.copyOf(this.allSymbols, this.allSymbols.length + tmpSymbols.size());
        for (String s : tmpSymbols) {
            if (this.symbolIndexes.containsKey(s)) continue;
            this.symbolIndexes.put(s, k);
            this.allSymbols[k] = s;
            ++k;
        }
    }

    protected void extractRules(Set<RuleTuple> originalRules) {
        this.rules = new Tuple[originalRules.size()];
        int p = 0;
        for (RuleTuple t : originalRules) {
            if (t.rhs.length == 0) {
                throw new AssertionError((Object)("empty production " + t.toString()));
            }
            int h = this.symbolIndexes.get(t.head);
            int[] rhs = new int[t.rhs.length];
            for (int i = 0; i < rhs.length; ++i) {
                rhs[i] = this.symbolIndexes.get(t.rhs[i]);
            }
            this.rules[p++] = new Tuple(this.allSymbols, h, rhs);
        }
    }

    public ParseNode forest(List<LexerToken> src, Matrix matrix) {
        return this.forest(src, matrix, false);
    }

    public ParseNode forest(List<LexerToken> src, Matrix matrix, boolean full) {
        return this.forest(src, matrix, false, null);
    }

    public ParseNode forest(List<LexerToken> src, Matrix matrix, boolean full, String input) {
        HashMap explored = new HashMap();
        try {
            ParseNode root;
            int len = src.size();
            if (len == 0) {
                return new ParseNode(0, len, -1, this);
            }
            Cell cell = matrix.get(0, len);
            if (cell != null && 0 < cell.size() && (root = this.treeForACell(src, matrix, cell, 0, len)) != null) {
                return root;
            }
            ParseNode pseudoRoot = new ParseNode(0, len, -1, this);
            int X = 0;
            int offset = 0;
            int Y = matrix.lastY();
            if (offset < Y) {
                for (int t = 0; t < offset + 1; ++t) {
                    int x = X + t;
                    int y = Y + t - offset;
                    ParseNode coverX = pseudoRoot.coveredByOnTopLevel(x);
                    ParseNode coverY = pseudoRoot.coveredByOnTopLevel(y);
                    while (coverX != null || coverY != null) {
                        int delta = 0;
                        if (coverX != null) {
                            delta = coverX.to - y + 1;
                        }
                        if (coverY != null) {
                            delta = coverY.to - y + 1;
                        }
                        if (delta <= 0) break;
                        x = X + (t += delta);
                        y = Y + t - offset;
                        coverX = pseudoRoot.coveredByOnTopLevel(x);
                        coverY = pseudoRoot.coveredByOnTopLevel(y);
                    }
                    if (offset + 1 <= t || (cell = matrix.get(x, y)) == null) continue;
                    explored = new HashMap();
                    ParseNode node = this.treeForACell(src, matrix, cell, x, y);
                    if (node == null) continue;
                    pseudoRoot.addTopLevel(node);
                    node.parent = pseudoRoot;
                    if (full) continue;
                    return pseudoRoot;
                }
                if (full) {
                    return pseudoRoot;
                }
                return new ParseNode(0, 1, -1, this);
            }
        }
        catch (AssertionError e) {
            ((Throwable)((Object)e)).printStackTrace();
            System.err.println("Parser.forest(): AssertionError " + ((Throwable)((Object)e)).getMessage());
        }
        return null;
    }

    public abstract ParseNode parse(List<LexerToken> var1);

    abstract ParseNode treeForACell(List<LexerToken> var1, Matrix var2, Cell var3, int var4, int var5);

    abstract void parse(List<LexerToken> var1, Matriceable var2);

    public int getSymbol(String string) {
        return Parser.getSymbol(this.symbolIndexes, string);
    }

    public static int getSymbol(Map<String, Integer> symbolIndexes, String string) {
        try {
            return symbolIndexes.get(string);
        }
        catch (NullPointerException e) {
            return -1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public void swapRules(String rule2, String rule3) {
        Tuple t2 = null;
        int i2 = -1;
        Tuple t3 = null;
        int i3 = -1;
        for (int i = 0; i < this.rules.length; ++i) {
            Tuple t = this.rules[i];
            if (rule2.equals(t.toString())) {
                t2 = t;
                i2 = i;
            }
            if (!rule3.equals(t.toString())) continue;
            t3 = t;
            i3 = i;
        }
        this.rules[i2] = t3;
        this.rules[i3] = t2;
    }

    protected static long makeMatrixCellElem(int rule, int pos, Tuple t) {
        long activeVar = 0L;
        if (pos < t.rhs.length) {
            activeVar = t.rhs[pos];
        }
        return (long)rule << 16 | (long)pos | activeVar << 48;
    }

    public static int ruleFromEarleyCell(long code) {
        return (int)((code & 0xFFFFFFFFFFFFL) >> 16);
    }

    public static int posFromEarleyCell(long code) {
        return (int)(code & 0xFFFFL);
    }

    public class EarleyCell
    implements Cell {
        long[] content = null;

        public EarleyCell(long[] content) {
            this.content = content;
        }

        @Override
        public int getRule(int index) {
            return Parser.ruleFromEarleyCell(this.content[index]);
        }

        @Override
        public int getPosition(int index) {
            return Parser.posFromEarleyCell(this.content[index]);
        }

        @Override
        public int size() {
            if (this.content == null) {
                return 0;
            }
            return this.content.length;
        }

        @Override
        public long[] getContent() {
            return this.content;
        }

        @Override
        public void insertContent(long cellElem) {
            this.content = Array.insert(this.content, cellElem);
        }
    }
}

