/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import oracle.jdbc.OracleArray;
import oracle.jdbc.OracleBfile;
import oracle.jdbc.OracleBlob;
import oracle.jdbc.OracleClob;
import oracle.jdbc.OracleNClob;
import oracle.jdbc.OracleOpaque;
import oracle.jdbc.OracleRef;
import oracle.jdbc.OracleResultSetMetaData;
import oracle.jdbc.OracleStruct;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeCHAR;
import oracle.jdbc.oracore.OracleTypeFLOAT;
import oracle.jdbc.oracore.OracleTypeNUMBER;
import oracle.jdbc.oracore.OracleTypeRAW;
import oracle.jdbc.oracore.OracleTypeREF;
import oracle.sql.StructDescriptor;

class StructMetaData
implements oracle.jdbc.internal.StructMetaData {
    StructDescriptor descriptor;
    OracleTypeADT otype;
    OracleType[] types;

    public StructMetaData(StructDescriptor desc) throws SQLException {
        if (desc == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "illegal operation: descriptor is null").fillInStackTrace();
        }
        this.descriptor = desc;
        this.otype = desc.getOracleTypeADT();
        this.types = this.otype.getAttrTypes();
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.types.length;
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        return false;
    }

    @Override
    public OracleResultSetMetaData.SecurityAttribute getSecurityAttribute(int column) throws SQLException {
        return OracleResultSetMetaData.SecurityAttribute.NONE;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        int idx = this.getValidColumnIndex(column);
        return this.types[idx] instanceof OracleTypeNUMBER || this.types[idx] instanceof OracleTypeFLOAT;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        int idx = this.getValidColumnIndex(column);
        return this.types[idx] instanceof OracleTypeCHAR;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        return 1;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        return true;
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        int idx = this.getValidColumnIndex(column);
        if (this.types[idx] instanceof OracleTypeCHAR) {
            return ((OracleTypeCHAR)this.types[idx]).getLength();
        }
        if (this.types[idx] instanceof OracleTypeRAW) {
            return ((OracleTypeRAW)this.types[idx]).getLength();
        }
        return 0;
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return this.getColumnName(column);
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        return this.otype.getAttributeName(column);
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        int idx = this.getValidColumnIndex(column);
        if (this.types[idx] instanceof OracleTypeADT) {
            return ((OracleTypeADT)this.types[idx]).getSchemaName();
        }
        return "";
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        int idx = this.getValidColumnIndex(column);
        return this.types[idx].getPrecision();
    }

    @Override
    public int getScale(int column) throws SQLException {
        int idx = this.getValidColumnIndex(column);
        return this.types[idx].getScale();
    }

    @Override
    public boolean isVariableScale(int column) throws SQLException {
        int idx = this.getValidColumnIndex(column);
        return this.types[idx].getScale() == -127;
    }

    @Override
    public String getTableName(int column) throws SQLException {
        return null;
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        return null;
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        int idx = this.getValidColumnIndex(column);
        return this.types[idx].getTypeCode();
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        int type = this.getColumnType(column);
        int idx = this.getValidColumnIndex(column);
        switch (type) {
            case 12: {
                return "VARCHAR";
            }
            case 1: {
                return "CHAR";
            }
            case -2: {
                return "RAW";
            }
            case 6: {
                return "FLOAT";
            }
            case 2: {
                return "NUMBER";
            }
            case 8: {
                return "DOUBLE";
            }
            case 3: {
                return "DECIMAL";
            }
            case 100: {
                return "BINARY_FLOAT";
            }
            case 101: {
                return "BINARY_DOUBLE";
            }
            case 91: {
                return "DATE";
            }
            case -104: {
                return "INTERVALDS";
            }
            case -103: {
                return "INTERVALYM";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -101: {
                return "TIMESTAMP WITH TIME ZONE";
            }
            case -102: {
                return "TIMESTAMP WITH LOCAL TIME ZONE";
            }
            case 2004: {
                return "BLOB";
            }
            case 2005: {
                return "CLOB";
            }
            case -13: {
                return "BFILE";
            }
            case 2002: 
            case 2003: 
            case 2007: 
            case 2008: {
                return ((OracleTypeADT)this.types[idx]).getFullName();
            }
            case 2006: {
                return "REF " + ((OracleTypeREF)this.types[idx]).getFullName();
            }
            case -15: {
                return "NCHAR";
            }
            case -9: {
                return "NVARCHAR";
            }
            case 2011: {
                return "NCLOB";
            }
        }
        return null;
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return false;
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        int type = this.getColumnType(column);
        switch (type) {
            case -15: 
            case -9: 
            case 1: 
            case 12: {
                return "java.lang.String";
            }
            case -2: {
                return "byte[]";
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: {
                return "java.math.BigDecimal";
            }
            case 91: {
                return "java.sql.Timestamp";
            }
            case -103: {
                return "oracle.sql.INTERVALYM";
            }
            case -104: {
                return "oracle.sql.INTERVALDS";
            }
            case 93: {
                return "oracle.sql.TIMESTAMP";
            }
            case -101: {
                return "oracle.sql.TIMESTAMPTZ";
            }
            case -102: {
                return "oracle.sql.TIMESTAMPLTZ";
            }
            case 2004: {
                return OracleBlob.class.getName();
            }
            case 2005: {
                return OracleClob.class.getName();
            }
            case 2011: {
                return OracleNClob.class.getName();
            }
            case -13: {
                return OracleBfile.class.getName();
            }
            case 2002: 
            case 2008: {
                return OracleStruct.class.getName();
            }
            case 2007: {
                return OracleOpaque.class.getName();
            }
            case 2003: {
                return OracleArray.class.getName();
            }
            case 2006: {
                return OracleRef.class.getName();
            }
        }
        return null;
    }

    @Override
    public String getOracleColumnClassName(int column) throws SQLException {
        int type = this.getColumnType(column);
        switch (type) {
            case -15: 
            case -9: 
            case 1: 
            case 12: {
                return "CHAR";
            }
            case -2: {
                return "RAW";
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: {
                return "NUMBER";
            }
            case 91: {
                return "DATE";
            }
            case -103: {
                return "INTERVALYM";
            }
            case -104: {
                return "INTERVALDS";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -101: {
                return "TIMESTAMPTZ";
            }
            case -102: {
                return "TIMESTAMPLTZ";
            }
            case 2004: {
                return "BLOB";
            }
            case 2005: {
                return "CLOB";
            }
            case 2011: {
                return "NCLOB";
            }
            case -13: {
                return "BFILE";
            }
            case 2002: {
                return "STRUCT";
            }
            case 2008: {
                return "JAVA_STRUCT";
            }
            case 2007: {
                return "OPAQUE";
            }
            case 2003: {
                return "ARRAY";
            }
            case 2006: {
                return "REF";
            }
        }
        return null;
    }

    @Override
    public int getLocalColumnCount() throws SQLException {
        return this.descriptor.getLocalAttributeCount();
    }

    @Override
    public boolean isColumnInvisible(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isColumnJSON(int column) throws SQLException {
        return false;
    }

    @Override
    public String getDomainName(int column) throws SQLException {
        return null;
    }

    @Override
    public String getDomainSchema(int column) throws SQLException {
        return null;
    }

    @Override
    public boolean isInherited(int column) throws SQLException {
        return column <= this.getColumnCount() - this.getLocalColumnCount();
    }

    @Override
    public String getAttributeJavaName(int column) throws SQLException {
        int idx = this.getValidColumnIndex(column);
        return this.descriptor.getAttributeJavaName(idx);
    }

    private int getValidColumnIndex(int column) throws SQLException {
        int index = column - 1;
        if (index < 0 || index >= this.types.length) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getValidColumnIndex").fillInStackTrace();
        }
        return index;
    }

    @Override
    public boolean isNCHAR(int column) throws SQLException {
        int idx = this.getValidColumnIndex(column);
        return this.types[idx].isNCHAR();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        if (iface.isInterface()) {
            return iface.isInstance(this);
        }
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 177).fillInStackTrace();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInterface() && iface.isInstance(this)) {
            return (T)this;
        }
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 177).fillInStackTrace();
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }
}

