/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.jpa;

import com.mysema.query.jpa.JPASubQuery;
import com.mysema.query.support.CollectionAnyVisitor;
import com.mysema.query.support.Context;
import com.mysema.query.types.CollectionExpression;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.ExpressionUtils;
import com.mysema.query.types.Path;
import com.mysema.query.types.PathMetadataFactory;
import com.mysema.query.types.Predicate;
import com.mysema.query.types.path.EntityPathBase;
import com.mysema.query.types.path.ListPath;
import com.mysema.query.types.path.SimplePath;
import javax.persistence.Entity;

public final class JPACollectionAnyVisitor
extends CollectionAnyVisitor {
    public static final JPACollectionAnyVisitor DEFAULT = new JPACollectionAnyVisitor();

    protected Predicate exists(Context c, Predicate condition) {
        JPASubQuery query = new JPASubQuery();
        for (int i = 0; i < c.paths.size(); ++i) {
            Path child = ((Path)c.paths.get(i)).getMetadata().getParent();
            EntityPath replacement = (EntityPath)c.replacements.get(i);
            if (((Path)c.paths.get(i)).getType().isAnnotationPresent(Entity.class)) {
                query.from((CollectionExpression)new ListPath(((Path)c.paths.get(i)).getType(), SimplePath.class, child.getMetadata()), (Path)replacement);
                continue;
            }
            Path parent = child.getMetadata().getParent();
            EntityPathBase newParent = new EntityPathBase(parent.getType(), ExpressionUtils.createRootVariable((Path)parent));
            EntityPathBase newChild = new EntityPathBase(child.getType(), PathMetadataFactory.forProperty((Path)newParent, (String)child.getMetadata().getName()));
            ((JPASubQuery)query.from((EntityPath<?>)newParent)).innerJoin((EntityPath)newChild, (Path)replacement);
            query.where(ExpressionUtils.eq((Expression)newParent, (Expression)parent));
        }
        c.clear();
        query.where(condition);
        return query.exists();
    }

    private JPACollectionAnyVisitor() {
    }
}

