/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.jpa;

import com.mysema.query.JoinExpression;
import com.mysema.query.JoinFlag;
import com.mysema.query.QueryFlag;
import com.mysema.query.QueryMetadata;
import com.mysema.query.sql.ForeignKey;
import com.mysema.query.sql.RelationalPath;
import com.mysema.query.support.ProjectableQuery;
import com.mysema.query.support.QueryMixin;
import com.mysema.query.types.Expression;
import com.mysema.query.types.ExpressionUtils;
import com.mysema.query.types.Path;
import com.mysema.query.types.Predicate;
import com.mysema.query.types.SubQueryExpression;
import com.mysema.query.types.expr.SimpleExpression;
import com.mysema.query.types.expr.Wildcard;
import com.mysema.query.types.template.NumberTemplate;
import com.mysema.query.types.template.SimpleTemplate;
import java.util.List;

public abstract class AbstractSQLQuery<T extends AbstractSQLQuery<T>>
extends ProjectableQuery<T> {
    public AbstractSQLQuery(QueryMetadata metadata) {
        super(new QueryMixin(metadata));
        this.queryMixin.setSelf((Object)this);
    }

    public long count() {
        Number number = (Number)this.uniqueResult((Expression)Wildcard.countAsInt);
        return number.longValue();
    }

    public boolean exists() {
        return ((AbstractSQLQuery)this.limit(1L)).uniqueResult((Expression)NumberTemplate.ONE) != null;
    }

    public T from(Expression<?> ... args) {
        return (T)((Object)((AbstractSQLQuery)((Object)this.queryMixin.from(args))));
    }

    public T from(SubQueryExpression<?> subQuery, Path<?> alias) {
        return (T)((Object)((AbstractSQLQuery)((Object)this.queryMixin.from(new Expression[]{ExpressionUtils.as(subQuery, alias)}))));
    }

    public <E> T fullJoin(ForeignKey<E> key, RelationalPath<E> entity) {
        return ((AbstractSQLQuery)((Object)this.queryMixin.innerJoin(entity))).on(key.on(entity));
    }

    public T fullJoin(RelationalPath<?> o) {
        return (T)((Object)((AbstractSQLQuery)((Object)this.queryMixin.fullJoin(o))));
    }

    public T fullJoin(SubQueryExpression<?> o, Path<?> alias) {
        return (T)((Object)((AbstractSQLQuery)((Object)this.queryMixin.fullJoin(o, alias))));
    }

    public QueryMetadata getMetadata() {
        return this.queryMixin.getMetadata();
    }

    public <E> T innerJoin(ForeignKey<E> key, RelationalPath<E> entity) {
        return ((AbstractSQLQuery)((Object)this.queryMixin.innerJoin(entity))).on(key.on(entity));
    }

    public T innerJoin(RelationalPath<?> o) {
        return (T)((Object)((AbstractSQLQuery)((Object)this.queryMixin.innerJoin(o))));
    }

    public T innerJoin(SubQueryExpression<?> o, Path<?> alias) {
        return (T)((Object)((AbstractSQLQuery)((Object)this.queryMixin.innerJoin(o, alias))));
    }

    public <E> T join(ForeignKey<E> key, RelationalPath<E> entity) {
        return ((AbstractSQLQuery)((Object)this.queryMixin.innerJoin(entity))).on(key.on(entity));
    }

    public T join(RelationalPath<?> o) {
        return (T)((Object)((AbstractSQLQuery)((Object)this.queryMixin.join(o))));
    }

    public T join(SubQueryExpression<?> o, Path<?> alias) {
        return (T)((Object)((AbstractSQLQuery)((Object)this.queryMixin.join(o, alias))));
    }

    public <E> T leftJoin(ForeignKey<E> key, RelationalPath<E> entity) {
        return ((AbstractSQLQuery)((Object)this.queryMixin.innerJoin(entity))).on(key.on(entity));
    }

    public T leftJoin(RelationalPath<?> o) {
        return (T)((Object)((AbstractSQLQuery)((Object)this.queryMixin.leftJoin(o))));
    }

    public T leftJoin(SubQueryExpression<?> o, Path<?> alias) {
        return (T)((Object)((AbstractSQLQuery)((Object)this.queryMixin.leftJoin(o, alias))));
    }

    public T on(Predicate ... conditions) {
        return (T)((Object)((AbstractSQLQuery)((Object)this.queryMixin.on(conditions))));
    }

    public <E> T rightJoin(ForeignKey<E> key, RelationalPath<E> entity) {
        return ((AbstractSQLQuery)((Object)this.queryMixin.innerJoin(entity))).on(key.on(entity));
    }

    public T rightJoin(RelationalPath<?> o) {
        return (T)((Object)((AbstractSQLQuery)((Object)this.queryMixin.rightJoin(o))));
    }

    public T rightJoin(SubQueryExpression<?> o, Path<?> alias) {
        return (T)((Object)((AbstractSQLQuery)((Object)this.queryMixin.rightJoin(o, alias))));
    }

    public T addJoinFlag(String flag) {
        return this.addJoinFlag(flag, JoinFlag.Position.BEFORE_TARGET);
    }

    public T addJoinFlag(String flag, JoinFlag.Position position) {
        List joins = this.queryMixin.getMetadata().getJoins();
        ((JoinExpression)joins.get(joins.size() - 1)).addFlag(new JoinFlag(flag, position));
        return (T)((Object)this);
    }

    public T addFlag(QueryFlag.Position position, String prefix, Expression<?> expr) {
        SimpleExpression flag = SimpleTemplate.create((Class)expr.getType(), (String)(prefix + "{0}"), (Expression[])new Expression[]{expr});
        return (T)((Object)((AbstractSQLQuery)((Object)this.queryMixin.addFlag(new QueryFlag(position, (Expression)flag)))));
    }

    public T addFlag(QueryFlag.Position position, String flag) {
        return (T)((Object)((AbstractSQLQuery)((Object)this.queryMixin.addFlag(new QueryFlag(position, flag)))));
    }

    public T addFlag(QueryFlag.Position position, Expression<?> flag) {
        return (T)((Object)((AbstractSQLQuery)((Object)this.queryMixin.addFlag(new QueryFlag(position, flag)))));
    }
}

