/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.jpa.hibernate.sql;

import com.mysema.commons.lang.CloseableIterator;
import com.mysema.commons.lang.IteratorAdapter;
import com.mysema.query.DefaultQueryMetadata;
import com.mysema.query.QueryMetadata;
import com.mysema.query.QueryModifiers;
import com.mysema.query.SearchResults;
import com.mysema.query.jpa.AbstractSQLQuery;
import com.mysema.query.jpa.HibernateSQLSerializer;
import com.mysema.query.jpa.hibernate.DefaultSessionHolder;
import com.mysema.query.jpa.hibernate.FactoryExpressionTransformer;
import com.mysema.query.jpa.hibernate.HibernateQuery;
import com.mysema.query.jpa.hibernate.HibernateUtil;
import com.mysema.query.jpa.hibernate.SessionHolder;
import com.mysema.query.jpa.hibernate.StatelessSessionHolder;
import com.mysema.query.sql.SQLCommonQuery;
import com.mysema.query.sql.SQLTemplates;
import com.mysema.query.types.Expression;
import com.mysema.query.types.FactoryExpression;
import com.mysema.query.types.Path;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.StatelessSession;
import org.hibernate.transform.ResultTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HibernateSQLQuery
extends AbstractSQLQuery<HibernateSQLQuery>
implements SQLCommonQuery<HibernateSQLQuery> {
    private static final Logger logger = LoggerFactory.getLogger(HibernateQuery.class);
    private Boolean cacheable;
    private Boolean readOnly;
    private String cacheRegion;
    @Nullable
    private Map<Object, String> constants;
    @Nullable
    private List<Path<?>> entityPaths;
    private int fetchSize = 0;
    private final SessionHolder session;
    private final SQLTemplates sqlTemplates;
    private int timeout = 0;

    public HibernateSQLQuery(Session session, SQLTemplates sqlTemplates) {
        this(new DefaultSessionHolder(session), sqlTemplates, (QueryMetadata)new DefaultQueryMetadata());
    }

    protected HibernateSQLQuery(SessionHolder session, SQLTemplates sqlTemplates, QueryMetadata metadata) {
        super(metadata);
        this.session = session;
        this.sqlTemplates = sqlTemplates;
    }

    public HibernateSQLQuery(StatelessSession session, SQLTemplates sqlTemplates) {
        this(new StatelessSessionHolder(session), sqlTemplates, (QueryMetadata)new DefaultQueryMetadata());
    }

    private String buildQueryString(boolean forCountRow) {
        if (this.queryMixin.getMetadata().getJoins().isEmpty()) {
            throw new IllegalArgumentException("No joins given");
        }
        HibernateSQLSerializer serializer = new HibernateSQLSerializer(this.sqlTemplates);
        serializer.serialize(this.queryMixin.getMetadata(), forCountRow);
        this.constants = serializer.getConstantToLabel();
        this.entityPaths = serializer.getEntityPaths();
        return serializer.toString();
    }

    public HibernateSQLQuery clone(Session session) {
        return new HibernateSQLQuery(new DefaultSessionHolder(session), this.sqlTemplates, this.getMetadata().clone());
    }

    public Query createQuery(Expression<?> ... args) {
        this.queryMixin.addToProjection(args);
        return this.createQuery(this.toQueryString());
    }

    private Query createQuery(String queryString) {
        this.logQuery(queryString);
        SQLQuery query = this.session.createSQLQuery(queryString);
        HibernateUtil.setConstants((Query)query, this.constants, this.queryMixin.getMetadata().getParams());
        for (Path<?> path : this.entityPaths) {
            query.addEntity(path.toString(), path.getType());
        }
        List projection = this.queryMixin.getMetadata().getProjection();
        if (projection.size() == 1 && projection.get(0) instanceof FactoryExpression) {
            query.setResultTransformer((ResultTransformer)new FactoryExpressionTransformer((FactoryExpression)projection.get(0)));
        }
        if (this.fetchSize > 0) {
            query.setFetchSize(this.fetchSize);
        }
        if (this.timeout > 0) {
            query.setTimeout(this.timeout);
        }
        if (this.cacheable != null) {
            query.setCacheable(this.cacheable.booleanValue());
        }
        if (this.cacheRegion != null) {
            query.setCacheRegion(this.cacheRegion);
        }
        if (this.readOnly != null) {
            query.setReadOnly(this.readOnly.booleanValue());
        }
        return query;
    }

    public List<Object[]> list(Expression<?>[] projection) {
        Query query = this.createQuery(projection);
        this.reset();
        return query.list();
    }

    public <RT> List<RT> list(Expression<RT> projection) {
        Query query = this.createQuery(projection);
        this.reset();
        return query.list();
    }

    public CloseableIterator<Object[]> iterate(Expression<?>[] args) {
        return new IteratorAdapter(this.list(args).iterator());
    }

    public <RT> CloseableIterator<RT> iterate(Expression<RT> projection) {
        return new IteratorAdapter(this.list(projection).iterator());
    }

    public <RT> SearchResults<RT> listResults(Expression<RT> projection) {
        this.queryMixin.addToProjection(new Expression[]{projection});
        Query query = this.createQuery(this.toCountRowsString());
        long total = ((Integer)query.uniqueResult()).longValue();
        if (total > 0L) {
            QueryModifiers modifiers = this.queryMixin.getMetadata().getModifiers();
            String queryString = this.toQueryString();
            query = this.createQuery(queryString);
            List list = query.list();
            this.reset();
            return new SearchResults(list, modifiers, total);
        }
        this.reset();
        return SearchResults.emptyResults();
    }

    protected void logQuery(String queryString) {
        if (logger.isDebugEnabled()) {
            logger.debug(queryString.replace('\n', ' '));
        }
    }

    protected void reset() {
        this.queryMixin.getMetadata().reset();
        this.entityPaths = null;
        this.constants = null;
    }

    protected String toCountRowsString() {
        return this.buildQueryString(true);
    }

    protected String toQueryString() {
        return this.buildQueryString(false);
    }

    public <RT> RT uniqueResult(Expression<RT> expr) {
        Query query = this.createQuery(expr);
        this.reset();
        return (RT)query.uniqueResult();
    }

    public HibernateSQLQuery setCacheable(boolean cacheable) {
        this.cacheable = cacheable;
        return this;
    }

    public HibernateSQLQuery setCacheRegion(String cacheRegion) {
        this.cacheRegion = cacheRegion;
        return this;
    }

    public HibernateSQLQuery setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
        return this;
    }

    public HibernateSQLQuery setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    public HibernateSQLQuery setTimeout(int timeout) {
        this.timeout = timeout;
        return this;
    }
}

