/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.jpa;

import com.mysema.query.jpa.JPQLTemplates;
import com.mysema.query.types.Constant;
import com.mysema.query.types.Operator;
import com.mysema.query.types.Ops;
import com.mysema.query.types.PathType;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class HQLTemplates
extends JPQLTemplates {
    private static final List<Operator<?>> wrapElements = Arrays.asList(Ops.QuantOps.ALL, Ops.QuantOps.ANY, Ops.QuantOps.AVG_IN_COL, Ops.EXISTS);
    public static final HQLTemplates DEFAULT = new HQLTemplates();

    protected HQLTemplates() {
        this.add(CAST, "cast({0} as {1s})");
        this.add(Ops.INSTANCE_OF, "{0}.class = {1}");
        this.add(MEMBER_OF, "{0} in elements({1})");
        for (PathType type : new PathType[]{PathType.LISTVALUE, PathType.MAPVALUE, PathType.MAPVALUE_CONSTANT}) {
            this.add((Operator)type, "{0}[{1}]");
        }
        this.add((Operator)PathType.LISTVALUE_CONSTANT, "{0}[{1s}]");
        this.add(Ops.CONTAINS_KEY, "{1} in indices({0})");
        this.add(Ops.CONTAINS_VALUE, "{1} in elements({0})");
        this.add(Ops.DateTimeOps.MILLISECOND, "0");
        this.add(Ops.DateTimeOps.SECOND, "second({0})");
        this.add(Ops.DateTimeOps.MINUTE, "minute({0})");
        this.add(Ops.DateTimeOps.HOUR, "hour({0})");
        this.add(Ops.DateTimeOps.DAY_OF_MONTH, "day({0})");
        this.add(Ops.DateTimeOps.MONTH, "month({0})");
        this.add(Ops.DateTimeOps.YEAR, "year({0})");
        this.add(Ops.DateTimeOps.YEAR_MONTH, "year({0}) * 100 + month({0})");
    }

    @Override
    public boolean wrapElements(Operator<?> operator) {
        return wrapElements.contains(operator);
    }

    @Override
    public boolean wrapConstant(Constant<?> expr) {
        Class type = expr.getType();
        return type.isArray() || Collection.class.isAssignableFrom(type);
    }

    @Override
    public boolean isTypeAsString() {
        return true;
    }
}

