/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.apt;

import com.mysema.codegen.model.Constructor;
import com.mysema.codegen.model.Parameter;
import com.mysema.codegen.model.Type;
import com.mysema.codegen.model.TypeCategory;
import com.mysema.query.annotations.PropertyType;
import com.mysema.query.annotations.QueryInit;
import com.mysema.query.annotations.QueryType;
import com.mysema.query.apt.APTException;
import com.mysema.query.apt.Configuration;
import com.mysema.query.apt.ExtendedTypeFactory;
import com.mysema.query.apt.VisitorConfig;
import com.mysema.query.codegen.EntityType;
import com.mysema.query.codegen.Property;
import com.mysema.query.codegen.QueryTypeFactory;
import com.mysema.query.codegen.TypeMappings;
import com.mysema.util.BeanUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;
import net.jcip.annotations.Immutable;

@Immutable
public final class ElementHandler {
    private final TypeMappings typeMappings;
    private final QueryTypeFactory queryTypeFactory;
    private final Configuration configuration;
    private final ExtendedTypeFactory typeFactory;

    public ElementHandler(Configuration configuration, ExtendedTypeFactory typeFactory, TypeMappings typeMappings, QueryTypeFactory queryTypeFactory) {
        this.configuration = configuration;
        this.typeFactory = typeFactory;
        this.typeMappings = typeMappings;
        this.queryTypeFactory = queryTypeFactory;
    }

    public EntityType handleEntityType(TypeElement e) {
        String name;
        EntityType entityType = this.typeFactory.getEntityType(e.asType(), true);
        List<? extends Element> elements = e.getEnclosedElements();
        VisitorConfig config = this.configuration.getConfig(e, elements);
        HashSet<String> blockedProperties = new HashSet<String>();
        HashMap<String, Property> properties = new HashMap<String, Property>();
        HashMap<String, TypeCategory> types = new HashMap<String, TypeCategory>();
        if (config.visitConstructors()) {
            this.handleConstructors(entityType, elements);
        }
        if (config.visitFieldProperties()) {
            for (VariableElement variableElement : ElementFilter.fieldsIn(elements)) {
                name = variableElement.getSimpleName().toString();
                if (this.configuration.isBlockedField(variableElement)) {
                    blockedProperties.add(name);
                    continue;
                }
                if (!this.configuration.isValidField(variableElement)) continue;
                this.handleFieldProperty(entityType, variableElement, properties, blockedProperties, types);
            }
        }
        if (config.visitMethodProperties()) {
            for (ExecutableElement executableElement : ElementFilter.methodsIn(elements)) {
                name = executableElement.getSimpleName().toString();
                if (name.startsWith("get") && executableElement.getParameters().isEmpty()) {
                    name = BeanUtils.uncapitalize((String)name.substring(3));
                } else {
                    if (!name.startsWith("is") || !executableElement.getParameters().isEmpty()) continue;
                    name = BeanUtils.uncapitalize((String)name.substring(2));
                }
                if (this.configuration.isBlockedGetter(executableElement)) {
                    blockedProperties.add(name);
                    continue;
                }
                if (!this.configuration.isValidGetter(executableElement)) continue;
                this.handleMethodProperty(entityType, name, executableElement, properties, blockedProperties, types);
            }
        }
        for (Map.Entry entry : properties.entrySet()) {
            if (blockedProperties.contains(entry.getKey())) continue;
            entityType.addProperty((Property)entry.getValue());
        }
        return entityType;
    }

    public EntityType handleProjectionType(TypeElement e) {
        Type c = this.typeFactory.getType(e.asType(), true);
        EntityType entityType = new EntityType(c.as(TypeCategory.ENTITY));
        this.typeMappings.register((Type)entityType, this.queryTypeFactory.create((Type)entityType));
        List<? extends Element> elements = e.getEnclosedElements();
        this.handleConstructors(entityType, elements);
        return entityType;
    }

    private Type getType(VariableElement element) {
        QueryType qt;
        Type rv = this.typeFactory.getType(element.asType(), true);
        if (element.getAnnotation(QueryType.class) != null && (qt = element.getAnnotation(QueryType.class)).value() != PropertyType.NONE) {
            TypeCategory typeCategory = qt.value().getCategory();
            rv = rv.as(typeCategory);
        }
        return rv;
    }

    private void handleConstructors(EntityType entityType, List<? extends Element> elements) {
        for (ExecutableElement constructor : ElementFilter.constructorsIn(elements)) {
            if (!this.configuration.isValidConstructor(constructor)) continue;
            List<Parameter> parameters = this.transformParams(constructor.getParameters());
            entityType.addConstructor(new Constructor(parameters));
        }
    }

    private void handleFieldProperty(EntityType entityType, VariableElement field, Map<String, Property> properties, Set<String> blockedProperties, Map<String, TypeCategory> types) {
        String name = field.getSimpleName().toString();
        try {
            Type fieldType = this.typeFactory.getType(field.asType(), true);
            if (field.getAnnotation(QueryType.class) != null) {
                TypeCategory typeCategory = field.getAnnotation(QueryType.class).value().getCategory();
                if (typeCategory == null) {
                    blockedProperties.add(name);
                    return;
                }
                fieldType = fieldType.as(typeCategory);
                types.put(name, typeCategory);
            }
            String[] inits = new String[]{};
            if (field.getAnnotation(QueryInit.class) != null) {
                inits = field.getAnnotation(QueryInit.class).value();
            }
            properties.put(name, new Property(entityType, name, fieldType, inits));
        }
        catch (IllegalArgumentException ex) {
            StringBuilder builder = new StringBuilder();
            builder.append("Caught exception for field ");
            builder.append(entityType.getFullName()).append("#").append(field.getSimpleName());
            throw new APTException(builder.toString(), ex);
        }
    }

    private void handleMethodProperty(EntityType entityType, String propertyName, ExecutableElement method, Map<String, Property> properties, Set<String> blockedProperties, Map<String, TypeCategory> types) {
        try {
            Type propertyType = this.typeFactory.getType(method.getReturnType(), true);
            if (method.getAnnotation(QueryType.class) != null) {
                TypeCategory typeCategory = method.getAnnotation(QueryType.class).value().getCategory();
                if (typeCategory == null) {
                    blockedProperties.add(propertyName);
                    return;
                }
                if (blockedProperties.contains(propertyName)) {
                    return;
                }
                propertyType = propertyType.as(typeCategory);
            } else if (types.containsKey(propertyName)) {
                propertyType = propertyType.as(types.get(propertyName));
            }
            String[] inits = new String[]{};
            if (method.getAnnotation(QueryInit.class) != null) {
                inits = method.getAnnotation(QueryInit.class).value();
            }
            properties.put(propertyName, new Property(entityType, propertyName, propertyType, inits));
        }
        catch (IllegalArgumentException ex) {
            StringBuilder builder = new StringBuilder();
            builder.append("Caught exception for method ");
            builder.append(entityType.getFullName()).append("#").append(method.getSimpleName());
            throw new APTException(builder.toString(), ex);
        }
    }

    public List<Parameter> transformParams(List<? extends VariableElement> params) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>(params.size());
        for (VariableElement variableElement : params) {
            Type paramType = this.getType(variableElement);
            parameters.add(new Parameter(variableElement.getSimpleName().toString(), paramType));
        }
        return parameters;
    }
}

