/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.apt;

import com.mysema.codegen.CodeWriter;
import com.mysema.codegen.JavaWriter;
import com.mysema.codegen.model.Parameter;
import com.mysema.codegen.model.SimpleType;
import com.mysema.codegen.model.Type;
import com.mysema.codegen.model.TypeCategory;
import com.mysema.commons.lang.Assert;
import com.mysema.query.annotations.QueryDelegate;
import com.mysema.query.annotations.QueryEntities;
import com.mysema.query.annotations.QueryExtensions;
import com.mysema.query.annotations.QueryMethod;
import com.mysema.query.annotations.QueryProjection;
import com.mysema.query.annotations.Variables;
import com.mysema.query.apt.APTTypeFactory;
import com.mysema.query.apt.Configuration;
import com.mysema.query.apt.ElementHandler;
import com.mysema.query.codegen.Delegate;
import com.mysema.query.codegen.EntityType;
import com.mysema.query.codegen.Method;
import com.mysema.query.codegen.Serializer;
import com.mysema.query.codegen.SerializerConfig;
import com.mysema.query.codegen.Supertype;
import com.mysema.query.codegen.TypeFactory;
import com.mysema.query.codegen.TypeMappings;
import java.io.IOException;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

public class Processor {
    private final Map<String, EntityType> actualSupertypes = new HashMap<String, EntityType>();
    private final Map<String, EntityType> allSupertypes = new HashMap<String, EntityType>();
    private final Configuration configuration;
    private final Map<String, EntityType> dtos = new HashMap<String, EntityType>();
    private final ElementHandler elementHandler;
    private final Map<String, EntityType> embeddables = new HashMap<String, EntityType>();
    private final Map<String, EntityType> entityTypes = new HashMap<String, EntityType>();
    private final ProcessingEnvironment env;
    private final Map<String, EntityType> extensionTypes = new HashMap<String, EntityType>();
    private final RoundEnvironment roundEnv;
    private final APTTypeFactory typeModelFactory;

    public Processor(ProcessingEnvironment env, RoundEnvironment roundEnv, Configuration configuration) {
        this.env = (ProcessingEnvironment)Assert.notNull((Object)env, (String)"env");
        this.roundEnv = (RoundEnvironment)Assert.notNull((Object)roundEnv, (String)"roundEnv");
        this.configuration = (Configuration)Assert.notNull((Object)configuration, (String)"configuration");
        ArrayList<Class<? extends Annotation>> anns = new ArrayList<Class<? extends Annotation>>();
        anns.add(configuration.getEntityAnnotation());
        if (configuration.getSuperTypeAnnotation() != null) {
            anns.add(configuration.getSuperTypeAnnotation());
        }
        if (configuration.getEmbeddableAnnotation() != null) {
            anns.add(configuration.getEmbeddableAnnotation());
        }
        TypeFactory factory = new TypeFactory(anns);
        this.typeModelFactory = new APTTypeFactory(env, configuration, factory, anns);
        this.elementHandler = new ElementHandler(configuration, this.typeModelFactory);
    }

    private void addSupertypeFields(EntityType model, Map<String, EntityType> superTypes, Set<EntityType> handled) {
        if (handled.add(model)) {
            for (Supertype supertype : model.getSuperTypes()) {
                EntityType entityType = superTypes.get(supertype.getType().getFullName());
                if (entityType == null) continue;
                this.addSupertypeFields(entityType, superTypes, handled);
                supertype.setEntityType(entityType);
                model.include(supertype);
            }
        }
    }

    private void handleExtensionType(TypeMirror type, Element element) {
        EntityType entityModel = this.typeModelFactory.createEntityType(type);
        HashSet<Method> queryMethods = new HashSet<Method>();
        for (ExecutableElement executableElement : ElementFilter.methodsIn(element.getEnclosedElements())) {
            if (executableElement.getAnnotation(QueryMethod.class) == null) continue;
            this.elementHandler.handleQueryMethod(entityModel, executableElement, queryMethods);
        }
        for (Method method : queryMethods) {
            entityModel.addMethod(method);
        }
        this.extensionTypes.put(entityModel.getFullName(), entityModel);
    }

    public void process() {
        this.processAnnotations();
        for (String string : this.entityTypes.keySet()) {
            this.extensionTypes.remove(string);
        }
        this.serializeModels();
        for (Element element : this.roundEnv.getElementsAnnotatedWith(Variables.class)) {
            if (!(element instanceof PackageElement)) continue;
            Variables vars = element.getAnnotation(Variables.class);
            PackageElement packageElement = (PackageElement)element;
            ArrayList<EntityType> models = new ArrayList<EntityType>();
            for (EntityType model : this.entityTypes.values()) {
                if (!model.getPackageName().equals(packageElement.getQualifiedName().toString())) continue;
                models.add(model);
            }
            this.serializeVariableList(packageElement.getQualifiedName().toString(), vars, models);
        }
    }

    private void serializeModels() {
        Messager msg = this.env.getMessager();
        if (!this.actualSupertypes.isEmpty()) {
            msg.printMessage(Diagnostic.Kind.NOTE, "Serializing Supertypes");
            this.serialize(this.configuration.getSupertypeSerializer(), this.actualSupertypes.values());
        }
        if (!this.entityTypes.isEmpty()) {
            msg.printMessage(Diagnostic.Kind.NOTE, "Serializing Entity types");
            this.serialize(this.configuration.getEntitySerializer(), this.entityTypes.values());
        }
        if (!this.extensionTypes.isEmpty()) {
            msg.printMessage(Diagnostic.Kind.NOTE, "Serializing Extension types");
            this.serialize(this.configuration.getEmbeddableSerializer(), this.extensionTypes.values());
        }
        if (!this.embeddables.isEmpty()) {
            msg.printMessage(Diagnostic.Kind.NOTE, "Serializing Embeddable types");
            this.serialize(this.configuration.getEmbeddableSerializer(), this.embeddables.values());
        }
        if (!this.dtos.isEmpty()) {
            msg.printMessage(Diagnostic.Kind.NOTE, "Serializing DTO types");
            this.serialize(this.configuration.getDTOSerializer(), this.dtos.values());
        }
    }

    private void processAnnotations() {
        this.processDelegateMethods();
        this.processCustomTypes();
        this.processExtensions();
        if (this.configuration.getSuperTypeAnnotation() != null) {
            this.processSupertypes();
        }
        if (this.configuration.getEmbeddedAnnotation() != null) {
            this.processEmbedded();
        }
        if (this.configuration.getEmbeddableAnnotation() != null) {
            this.processEmbeddables();
        }
        if (this.configuration.getEntitiesAnnotation() != null) {
            this.processEntitiesFromPackage();
        }
        this.processEntities();
        this.processDTOs();
    }

    private void processEntitiesFromPackage() {
        Class<? extends Annotation> annotation = this.configuration.getEntitiesAnnotation();
        ArrayList<TypeMirror> mirrors = new ArrayList<TypeMirror>();
        for (Element element : this.roundEnv.getElementsAnnotatedWith(annotation)) {
            for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
                if (!annotationMirror.getAnnotationType().asElement().getSimpleName().toString().equals(QueryEntities.class.getSimpleName())) continue;
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                    if (!entry.getKey().getSimpleName().toString().equals("value")) continue;
                    List values = (List)entry.getValue().getValue();
                    for (AnnotationValue value : values) {
                        TypeMirror type = (TypeMirror)value.getValue();
                        this.typeModelFactory.createEntityType(type);
                        mirrors.add(type);
                    }
                }
            }
        }
        Map<String, EntityType> types = this.entityTypes;
        ArrayDeque<Type> arrayDeque = new ArrayDeque<Type>();
        for (TypeMirror typeMirror : mirrors) {
            TypeElement element = (TypeElement)this.env.getTypeUtils().asElement(typeMirror);
            EntityType model = this.elementHandler.handleNormalType(element);
            types.put(model.getFullName(), model);
            if (model.getSuperType() == null) continue;
            arrayDeque.push(model.getSuperType().getType());
        }
        this.mergeTypes(types, arrayDeque);
    }

    private void process(Class<? extends Annotation> annotation, Map<String, EntityType> types) {
        ArrayDeque<Type> superTypes = new ArrayDeque<Type>();
        for (Element element : this.roundEnv.getElementsAnnotatedWith(annotation)) {
            if (this.configuration.getEmbeddableAnnotation() != null && element.getAnnotation(this.configuration.getEmbeddableAnnotation()) != null) continue;
            this.typeModelFactory.createEntityType(element.asType());
        }
        for (Element element : this.roundEnv.getElementsAnnotatedWith(annotation)) {
            if (this.configuration.getEmbeddableAnnotation() != null && element.getAnnotation(this.configuration.getEmbeddableAnnotation()) != null) continue;
            EntityType model = this.elementHandler.handleNormalType((TypeElement)element);
            types.put(model.getFullName(), model);
            if (model.getSuperType() == null) continue;
            superTypes.push(model.getSuperType().getType());
        }
        this.mergeTypes(types, superTypes);
    }

    private void mergeTypes(Map<String, EntityType> types, Deque<Type> superTypes) {
        while (!superTypes.isEmpty()) {
            Type superType = superTypes.pop();
            if (types.containsKey(superType.getFullName()) || this.allSupertypes.containsKey(superType.getFullName())) continue;
            TypeElement typeElement = this.env.getElementUtils().getTypeElement(superType.getFullName());
            EntityType entityType = this.elementHandler.handleNormalType(typeElement);
            if (entityType.getSuperType() != null) {
                superTypes.push(entityType.getSuperType().getType());
            }
            types.put(superType.getFullName(), entityType);
        }
        this.allSupertypes.putAll(types);
        HashSet<EntityType> handled = new HashSet<EntityType>();
        for (EntityType type : types.values()) {
            this.addSupertypeFields(type, this.allSupertypes, handled);
        }
    }

    private void processCustomTypes() {
        for (Element element : this.roundEnv.getElementsAnnotatedWith(QueryMethod.class)) {
            Element element2 = element.getEnclosingElement();
            if (element2.getAnnotation(QueryExtensions.class) != null || element2.getAnnotation(this.configuration.getEntityAnnotation()) != null || this.configuration.getSuperTypeAnnotation() != null && element2.getAnnotation(this.configuration.getSuperTypeAnnotation()) != null || this.configuration.getEmbeddableAnnotation() != null && element2.getAnnotation(this.configuration.getEmbeddableAnnotation()) != null) continue;
            this.handleExtensionType(element2.asType(), element2);
        }
    }

    private void processDelegateMethods() {
        HashSet<EntityType> types = new HashSet<EntityType>();
        for (Element element : this.roundEnv.getElementsAnnotatedWith(QueryDelegate.class)) {
            ExecutableElement method = (ExecutableElement)element;
            Element element2 = element.getEnclosingElement();
            String name = method.getSimpleName().toString();
            Type delegateType = this.typeModelFactory.create(element2.asType());
            Type returnType = this.typeModelFactory.create(method.getReturnType());
            List<Parameter> parameters = this.elementHandler.transformParams(method.getParameters());
            parameters = parameters.subList(1, parameters.size());
            EntityType entityType = null;
            for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
                if (!annotationMirror.getAnnotationType().asElement().getSimpleName().toString().equals(QueryDelegate.class.getSimpleName())) continue;
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                    if (!entry.getKey().getSimpleName().toString().equals("value") || !(entry.getValue().getValue() instanceof TypeMirror)) continue;
                    TypeMirror type = (TypeMirror)entry.getValue().getValue();
                    entityType = this.typeModelFactory.createEntityType(type);
                }
            }
            if (entityType == null) continue;
            entityType.addDelegate(new Delegate(entityType, delegateType, name, parameters, returnType));
            types.add(entityType);
        }
        for (EntityType entityType : types) {
            if (entityType.getOriginalCategory() == TypeCategory.SIMPLE) continue;
            this.extensionTypes.put(entityType.getFullName(), entityType);
        }
    }

    private void processDTOs() {
        HashSet<Element> visitedDTOTypes = new HashSet<Element>();
        for (Element element : this.roundEnv.getElementsAnnotatedWith(QueryProjection.class)) {
            Element parent = element.getEnclosingElement();
            if (parent.getAnnotation(this.configuration.getEntityAnnotation()) != null || parent.getAnnotation(this.configuration.getEmbeddableAnnotation()) != null || visitedDTOTypes.contains(parent)) continue;
            EntityType model = this.elementHandler.handleProjectionType((TypeElement)parent);
            this.dtos.put(model.getFullName(), model);
            visitedDTOTypes.add(parent);
        }
    }

    private void processEmbeddables() {
        for (Element element : this.roundEnv.getElementsAnnotatedWith(this.configuration.getEmbeddableAnnotation())) {
            this.typeModelFactory.createEntityType(element.asType());
        }
        for (Element element : this.roundEnv.getElementsAnnotatedWith(this.configuration.getEmbeddableAnnotation())) {
            EntityType model = this.elementHandler.handleNormalType((TypeElement)element);
            this.embeddables.put(model.getFullName(), model);
        }
        this.allSupertypes.putAll(this.embeddables);
        HashSet<EntityType> handled = new HashSet<EntityType>();
        for (EntityType embeddable : this.embeddables.values()) {
            this.addSupertypeFields(embeddable, this.allSupertypes, handled);
        }
    }

    private void processEmbedded() {
        for (Element element : this.roundEnv.getElementsAnnotatedWith(this.configuration.getEmbeddedAnnotation())) {
            String typeName;
            TypeMirror type = element.asType();
            if (element.getKind() == ElementKind.METHOD) {
                type = ((ExecutableElement)element).getReturnType();
            }
            if ((typeName = ((Object)type).toString()).startsWith("java.util")) {
                typeName = typeName.substring(typeName.indexOf(60) + 1, typeName.lastIndexOf(62));
                this.typeModelFactory.createEntityType(this.env.getElementUtils().getTypeElement(typeName).asType());
            }
            TypeElement typeElement = this.env.getElementUtils().getTypeElement(typeName);
            EntityType model = this.elementHandler.handleNormalType(typeElement);
            this.embeddables.put(model.getFullName(), model);
        }
        this.allSupertypes.putAll(this.embeddables);
        HashSet<EntityType> handled = new HashSet<EntityType>();
        for (EntityType embeddable : this.embeddables.values()) {
            this.addSupertypeFields(embeddable, this.allSupertypes, handled);
        }
    }

    private void processEntities() {
        this.process(this.configuration.getEntityAnnotation(), this.entityTypes);
    }

    private void processExtensions() {
        for (Element element : this.roundEnv.getElementsAnnotatedWith(QueryExtensions.class)) {
            for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
                if (!annotationMirror.getAnnotationType().asElement().getSimpleName().toString().equals(QueryExtensions.class.getSimpleName())) continue;
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                    if (!entry.getKey().getSimpleName().toString().equals("value") || !(entry.getValue().getValue() instanceof TypeMirror)) continue;
                    TypeMirror type = (TypeMirror)entry.getValue().getValue();
                    this.handleExtensionType(type, element);
                }
            }
        }
    }

    private void processSupertypes() {
        this.process(this.configuration.getSuperTypeAnnotation(), this.actualSupertypes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serialize(Serializer serializer, Collection<EntityType> models) {
        Messager msg = this.env.getMessager();
        for (EntityType model : models) {
            try {
                boolean generate;
                String packageName = model.getPackageName();
                Type type = this.configuration.getTypeMappings().getPathType((Type)model, model, true);
                String className = packageName.length() > 0 ? packageName + "." + type.getSimpleName() : type.getSimpleName();
                Filer filer = this.env.getFiler();
                FileObject sourceFile = this.getSourceFile(model.getFullName());
                FileObject generatedFile = filer.getResource(StandardLocation.SOURCE_OUTPUT, packageName, type.getSimpleName() + ".java");
                if (sourceFile != null && sourceFile.getLastModified() > 0L) {
                    generate = generatedFile.getLastModified() <= sourceFile.getLastModified();
                } else if (this.configuration.isDefaultOverwrite()) {
                    generate = true;
                } else {
                    boolean bl = generate = generatedFile.getLastModified() <= 0L;
                }
                if (generate) {
                    msg.printMessage(Diagnostic.Kind.NOTE, "Generating " + className + " for " + model.getFullName());
                    JavaFileObject fileObject = this.env.getFiler().createSourceFile(className, new Element[0]);
                    Writer writer = fileObject.openWriter();
                    try {
                        SerializerConfig serializerConfig = this.configuration.getSerializerConfig(model);
                        serializer.serialize(model, serializerConfig, (CodeWriter)new JavaWriter((Appendable)writer));
                        continue;
                    }
                    finally {
                        if (writer != null) {
                            writer.close();
                        }
                        continue;
                    }
                }
                msg.printMessage(Diagnostic.Kind.NOTE, className + " is up-to-date ");
            }
            catch (IOException e) {
                msg.printMessage(Diagnostic.Kind.ERROR, e.getMessage());
            }
        }
    }

    @Nullable
    private FileObject getSourceFile(String fullName) throws IOException {
        Elements elementUtils = this.env.getElementUtils();
        TypeElement sourceElement = elementUtils.getTypeElement(fullName);
        if (sourceElement == null) {
            return null;
        }
        if (sourceElement.getNestingKind().isNested()) {
            sourceElement = (TypeElement)sourceElement.getEnclosingElement();
        }
        PackageElement packageElement = elementUtils.getPackageOf(sourceElement);
        try {
            return this.env.getFiler().getResource(StandardLocation.SOURCE_PATH, packageElement.getQualifiedName(), sourceElement.getSimpleName() + ".java");
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serializeVariableList(String packageName, Variables vars, List<EntityType> models) {
        String className = packageName + "." + vars.value();
        TypeMappings typeMappings = this.configuration.getTypeMappings();
        try {
            JavaFileObject fileObject = this.env.getFiler().createSourceFile(className, new Element[0]);
            Writer w = fileObject.openWriter();
            try {
                JavaWriter writer = new JavaWriter((Appendable)w);
                writer.packageDecl(packageName);
                SimpleType simpleType = new SimpleType(packageName + "." + vars.value(), packageName, vars.value(), new Type[0]);
                if (vars.asInterface()) {
                    writer.beginInterface((Type)simpleType, new Type[0]);
                } else {
                    writer.beginClass((Type)simpleType, null, new Type[0]);
                }
                for (EntityType model : models) {
                    String simpleName;
                    Type queryType = typeMappings.getPathType((Type)model, model, true);
                    String alias = simpleName = model.getUncapSimpleName();
                    if (this.configuration.getKeywords().contains(simpleName.toUpperCase())) {
                        alias = alias + "1";
                    }
                    writer.publicStaticFinal(queryType, simpleName, "new " + queryType.getSimpleName() + "(\"" + alias + "\")");
                }
                writer.end();
            }
            finally {
                w.close();
            }
        }
        catch (IOException e) {
            this.env.getMessager().printMessage(Diagnostic.Kind.ERROR, e.getMessage());
        }
    }
}

